/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutSingleProjectOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CVSProjectSetSerializer
implements IProjectSetSerializer {
    public String[] asReference(IProject[] providerProjects, Object context, IProgressMonitor monitor) throws TeamException {
        String[] result = new String[providerProjects.length];
        for (int i = 0; i < providerProjects.length; ++i) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("1.0,");
            IProject project = providerProjects[i];
            CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project);
            CVSWorkspaceRoot root = provider.getCVSWorkspaceRoot();
            CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)root.getRemoteLocation().getLocation());
            location.setUserMuteable(true);
            String repoLocation = location.getLocation();
            buffer.append(repoLocation);
            buffer.append(",");
            ICVSFolder folder = root.getLocalRoot();
            FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
            String module = syncInfo.getRepository();
            buffer.append(module);
            buffer.append(",");
            String projectName = folder.getName();
            buffer.append(projectName);
            CVSEntryLineTag tag = syncInfo.getTag();
            if (tag != null && tag.getType() != 3) {
                buffer.append(",");
                String tagName = tag.getName();
                buffer.append(tagName);
            }
            result[i] = buffer.toString();
        }
        return result;
    }

    public IProject[] addToWorkspace(String[] referenceStrings, String filename, Object context, IProgressMonitor monitor) throws TeamException {
        IProject[] projects;
        block14: {
            final int size = referenceStrings.length;
            projects = new IProject[size];
            final ICVSRepositoryLocation[] locations = new ICVSRepositoryLocation[size];
            final String[] modules = new String[size];
            final CVSTag[] tags = new CVSTag[size];
            for (int i = 0; i < size; ++i) {
                StringTokenizer tokenizer = new StringTokenizer(referenceStrings[i], ",");
                String version = tokenizer.nextToken();
                if (!version.equals("1.0")) {
                    return null;
                }
                String repo = tokenizer.nextToken();
                locations[i] = this.getLocationFromString(repo);
                modules[i] = tokenizer.nextToken();
                String projectName = tokenizer.nextToken();
                projects[i] = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!tokenizer.hasMoreTokens()) continue;
                String tagName = tokenizer.nextToken();
                tags[i] = new CVSTag(tagName, 1);
            }
            boolean yesToAll = false;
            final int[] num = new int[]{size};
            block8: for (int i = 0; i < size; ++i) {
                int action;
                Shell shell = null;
                IProject project = projects[i];
                if (!project.exists()) continue;
                if (shell == null) {
                    if (context instanceof Shell) {
                        shell = (Shell)context;
                    } else {
                        return null;
                    }
                }
                yesToAll = (action = this.confirmOverwrite(project, yesToAll, shell)) == 2;
                switch (action) {
                    case 1: {
                        locations[i] = null;
                        num[0] = num[0] - 1;
                        continue block8;
                    }
                    case 0: 
                    case 2: {
                        continue block8;
                    }
                    default: {
                        return null;
                    }
                }
            }
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    monitor.beginTask("", 1000 * num[0]);
                    try {
                        for (int i = 0; i < size; ++i) {
                            if (locations[i] == null) continue;
                            RemoteFolder remote = new RemoteFolder(null, locations[i], modules[i], tags[i]);
                            new CheckoutSingleProjectOperation(null, (ICVSRemoteFolder)remote, projects[i], null, true).run((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                op.run(monitor);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof TeamException)) break block14;
                throw (TeamException)t;
            }
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (int i = 0; i < projects.length; ++i) {
            if (projects[i] == null) continue;
            result.add(projects[i]);
        }
        return result.toArray(new IProject[result.size()]);
    }

    private ICVSRepositoryLocation getLocationFromString(String repo) throws CVSException {
        CVSRepositoryLocation newLocation = CVSRepositoryLocation.fromString((String)repo);
        if (newLocation.getUsername() == null || newLocation.getUsername().length() == 0) {
            ICVSRepositoryLocation[] locations = KnownRepositories.getInstance().getRepositories();
            for (int i = 0; i < locations.length; ++i) {
                ICVSRepositoryLocation location = locations[i];
                if (location.getMethod() != newLocation.getMethod() || !location.getHost().equals(newLocation.getHost()) || location.getPort() != newLocation.getPort() || !location.getRootDirectory().equals(newLocation.getRootDirectory())) continue;
                return location;
            }
        }
        return newLocation;
    }

    private int confirmOverwrite(IProject project, boolean yesToAll, Shell shell) {
        if (yesToAll) {
            return 2;
        }
        if (!project.exists()) {
            return 0;
        }
        final MessageDialog dialog = new MessageDialog(shell, Policy.bind("CVSProjectSetSerializer.Confirm_Overwrite_Project_8"), null, Policy.bind("CVSProjectSetSerializer.The_project_{0}_already_exists._Do_you_wish_to_overwrite_it__9", project.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        final int[] result = new int[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = dialog.open();
            }
        });
        return result[0];
    }
}

