/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.ObjectFilterTest;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ObjectActionContributor
extends PluginActionBuilder
implements IObjectActionContributor {
    private static final String ATT_NAME_FILTER = "nameFilter";
    private static final String ATT_ADAPTABLE = "adaptable";
    private static final String P_TRUE = "true";
    private static final String TAG_ENABLEMENT = "enablement";
    private IConfigurationElement config;
    private boolean configRead = false;
    private boolean adaptable = false;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public ObjectActionContributor(IConfigurationElement config) {
        this.config = config;
        this.adaptable = P_TRUE.equalsIgnoreCase(config.getAttribute(ATT_ADAPTABLE));
    }

    public boolean canAdapt() {
        return this.adaptable;
    }

    public void contributeObjectActionIdOverrides(List actionIdOverrides) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions != null) {
            for (int i = 0; i < this.currentContribution.actions.size(); ++i) {
                ActionDescriptor ad = (ActionDescriptor)this.currentContribution.actions.get(i);
                String id = ad.getAction().getOverrideActionId();
                if (id == null) continue;
                actionIdOverrides.add(id);
            }
        }
    }

    public boolean contributeObjectActions(IWorkbenchPart part, IMenuManager menu, ISelectionProvider selProv, List actionIdOverrides) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions == null) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        for (int i = 0; i < this.currentContribution.actions.size(); ++i) {
            ActionDescriptor ad = (ActionDescriptor)this.currentContribution.actions.get(i);
            if (actionIdOverrides.contains(ad.getId())) continue;
            this.currentContribution.contributeMenuAction(ad, menu, true);
            if (!(ad.getAction() instanceof ObjectPluginAction)) continue;
            ObjectPluginAction action = (ObjectPluginAction)ad.getAction();
            action.setActivePart(part);
            action.selectionChanged((ISelection)selection);
        }
        return true;
    }

    public boolean contributeObjectMenus(IMenuManager menu, ISelectionProvider selProv) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.menus == null) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        for (int i = 0; i < this.currentContribution.menus.size(); ++i) {
            IConfigurationElement menuElement = (IConfigurationElement)this.currentContribution.menus.get(i);
            this.currentContribution.contributeMenu(menuElement, menu, true);
        }
        return true;
    }

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        return new ActionDescriptor(element, 1);
    }

    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ObjectContribution();
    }

    public boolean isApplicableTo(Object object) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (!this.testName(object)) {
            return false;
        }
        return ((ObjectContribution)this.currentContribution).isApplicableTo(object);
    }

    private void readConfigElement() {
        this.currentContribution = this.createContribution();
        this.readElementChildren(this.config);
        this.configRead = true;
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals("visibility")) {
            ((ObjectContribution)this.currentContribution).setVisibilityTest(element);
            return true;
        }
        if (tag.equals("filter")) {
            ((ObjectContribution)this.currentContribution).addFilterTest(element);
            return true;
        }
        if (tag.equals(TAG_ENABLEMENT)) {
            ((ObjectContribution)this.currentContribution).setEnablementTest(element);
            return true;
        }
        return super.readElement(element);
    }

    private boolean testName(Object object) {
        IAdaptable element;
        IWorkbenchAdapter de;
        String nameFilter = this.config.getAttribute(ATT_NAME_FILTER);
        if (nameFilter == null) {
            return true;
        }
        String objectName = null;
        if (object instanceof IAdaptable && (de = (IWorkbenchAdapter)(element = (IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ObjectActionContributor.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
            objectName = de.getLabel(element);
        }
        if (objectName == null) {
            objectName = object.toString();
        }
        return SelectionEnabler.verifyNameMatch(objectName, nameFilter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ObjectContribution
    extends PluginActionBuilder.BasicContribution {
        private ObjectFilterTest filterTest;
        private ActionExpression visibilityTest;
        private Expression enablement;

        private ObjectContribution() {
        }

        public void addFilterTest(IConfigurationElement element) {
            if (this.filterTest == null) {
                this.filterTest = new ObjectFilterTest();
            }
            this.filterTest.addFilterElement(element);
        }

        public void setVisibilityTest(IConfigurationElement element) {
            this.visibilityTest = new ActionExpression(element);
        }

        public void setEnablementTest(IConfigurationElement element) {
            try {
                this.enablement = ExpressionConverter.getDefault().perform(element);
            }
            catch (CoreException e) {
                WorkbenchPlugin.getDefault().getLog().log(e.getStatus());
            }
        }

        public boolean isApplicableTo(Object object) {
            boolean result = true;
            if (this.visibilityTest != null) {
                boolean bl = result = result && this.visibilityTest.isEnabledFor(object);
                if (!result) {
                    return result;
                }
            } else if (this.filterTest != null) {
                boolean bl = result = result && this.filterTest.matches(object, true);
                if (!result) {
                    return result;
                }
            }
            if (this.enablement != null) {
                try {
                    EvaluationContext context = new EvaluationContext(null, object);
                    context.addVariable("selection", object);
                    EvaluationResult evalResult = this.enablement.evaluate((IEvaluationContext)context);
                    if (evalResult == EvaluationResult.FALSE) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    this.enablement = null;
                    WorkbenchPlugin.getDefault().getLog().log(e.getStatus());
                    result = false;
                }
            }
            return result;
        }
    }
}

