/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.CheckedInHandler;
import org.eclipse.team.internal.ccvs.core.client.CopyHandler;
import org.eclipse.team.internal.ccvs.core.client.ExpandModules;
import org.eclipse.team.internal.ccvs.core.client.MTHandler;
import org.eclipse.team.internal.ccvs.core.client.ModTimeHandler;
import org.eclipse.team.internal.ccvs.core.client.ModuleExpansionHandler;
import org.eclipse.team.internal.ccvs.core.client.NewEntryHandler;
import org.eclipse.team.internal.ccvs.core.client.NotifiedHandler;
import org.eclipse.team.internal.ccvs.core.client.RemoveEntryHandler;
import org.eclipse.team.internal.ccvs.core.client.RemovedHandler;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.StaticHandler;
import org.eclipse.team.internal.ccvs.core.client.StickyHandler;
import org.eclipse.team.internal.ccvs.core.client.TemplateHandler;
import org.eclipse.team.internal.ccvs.core.client.UpdatedHandler;
import org.eclipse.team.internal.ccvs.core.client.ValidRequests;
import org.eclipse.team.internal.ccvs.core.client.ValidRequestsHandler;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;

public abstract class Request {
    public static final ExpandModules EXPAND_MODULES = new ExpandModules();
    public static final ValidRequests VALID_REQUESTS = new ValidRequests();
    private static final Map responseHandlers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeHandlerCache() {
        Map map = responseHandlers;
        synchronized (map) {
            Request.registerResponseHandler(new CheckedInHandler());
            Request.registerResponseHandler(new CopyHandler());
            Request.registerResponseHandler(new ModTimeHandler());
            Request.registerResponseHandler(new NewEntryHandler());
            Request.registerResponseHandler(new RemovedHandler());
            Request.registerResponseHandler(new RemoveEntryHandler());
            Request.registerResponseHandler(new StaticHandler(true));
            Request.registerResponseHandler(new StaticHandler(false));
            Request.registerResponseHandler(new StickyHandler(true));
            Request.registerResponseHandler(new StickyHandler(false));
            Request.registerResponseHandler(new UpdatedHandler(1));
            Request.registerResponseHandler(new UpdatedHandler(3));
            Request.registerResponseHandler(new UpdatedHandler(4));
            Request.registerResponseHandler(new UpdatedHandler(2));
            Request.registerResponseHandler(new ValidRequestsHandler());
            Request.registerResponseHandler(new ModuleExpansionHandler());
            Request.registerResponseHandler(new MTHandler());
            Request.registerResponseHandler(new NotifiedHandler());
            Request.registerResponseHandler(new TemplateHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerResponseHandler(ResponseHandler handler) {
        Map map = responseHandlers;
        synchronized (map) {
            responseHandlers.put(handler.getResponseID(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map getReponseHandlerMap() {
        Map map = responseHandlers;
        synchronized (map) {
            if (responseHandlers.isEmpty()) {
                Request.initializeHandlerCache();
            }
            HashMap<String, ResponseHandler> copy = new HashMap<String, ResponseHandler>();
            Iterator iter = responseHandlers.values().iterator();
            while (iter.hasNext()) {
                ResponseHandler handler = (ResponseHandler)iter.next();
                copy.put(handler.getResponseID(), handler.getInstance());
            }
            return copy;
        }
    }

    protected Request() {
    }

    protected abstract String getRequestId();

    protected IStatus executeRequest(Session session, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        ArrayList<CVSStatus> accumulatedStatus;
        block20: {
            String argument;
            String response;
            int currentIncrement;
            session.sendRequest(this.getRequestId());
            int TOTAL_WORK = 300;
            monitor.beginTask(Policy.bind("Command.receivingResponses"), 300);
            int halfWay = 150;
            int nextProgress = currentIncrement = 4;
            int worked = 0;
            boolean isCVSNT = session.isCVSNT();
            accumulatedStatus = new ArrayList<CVSStatus>();
            while (true) {
                IConsoleListener consoleListener;
                IStatus status;
                ResponseHandler handler;
                if (--nextProgress <= 0) {
                    monitor.worked(1);
                    if (++worked >= halfWay) {
                        currentIncrement *= 2;
                        halfWay += (300 - halfWay) / 2;
                    }
                    nextProgress = currentIncrement;
                }
                Policy.checkCanceled(monitor);
                response = session.readLine();
                int spacePos = response.indexOf(32);
                if (spacePos != -1) {
                    argument = response.substring(spacePos + 1);
                    response = response.substring(0, spacePos);
                } else {
                    argument = "";
                }
                if (response.equals("ok")) break block20;
                if (response.equals("error") || isCVSNT && response.equals("")) {
                    argument = argument.trim();
                    boolean serious = false;
                    if (argument.length() == 0) {
                        argument = this.getServerErrorMessage();
                    } else {
                        argument = Policy.bind("Command.seriousServerError", argument);
                        if (!accumulatedStatus.isEmpty()) {
                            accumulatedStatus.add(new CVSStatus(4, -10, argument));
                        }
                        serious = true;
                    }
                    if (accumulatedStatus.isEmpty()) {
                        accumulatedStatus.add(new CVSStatus(4, -10, Policy.bind("Command.noMoreInfoAvailable")));
                    }
                    MultiStatus status2 = new MultiStatus("org.eclipse.team.cvs.core", -10, accumulatedStatus.toArray(new IStatus[accumulatedStatus.size()]), argument, null);
                    if (serious) {
                        throw new CVSServerException((IStatus)status2);
                    }
                    Iterator iter = accumulatedStatus.iterator();
                    while (iter.hasNext()) {
                        IStatus s = (IStatus)iter.next();
                        if (s.getCode() != -23) continue;
                        throw new CVSServerException((IStatus)status2);
                    }
                    return status2;
                }
                if (response.equals("MT")) {
                    IConsoleListener consoleListener2;
                    handler = (MTHandler)session.getResponseHandler(response);
                    if (handler == null) {
                        throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -4, Policy.bind("Command.unsupportedResponse", response, argument), null));
                    }
                    ((MTHandler)handler).handle(session, argument, monitor);
                    if (!((MTHandler)handler).isLineAvailable()) continue;
                    String line = ((MTHandler)handler).getLine();
                    IStatus status3 = listener.messageLine(line, session.getCVSRepositoryLocation(), session.getLocalRoot(), monitor);
                    if (status3 != ICommandOutputListener.OK) {
                        accumulatedStatus.add((CVSStatus)status3);
                    }
                    if (!session.isOutputToConsole() || (consoleListener2 = CVSProviderPlugin.getPlugin().getConsoleListener()) == null) continue;
                    consoleListener2.messageLineReceived(line);
                    continue;
                }
                if (response.equals("M")) {
                    status = listener.messageLine(argument, session.getCVSRepositoryLocation(), session.getLocalRoot(), monitor);
                    if (status != ICommandOutputListener.OK) {
                        accumulatedStatus.add((CVSStatus)status);
                    }
                    if (!session.isOutputToConsole() || (consoleListener = CVSProviderPlugin.getPlugin().getConsoleListener()) == null) continue;
                    consoleListener.messageLineReceived(argument);
                    continue;
                }
                if (response.equals("E")) {
                    status = listener.errorLine(argument, session.getCVSRepositoryLocation(), session.getLocalRoot(), monitor);
                    if (status != ICommandOutputListener.OK) {
                        accumulatedStatus.add((CVSStatus)status);
                    }
                    if (!session.isOutputToConsole() || (consoleListener = CVSProviderPlugin.getPlugin().getConsoleListener()) == null) continue;
                    consoleListener.errorLineReceived(argument);
                    continue;
                }
                handler = session.getResponseHandler(response);
                if (handler == null) break;
                handler.handle(session, argument, monitor);
            }
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -4, Policy.bind("Command.unsupportedResponse", response, argument), null));
        }
        if (accumulatedStatus.isEmpty()) {
            return ICommandOutputListener.OK;
        }
        return new MultiStatus("org.eclipse.team.cvs.core", 1, accumulatedStatus.toArray(new IStatus[accumulatedStatus.size()]), Policy.bind("Command.warnings", Policy.bind("Command." + this.getRequestId())), null);
    }

    protected String getServerErrorMessage() {
        return Policy.bind("Command.serverError", Policy.bind("Command." + this.getRequestId()));
    }
}

