/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CreateFileChange
extends JDTChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;

    public CreateFileChange(IPath path, String source, String encoding) {
        Assert.isNotNull(path, "path");
        Assert.isNotNull(source, "source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
    }

    private CreateFileChange(IPath path, String source, String encoding, boolean explicit) {
        Assert.isNotNull(path, "path");
        Assert.isNotNull(source, "source");
        Assert.isNotNull(encoding, "encoding");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull(encoding, "encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) {
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        DeleteFileChange composite2;
        InputStream is;
        block12: {
            Change change;
            block11: {
                is = null;
                try {
                    pm.beginTask(NLSChangesMessages.getString("createFile.creating_resource"), 3);
                    this.initializeEncoding();
                    IFile file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (file.exists()) {
                        CompositeChange composite2 = new CompositeChange(this.getName());
                        composite2.add((Change)new DeleteFileChange(file));
                        composite2.add((Change)new CreateFileChange(this.fPath, this.fSource, this.fEncoding, this.fExplicitEncoding));
                        pm.worked(1);
                        change = composite2.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        Object var7_8 = null;
                        break block11;
                    }
                    try {
                        is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                        file.create(is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        if (this.fExplicitEncoding) {
                            file.setCharset(this.fEncoding, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        } else {
                            pm.worked(1);
                        }
                        composite2 = new DeleteFileChange(file);
                        break block12;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JavaModelException((Throwable)e, 985);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    pm.done();
                    try {
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException((Throwable)ioe, 985);
                    }
                }
            }
            pm.done();
            try {}
            catch (IOException ioe) {
                throw new JavaModelException((Throwable)ioe, 985);
            }
            if (is == null) return change;
            is.close();
            return change;
        }
        Object var7_9 = null;
        pm.done();
        try {}
        catch (IOException ioe) {
            throw new JavaModelException((Throwable)ioe, 985);
        }
        if (is == null) return composite2;
        is.close();
        return composite2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IFile getOldFile(IProgressMonitor pm) {
        pm.beginTask("", 1);
        try {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            return iFile;
        }
        finally {
            pm.done();
        }
    }

    private void initializeEncoding() {
        block8: {
            if (this.fEncoding == null) {
                this.fExplicitEncoding = false;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
                if (file != null) {
                    try {
                        if (file.exists()) {
                            this.fEncoding = file.getCharset(false);
                            if (this.fEncoding == null) {
                                this.fEncoding = file.getCharset(true);
                            } else {
                                this.fExplicitEncoding = true;
                            }
                            break block8;
                        }
                        this.fEncoding = file.getCharset(true);
                    }
                    catch (CoreException e) {
                        this.fEncoding = ResourcesPlugin.getEncoding();
                        this.fExplicitEncoding = true;
                    }
                } else {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            }
        }
        Assert.isNotNull(this.fEncoding);
    }

    public String getName() {
        if (this.fChangeName == null) {
            return NLSChangesMessages.getString("createFile.Create_file") + this.fPath.toString();
        }
        return this.fChangeName;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    protected String getSource() {
        return this.fSource;
    }

    public void setName(String name) {
        this.fChangeName = name;
    }
}

