/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class AddArgumentCorrectionProposal
extends LinkedCorrectionProposal {
    private int[] fInsertIndexes;
    private ITypeBinding[] fParamTypes;
    private ASTNode fCallerNode;

    public AddArgumentCorrectionProposal(String label, ICompilationUnit cu, ASTNode callerNode, int[] insertIdx, ITypeBinding[] expectedTypes, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fCallerNode = callerNode;
        this.fInsertIndexes = insertIdx;
        this.fParamTypes = expectedTypes;
    }

    protected ASTRewrite getRewrite() {
        AST ast = this.fCallerNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ChildListPropertyDescriptor property = this.getProperty();
        for (int i = 0; i < this.fInsertIndexes.length; ++i) {
            int idx = this.fInsertIndexes[i];
            String key = "newarg_" + i;
            Expression newArg = this.evaluateArgumentExpressions(ast, this.fParamTypes[idx], key);
            ListRewrite listRewriter = rewrite.getListRewrite(this.fCallerNode, property);
            listRewriter.insertAt((ASTNode)newArg, idx, null);
            this.addLinkedPosition(rewrite.track((ASTNode)newArg), i == 0, key);
        }
        return rewrite;
    }

    private ChildListPropertyDescriptor getProperty() {
        List list = this.fCallerNode.structuralPropertiesForType();
        for (int i = 0; i < list.size(); ++i) {
            StructuralPropertyDescriptor curr = (StructuralPropertyDescriptor)list.get(i);
            if (!curr.isChildListProperty() || !"arguments".equals(curr.getId())) continue;
            return (ChildListPropertyDescriptor)curr;
        }
        return null;
    }

    private Expression evaluateArgumentExpressions(AST ast, ITypeBinding requiredType, String key) {
        CompilationUnit root = (CompilationUnit)this.fCallerNode.getRoot();
        int offset = this.fCallerNode.getStartPosition();
        Expression best = null;
        ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
        IBinding[] bindings = analyzer.getDeclarationsInScope(offset, 2);
        for (int i = 0; i < bindings.length; ++i) {
            IVariableBinding curr = (IVariableBinding)bindings[i];
            ITypeBinding type = curr.getType();
            if (type == null || !TypeRules.canAssign(type, requiredType) || !this.testModifier(curr)) continue;
            if (best == null) {
                best = ast.newSimpleName(curr.getName());
            }
            this.addLinkedPositionProposal(key, curr.getName(), null);
        }
        Expression defaultExpression = ASTNodeFactory.newDefaultExpression(ast, requiredType);
        if (best == null) {
            best = defaultExpression;
        }
        this.addLinkedPositionProposal(key, ASTNodes.asString((ASTNode)defaultExpression), null);
        return best;
    }

    private boolean testModifier(IVariableBinding curr) {
        int staticFinal;
        int modifiers = curr.getModifiers();
        if ((modifiers & (staticFinal = 24)) == staticFinal) {
            return false;
        }
        return !Modifier.isStatic(modifiers) || ASTResolving.isInStaticContext(this.fCallerNode);
    }
}

