/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.search.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.view.DependenciesContentProvider;
import org.eclipse.pde.internal.ui.view.DependenciesLabelProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class DependenciesView
extends ViewPart {
    private TreeViewer treeViewer;
    private DrillDownAdapter drillDownAdapter;
    private Action openAction;
    private FocusOnSelectionAction focusOnSelectionAction;
    private Action focusOnAction;
    private IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("Preferences.MainPage.showObjects")) {
                DependenciesView.this.treeViewer.refresh();
            }
        }
    };

    public void dispose() {
        PDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyListener);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.treeViewer);
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        this.treeViewer.setContentProvider((IContentProvider)new DependenciesContentProvider(this, manager));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DependenciesLabelProvider());
        this.treeViewer.setSorter(ListUtil.PLUGIN_SORTER);
        this.treeViewer.setAutoExpandLevel(2);
        this.makeActions();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.contributeToActionBars(actionBars);
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                DependenciesView.this.handleSelectionChanged(e.getSelection());
            }
        });
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        WorkbenchHelp.setHelp((Control)this.treeViewer.getControl(), (String)"org.eclipse.pde.doc.user.dependencies_view");
    }

    private void contributeToActionBars(IActionBars actionBars) {
        this.contributeToLocalToolBar(actionBars.getToolBarManager());
        this.contributeToDropDownMenu(actionBars.getMenuManager());
    }

    private void contributeToDropDownMenu(IMenuManager manager) {
    }

    private void contributeToLocalToolBar(IToolBarManager manager) {
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                DependenciesView.this.handleDoubleClick();
            }

            public void update(Object object) {
            }
        };
        this.openAction.setText(PDEPlugin.getResourceString("DependenciesView.open"));
        this.focusOnSelectionAction = new FocusOnSelectionAction();
        this.focusOnAction = new Action(){

            public void run() {
                DependenciesView.this.handleFocusOn();
            }
        };
        this.focusOnAction.setText(PDEPlugin.getResourceString("DependenciesView.focusOn"));
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() == 1) {
            manager.add((IAction)this.openAction);
            manager.add((IContributionItem)new Separator());
        }
        this.focusOnSelectionAction.update(this.getSelectedObject());
        if (this.focusOnSelectionAction.isEnabled()) {
            manager.add((IAction)this.focusOnSelectionAction);
        }
        manager.add((IAction)this.focusOnAction);
        if (selection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
            actionGroup.setContext(new ActionContext((ISelection)selection));
            actionGroup.fillContextMenu(manager);
        }
        if (this.treeViewer.getInput() instanceof WorkspacePluginModelBase) {
            manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)((WorkspacePluginModelBase)this.treeViewer.getInput())));
        }
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DependenciesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void handleDoubleClick() {
        IPlugin plugin;
        Object obj = this.getSelectedObject();
        if (obj instanceof ImportObject && (plugin = ((ImportObject)obj).getPlugin()) != null) {
            obj = plugin;
        }
        if (obj instanceof IPluginBase) {
            ManifestEditor.openPluginEditor((IPluginBase)obj);
        }
    }

    private void handleFocusOn(Object newFocus) {
        ImportObject iimport;
        IPlugin plugin;
        if (newFocus instanceof IPluginModelBase) {
            this.openTo(newFocus);
        }
        if (newFocus instanceof IPluginBase) {
            this.openTo(((IPluginBase)newFocus).getModel());
        }
        if (newFocus instanceof ImportObject && (plugin = (iimport = (ImportObject)newFocus).getPlugin()) != null) {
            this.openTo(plugin.getModel());
        }
    }

    private void handleFocusOn() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.treeViewer.getControl().getShell(), true, false);
        dialog.create();
        if (dialog.open() == 0) {
            this.handleFocusOn(dialog.getFirstResult());
        }
    }

    private void handleSelectionChanged(ISelection selection) {
    }

    private void hookDoubleClickAction() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DependenciesView.this.handleDoubleClick();
            }
        });
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    void updateTitle(Object newInput) {
        IConfigurationElement config = this.getConfigurationElement();
        if (config == null) {
            return;
        }
        String viewName = config.getAttribute("name");
        if (newInput == null || newInput.equals(PDECore.getDefault().getModelManager())) {
            this.setTitle(viewName);
            this.setTitleToolTip(this.getTitle());
        } else {
            String name = ((LabelProvider)this.treeViewer.getLabelProvider()).getText(newInput);
            this.setTitle(viewName + ": " + name);
            this.setTitleToolTip(this.getTitle());
        }
    }

    public void openTo(Object object) {
        this.treeViewer.setInput(object);
    }

    class FocusOnSelectionAction
    extends Action {
        FocusOnSelectionAction() {
        }

        public void run() {
            DependenciesView.this.handleFocusOn(DependenciesView.this.getSelectedObject());
        }

        public void update(Object object) {
            this.setEnabled(object != null);
            String name = ((LabelProvider)DependenciesView.this.treeViewer.getLabelProvider()).getText(object);
            this.setText(PDEPlugin.getFormattedMessage("DependenciesView.focusOnSelection", name));
        }
    }
}

