/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.util.HelpProperties;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.ParsedDocument;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.QueryBuilder;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.help.internal.util.ResourceLocator;
import org.osgi.framework.Bundle;

public class SearchIndex {
    private IndexReader ir;
    private IndexWriter iw;
    private File indexDir;
    private String locale;
    private TocManager tocManager;
    private AnalyzerDescriptor analyzerDescriptor;
    private PluginVersionInfo docPlugins;
    private HelpProperties indexedDocs;
    private static final String INDEXED_CONTRIBUTION_INFO_FILE = "indexed_contributions";
    public static final String INDEXED_DOCS_FILE = "indexed_docs";
    private static final String DEPENDENCIES_VERSION_FILENAME = "indexed_dependencies";
    private static final String LUCENE_PLUGIN_ID = "org.apache.lucene";
    private File inconsistencyFile;
    private HTMLDocParser parser;
    private IndexSearcher searcher;
    private Object searcherCreateLock;
    private HelpProperties dependencies;
    private boolean closed;
    private Collection searches;
    private FileLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchIndex(String locale, AnalyzerDescriptor analyzerDesc, TocManager tocManager) {
        block6: {
            this.searcherCreateLock = new Object();
            this.closed = false;
            this.searches = new ArrayList();
            this.locale = locale;
            this.analyzerDescriptor = analyzerDesc;
            this.tocManager = tocManager;
            this.indexDir = new File(HelpBasePlugin.getConfigurationDirectory(), "index/" + locale);
            this.inconsistencyFile = new File(this.indexDir.getParentFile(), locale + ".inconsistent");
            this.parser = new HTMLDocParser();
            if (!this.exists()) {
                try {
                    if (!this.tryLock()) break block6;
                    try {
                        this.unzipProductIndex();
                    }
                    finally {
                        this.releaseLock();
                    }
                }
                catch (OverlappingFileLockException ofle) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addDocument(String name, URL url) {
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.addDocument(" + name + ", " + url + ")");
        }
        try {
            Document doc = new Document();
            doc.add(Field.Keyword((String)"name", (String)name));
            try {
                try {
                    this.parser.openDocument(url);
                }
                catch (IOException ioe) {
                    HelpBasePlugin.logError(HelpBaseResources.getString("ES25", name), null);
                    boolean bl = false;
                    this.parser.closeDocument();
                    return bl;
                }
                ParsedDocument parsed = new ParsedDocument(this.parser.getContentReader());
                doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
                doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
                String title = this.parser.getTitle();
                doc.add(Field.UnStored((String)"title", (String)title));
                doc.add(Field.UnStored((String)"exact_title", (String)title));
                doc.add(Field.UnIndexed((String)"raw_title", (String)title));
                this.iw.addDocument(doc);
            }
            finally {
                this.parser.closeDocument();
            }
            this.indexedDocs.put(name, "0");
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES16", name, this.indexDir.getAbsolutePath()), e);
            return false;
        }
    }

    public synchronized boolean beginAddBatch() {
        try {
            if (this.iw != null) {
                this.iw.close();
            }
            boolean create = false;
            if (!this.exists()) {
                create = true;
                this.indexDir.mkdirs();
                if (!this.indexDir.exists()) {
                    return false;
                }
            }
            this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.iw = new IndexWriter(this.indexDir, this.analyzerDescriptor.getAnalyzer(), create);
            this.iw.mergeFactor = 20;
            this.iw.maxFieldLength = 1000000;
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES17"), e);
            return false;
        }
    }

    public synchronized boolean beginDeleteBatch() {
        try {
            if (this.ir != null) {
                this.ir.close();
            }
            this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.ir = IndexReader.open((File)this.indexDir);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES18"), e);
            return false;
        }
    }

    public boolean removeDocument(String name) {
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.removeDocument(" + name + ")");
        }
        Term term = new Term("name", name);
        try {
            this.ir.delete(term);
            this.indexedDocs.remove(name);
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES22", name, this.indexDir.getAbsolutePath()), e);
            return false;
        }
        return true;
    }

    public synchronized boolean endAddBatch() {
        try {
            if (this.iw == null) {
                return false;
            }
            this.iw.optimize();
            this.iw.close();
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveDependencies();
            this.setInconsistent(false);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES19"), e);
            return false;
        }
    }

    public synchronized boolean endDeleteBatch() {
        try {
            if (this.ir == null) {
                return false;
            }
            this.ir.close();
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveDependencies();
            this.setInconsistent(false);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES20"), e);
            return false;
        }
    }

    public boolean exists() {
        return this.indexDir.exists() && !this.isInconsistent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(ISearchQuery searchQuery, ISearchHitCollector collector) throws QueryTooComplexException {
        try {
            if (this.closed) {
                return;
            }
            this.registerSearch(Thread.currentThread());
            if (this.closed) {
                return;
            }
            QueryBuilder queryBuilder = new QueryBuilder(searchQuery.getSearchWord(), this.analyzerDescriptor);
            Query luceneQuery = queryBuilder.getLuceneQuery(searchQuery.getFieldNames(), searchQuery.isFieldSearch());
            String highlightTerms = queryBuilder.gethighlightTerms();
            if (luceneQuery != null) {
                if (this.searcher == null) {
                    this.openSearcher();
                }
                Hits hits = this.searcher.search(luceneQuery);
                collector.addHits(hits, highlightTerms);
            }
        }
        catch (QueryTooComplexException qe) {
            throw qe;
        }
        catch (Exception e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES21", searchQuery.getSearchWord()), e);
        }
        finally {
            this.unregisterSearch(Thread.currentThread());
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public PluginVersionInfo getDocPlugins() {
        if (this.docPlugins == null) {
            Collection docPluginsIds = this.tocManager.getContributingPlugins();
            this.docPlugins = new PluginVersionInfo(INDEXED_CONTRIBUTION_INFO_FILE, docPluginsIds, this.indexDir, !this.exists());
        }
        return this.docPlugins;
    }

    public HelpProperties getIndexedDocs() {
        HelpProperties indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
        if (this.exists()) {
            indexedDocs.restore();
        }
        return indexedDocs;
    }

    private HelpProperties getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HelpProperties(DEPENDENCIES_VERSION_FILENAME, this.indexDir);
            this.dependencies.restore();
        }
        return this.dependencies;
    }

    private String readAnalyzerId() {
        String analyzerVersion = this.getDependencies().getProperty("analyzer");
        if (analyzerVersion == null) {
            return "";
        }
        return analyzerVersion;
    }

    private boolean isLuceneCompatible() {
        String usedLuceneVersion = this.getDependencies().getProperty("lucene");
        String currentLuceneVersion = "";
        Bundle lucenePluginDescriptor = Platform.getBundle((String)LUCENE_PLUGIN_ID);
        if (lucenePluginDescriptor != null) {
            currentLuceneVersion = currentLuceneVersion + (String)lucenePluginDescriptor.getHeaders().get("Bundle-Version");
        }
        return currentLuceneVersion.equals(usedLuceneVersion);
    }

    private void saveDependencies() {
        this.getDependencies().put("analyzer", this.analyzerDescriptor.getId());
        Bundle luceneBundle = Platform.getBundle((String)LUCENE_PLUGIN_ID);
        if (luceneBundle != null) {
            String luceneBundleVersion = "" + luceneBundle.getHeaders().get("Bundle-Version");
            this.getDependencies().put("lucene", luceneBundleVersion);
        } else {
            this.getDependencies().put("lucene", "");
        }
        this.getDependencies().save();
    }

    public boolean isInconsistent() {
        if (this.inconsistencyFile.exists()) {
            return true;
        }
        return !this.isLuceneCompatible() || !this.analyzerDescriptor.isCompatible(this.readAnalyzerId());
    }

    public void setInconsistent(boolean inconsistent) {
        if (inconsistent) {
            try {
                FileOutputStream fos = new FileOutputStream(this.inconsistencyFile);
                fos.close();
            }
            catch (IOException iOException) {}
        } else {
            this.inconsistencyFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSearcher() throws IOException {
        Object object = this.searcherCreateLock;
        synchronized (object) {
            if (this.searcher == null) {
                this.searcher = new IndexSearcher(this.indexDir.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        Collection collection = this.searches;
        synchronized (collection) {
            while (this.searches.size() > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {}
            }
            if (this.searcher != null) {
                try {
                    this.searcher.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void unzipProductIndex() {
        block21: {
            FileOutputStream fos;
            ZipInputStream zis;
            InputStream zipIn;
            block20: {
                ZipEntry zEntry;
                String indexPluginId = HelpBasePlugin.getDefault().getPluginPreferences().getString("productIndex");
                if (indexPluginId == null || indexPluginId.length() <= 0) {
                    return;
                }
                zipIn = ResourceLocator.openFromPlugin((String)indexPluginId, (String)"doc_index.zip", (String)this.getLocale());
                if (zipIn == null) {
                    return;
                }
                byte[] buf = new byte[8192];
                File destDir = this.indexDir;
                zis = new ZipInputStream(zipIn);
                fos = null;
                while ((zEntry = zis.getNextEntry()) != null) {
                    if (zEntry.isDirectory()) {
                        new File(destDir, zEntry.getName()).mkdirs();
                        continue;
                    }
                    String filePath = zEntry.getName();
                    int lastSeparator = filePath.lastIndexOf("/");
                    String fileDir = "";
                    if (lastSeparator >= 0) {
                        fileDir = filePath.substring(0, lastSeparator);
                    }
                    new File(destDir, fileDir).mkdirs();
                    File outFile = new File(destDir, filePath);
                    fos = new FileOutputStream(outFile);
                    int n = 0;
                    while ((n = zis.read(buf)) >= 0) {
                        fos.write(buf, 0, n);
                    }
                    fos.close();
                }
                if (!HelpBasePlugin.DEBUG_SEARCH) break block20;
                System.out.println("SearchIndex: Prebuilt index restored to " + destDir + ".");
            }
            Object var14_15 = null;
            try {
                zipIn.close();
                if (zis != null) {
                    zis.close();
                }
                break block21;
            }
            catch (IOException ioe2) {}
            break block21;
            {
                catch (IOException ioe) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe2) {
                        }
                    }
                    Object var14_16 = null;
                    try {
                        zipIn.close();
                        if (zis != null) {
                            zis.close();
                        }
                        break block21;
                    }
                    catch (IOException ioe2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    zipIn.close();
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public synchronized boolean needsUpdating() {
        if (!this.exists()) {
            return true;
        }
        return this.getDocPlugins().detectChange();
    }

    public TocManager getTocManager() {
        return this.tocManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearch(Thread t) {
        Collection collection = this.searches;
        synchronized (collection) {
            this.searches.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSearch(Thread t) {
        Collection collection = this.searches;
        synchronized (collection) {
            this.searches.remove(t);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean tryLock() throws OverlappingFileLockException {
        if (this.lock != null) {
            throw new OverlappingFileLockException();
        }
        File lockFile = new File(this.indexDir.getParentFile(), this.locale + ".lock");
        lockFile.getParentFile().mkdirs();
        try {
            RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
            FileLock l = raf.getChannel().tryLock();
            if (l != null) {
                this.lock = l;
                return true;
            }
        }
        catch (IOException ioe) {
            this.lock = null;
        }
        return false;
    }

    public synchronized void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lock = null;
        }
    }
}

