/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.FeatureTypeFactory;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public class FeatureReference
extends FeatureReferenceModel
implements IFeatureReference,
IPlatformEnvironment {
    private VersionedIdentifier versionId;
    private IFeature exactFeature;

    public FeatureReference() {
    }

    public FeatureReference(IFeatureReference ref) {
        super((FeatureReferenceModel)((Object)ref));
        try {
            this.setURL(ref.getURL());
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
        }
    }

    public FeatureReference(FeatureReferenceModel ref) {
        super(ref);
        try {
            this.setURL(ref.getURL());
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
        }
    }

    public IFeature getFeature() throws CoreException {
        return this.getFeature(null);
    }

    public IFeature getFeature(IProgressMonitor monitor) throws CoreException {
        if (this.exactFeature != null) {
            return this.exactFeature;
        }
        this.exactFeature = this.getFeature(this, monitor);
        return this.exactFeature;
    }

    protected IFeature getFeature(IFeatureReference ref, IProgressMonitor monitor) throws CoreException {
        IFeature feature = null;
        URL refURL = ref.getURL();
        feature = this.createFeature(refURL, monitor);
        return feature;
    }

    private IFeature createFeature(URL url, IProgressMonitor monitor) throws CoreException {
        String type = this.getType();
        ISite site = this.getSite();
        if (site != null) {
            return site.createFeature(type, url, monitor);
        }
        IFeatureFactory factory = FeatureTypeFactory.getInstance().getFactory(type);
        return factory.createFeature(url, site, monitor);
    }

    public ISite getSite() {
        return (ISite)((Object)this.getSiteModel());
    }

    public void setURL(URL url) throws CoreException {
        if (url != null) {
            this.setURLString(url.toExternalForm());
            try {
                this.resolve(url, null);
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("FeatureReference.UnableToResolveURL", url.toExternalForm()), e);
            }
        }
    }

    public void setSite(ISite site) {
        this.setSiteModel((SiteModel)((Object)site));
    }

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String id = this.getFeatureIdentifier();
        String ver = this.getFeatureVersion();
        if (id != null && ver != null) {
            try {
                this.versionId = new VersionedIdentifier(id, ver);
                return this.versionId;
            }
            catch (Exception e) {
                UpdateCore.warn("Unable to create versioned identifier:" + id + ":" + ver);
            }
        }
        this.versionId = new VersionedIdentifier(this.getURL().toExternalForm(), null);
        try {
            this.versionId = this.getFeature(null).getVersionedIdentifier();
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
        }
        return this.versionId;
    }

    public String getName() {
        if (super.getLabel() != null) {
            return super.getLabel();
        }
        try {
            return this.getFeature(null).getLabel();
        }
        catch (CoreException e) {
            return this.getVersionedIdentifier().toString();
        }
    }

    public String getOS() {
        if (super.getOS() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getOS();
            }
            catch (CoreException e) {
                return null;
            }
        }
        return super.getOS();
    }

    public String getWS() {
        if (super.getWS() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getWS();
            }
            catch (CoreException e) {
                return null;
            }
        }
        return super.getWS();
    }

    public String getOSArch() {
        if (super.getOSArch() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getOSArch();
            }
            catch (CoreException e) {
                return null;
            }
        }
        return super.getOSArch();
    }

    public String getNL() {
        if (super.getNL() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getNL();
            }
            catch (CoreException e) {
                return null;
            }
        }
        return super.getNL();
    }

    public boolean isPatch() {
        if (super.getPatch() == null) {
            try {
                return this.getFeature(null).isPatch();
            }
            catch (CoreException e) {
                return false;
            }
        }
        return "true".equalsIgnoreCase(super.getPatch());
    }
}

