/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ActionContributionItem
extends ContributionItem {
    public static int MODE_FORCE_TEXT = 1;
    private static final int LOWER_GTK_ACCEL_BOUND = SWT.MOD1 | SWT.MOD2 | 0x41;
    private static final int UPPER_GTK_ACCEL_BOUND = SWT.MOD1 | SWT.MOD2 | 0x46;
    private static final String ellipsis = "...";
    private static ImageCache globalImageCache;
    private static boolean USE_COLOR_ICONS;
    private int mode = 0;
    private IAction action;
    private final IPropertyChangeListener actionTextListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ActionContributionItem.this.update(event.getProperty());
        }
    };
    private Listener buttonListener;
    private Listener menuItemListener;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ActionContributionItem.this.actionPropertyChange(event);
        }
    };
    private Listener toolItemListener;
    private Widget widget = null;

    public static boolean getUseColorIconsInToolbars() {
        return USE_COLOR_ICONS;
    }

    public static void setUseColorIconsInToolbars(boolean useColorIcons) {
        USE_COLOR_ICONS = useColorIcons;
    }

    public ActionContributionItem(IAction action) {
        super(action.getId());
        this.action = action;
    }

    private void actionPropertyChange(final PropertyChangeEvent e) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(e.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    public void run() {
                        ActionContributionItem.this.update(e.getProperty());
                    }
                });
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ActionContributionItem)) {
            return false;
        }
        return this.action.equals(((ActionContributionItem)o).action);
    }

    public void fill(Composite parent) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            if (this.action != null) {
                if (this.action.getStyle() == 2) {
                    flags = 2;
                }
                if (this.action.getStyle() == 8) {
                    flags = 16;
                }
            }
            Button b = new Button(parent, flags);
            b.setData((Object)this);
            b.addListener(12, this.getButtonListener());
            b.addListener(13, this.getButtonListener());
            if (this.action.getHelpListener() != null) {
                b.addHelpListener(this.action.getHelpListener());
            }
            this.widget = b;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String commandId = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && commandId != null) {
                    callback.addPropertyChangeListener(commandId, this.actionTextListener);
                }
            }
        }
    }

    public void fill(Menu parent, int index) {
        if (this.widget == null && parent != null) {
            Menu subMenu = null;
            int flags = 8;
            if (this.action != null) {
                IMenuCreator mc;
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 8) {
                    flags = 16;
                } else if (style == 4 && (mc = this.action.getMenuCreator()) != null) {
                    subMenu = mc.getMenu(parent);
                    flags = 64;
                }
            }
            MenuItem mi = null;
            mi = index >= 0 ? new MenuItem(parent, flags, index) : new MenuItem(parent, flags);
            this.widget = mi;
            mi.setData((Object)this);
            mi.addListener(12, this.getMenuItemListener());
            mi.addListener(13, this.getMenuItemListener());
            if (this.action.getHelpListener() != null) {
                mi.addHelpListener(this.action.getHelpListener());
            }
            if (subMenu != null) {
                mi.setMenu(subMenu);
            }
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String commandId = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && commandId != null) {
                    callback.addPropertyChangeListener(commandId, this.actionTextListener);
                }
            }
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            if (this.action != null) {
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 8) {
                    flags = 16;
                } else if (style == 4) {
                    flags = 4;
                }
            }
            ToolItem ti = null;
            ti = index >= 0 ? new ToolItem(parent, flags, index) : new ToolItem(parent, flags);
            ti.setData((Object)this);
            ti.addListener(13, this.getToolItemListener());
            ti.addListener(12, this.getToolItemListener());
            this.widget = ti;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String commandId = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && commandId != null) {
                    callback.addPropertyChangeListener(commandId, this.actionTextListener);
                }
            }
        }
    }

    public IAction getAction() {
        return this.action;
    }

    private Listener getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((Button)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.buttonListener;
    }

    private static ImageCache getImageCache() {
        ImageCache cache = globalImageCache;
        if (cache == null) {
            globalImageCache = cache = new ImageCache();
            Display display = Display.getDefault();
            if (display != null) {
                display.disposeExec(new Runnable(){

                    public void run() {
                        if (globalImageCache != null) {
                            globalImageCache.dispose();
                            globalImageCache = null;
                        }
                    }
                });
            }
        }
        return cache;
    }

    private Listener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((MenuItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    public int getMode() {
        return this.mode;
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((ToolItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private void handleWidgetDispose(Event e) {
        if (e.widget == this.widget) {
            IMenuCreator mc;
            if (this.action.getStyle() == 4 && (mc = this.action.getMenuCreator()) != null) {
                mc.dispose();
            }
            this.action.removePropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String commandId = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && commandId != null) {
                    callback.removePropertyChangeListener(commandId, this.actionTextListener);
                }
            }
            this.widget = null;
        }
    }

    private void handleWidgetSelection(Event e, boolean selection) {
        Widget item = e.widget;
        if (item != null) {
            int style = item.getStyle();
            if ((style & 0x22) != 0) {
                if (this.action.getStyle() == 2) {
                    this.action.setChecked(selection);
                }
            } else if ((style & 0x10) != 0) {
                if (this.action.getStyle() == 8) {
                    this.action.setChecked(selection);
                }
            } else if ((style & 4) != 0 && e.detail == 4 && this.action.getStyle() == 4) {
                Menu m;
                IMenuCreator mc = this.action.getMenuCreator();
                ToolItem ti = (ToolItem)item;
                if (mc != null && (m = mc.getMenu((Control)ti.getParent())) != null) {
                    Rectangle b = ti.getBounds();
                    Point p = ti.getParent().toDisplay(new Point(b.x, b.y + b.height));
                    m.setLocation(p.x, p.y);
                    m.setVisible(true);
                    return;
                }
            }
            if (this.action.isEnabled()) {
                boolean trace = Policy.TRACE_ACTIONS;
                long ms = System.currentTimeMillis();
                if (trace) {
                    System.out.println("Running action: " + this.action.getText());
                }
                this.action.runWithEvent(e);
                if (trace) {
                    System.out.println(System.currentTimeMillis() - ms + " ms to run action: " + this.action.getText());
                }
            }
        }
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    private boolean hasImages(IAction actionToCheck) {
        return actionToCheck.getImageDescriptor() != null || actionToCheck.getHoverImageDescriptor() != null || actionToCheck.getDisabledImageDescriptor() != null;
    }

    private boolean isCommandActive() {
        IAction actionToCheck = this.getAction();
        if (actionToCheck != null) {
            String commandId = actionToCheck.getActionDefinitionId();
            ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
            if (callback != null) {
                return callback.isActive(commandId);
            }
        }
        return true;
    }

    public boolean isDynamic() {
        if (this.widget instanceof MenuItem) {
            boolean itemIsCheck = (this.widget.getStyle() & 0x20) != 0;
            boolean actionIsCheck = this.getAction() != null && this.getAction().getStyle() == 2;
            boolean itemIsRadio = (this.widget.getStyle() & 0x10) != 0;
            boolean actionIsRadio = this.getAction() != null && this.getAction().getStyle() == 8;
            return itemIsCheck != actionIsCheck || itemIsRadio != actionIsRadio;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.action != null && this.action.isEnabled();
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean value = this.getParent().getOverrides().getEnabled(this);
        return value == null ? true : value;
    }

    public boolean isVisible() {
        return super.isVisible() && this.isCommandActive();
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.update();
    }

    public final void update() {
        this.update(null);
    }

    public void update(String propertyName) {
        if (this.widget != null) {
            boolean checkChanged;
            boolean textChanged = propertyName == null || propertyName.equals("text");
            boolean imageChanged = propertyName == null || propertyName.equals("image");
            boolean tooltipTextChanged = propertyName == null || propertyName.equals("toolTipText");
            boolean enableStateChanged = propertyName == null || propertyName.equals("enabled") || propertyName.equals("enabled");
            boolean bl = checkChanged = !(this.action.getStyle() != 2 && this.action.getStyle() != 8 || propertyName != null && !propertyName.equals("checked"));
            if (this.widget instanceof ToolItem) {
                boolean showText;
                ToolItem ti = (ToolItem)this.widget;
                String text = this.action.getText();
                boolean bl2 = showText = text != null && ((this.getMode() & MODE_FORCE_TEXT) != 0 || !this.hasImages(this.action));
                if (showText && text != null) {
                    text = Action.removeAcceleratorText(text);
                    text = Action.removeMnemonics(text);
                }
                if (textChanged) {
                    boolean rightStyle;
                    String textToSet = showText ? text : "";
                    boolean bl3 = rightStyle = (ti.getParent().getStyle() & 0x20000) != 0;
                    if (rightStyle || !ti.getText().equals(textToSet)) {
                        ti.setText(textToSet);
                    }
                }
                if (imageChanged) {
                    this.updateImages(!showText);
                }
                if (tooltipTextChanged || textChanged) {
                    String toolTip = this.action.getToolTipText();
                    if (!showText || toolTip != null && !toolTip.equals(text)) {
                        ti.setToolTipText(this.action.getToolTipText());
                    } else {
                        ti.setToolTipText(null);
                    }
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl4 = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (ti.getEnabled() != shouldBeEnabled) {
                        ti.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (ti.getSelection() != bv) {
                        ti.setSelection(bv);
                    }
                }
                return;
            }
            if (this.widget instanceof MenuItem) {
                MenuItem mi = (MenuItem)this.widget;
                if (textChanged) {
                    int accelInt;
                    Integer commandAccelerator;
                    int accelerator = 0;
                    String acceleratorText = null;
                    IAction updatedAction = this.getAction();
                    String text = null;
                    accelerator = updatedAction.getAccelerator();
                    ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                    String commandId = updatedAction.getActionDefinitionId();
                    if (SWT.getPlatform().equals("gtk") && callback != null && commandId != null && (commandAccelerator = callback.getAccelerator(commandId)) != null && (accelInt = callback.getAccelerator(commandId).intValue()) >= LOWER_GTK_ACCEL_BOUND && accelInt <= UPPER_GTK_ACCEL_BOUND) {
                        accelerator = accelInt;
                        acceleratorText = callback.getAcceleratorText(commandId);
                    }
                    if (accelerator == 0) {
                        if (callback != null && commandId != null) {
                            acceleratorText = callback.getAcceleratorText(commandId);
                        }
                    } else {
                        acceleratorText = Action.convertAccelerator(accelerator);
                    }
                    IContributionManagerOverrides overrides = null;
                    if (this.getParent() != null) {
                        overrides = this.getParent().getOverrides();
                    }
                    if (overrides != null) {
                        text = this.getParent().getOverrides().getText(this);
                    }
                    mi.setAccelerator(accelerator);
                    if (text == null) {
                        text = updatedAction.getText();
                    }
                    text = text == null ? "" : Action.removeAcceleratorText(text);
                    if (acceleratorText == null) {
                        mi.setText(text);
                    } else {
                        mi.setText(text + '\t' + acceleratorText);
                    }
                }
                if (imageChanged) {
                    this.updateImages(false);
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl5 = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (mi.getEnabled() != shouldBeEnabled) {
                        mi.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (mi.getSelection() != bv) {
                        mi.setSelection(bv);
                    }
                }
                return;
            }
            if (this.widget instanceof Button) {
                String text;
                Button button = (Button)this.widget;
                if (imageChanged && this.updateImages(false)) {
                    textChanged = false;
                }
                if (textChanged && (text = this.action.getText()) != null) {
                    button.setText(text);
                }
                if (tooltipTextChanged) {
                    button.setToolTipText(this.action.getToolTipText());
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl6 = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (button.getEnabled() != shouldBeEnabled) {
                        button.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (button.getSelection() != bv) {
                        button.setSelection(bv);
                    }
                }
                return;
            }
        }
    }

    private boolean updateImages(boolean forceImage) {
        ImageCache cache = ActionContributionItem.getImageCache();
        if (this.widget instanceof ToolItem) {
            if (USE_COLOR_ICONS) {
                Image image = cache.getImage(this.action.getHoverImageDescriptor());
                if (image == null) {
                    image = cache.getImage(this.action.getImageDescriptor());
                }
                Image disabledImage = cache.getImage(this.action.getDisabledImageDescriptor());
                if (image == null && forceImage) {
                    image = cache.getMissingImage();
                }
                if (disabledImage != null) {
                    ((ToolItem)this.widget).setDisabledImage(disabledImage);
                }
                ((ToolItem)this.widget).setImage(image);
                return image != null;
            }
            Image image = cache.getImage(this.action.getImageDescriptor());
            Image hoverImage = cache.getImage(this.action.getHoverImageDescriptor());
            Image disabledImage = cache.getImage(this.action.getDisabledImageDescriptor());
            if (image == null && hoverImage != null) {
                image = cache.getGrayImage(this.action.getHoverImageDescriptor());
            } else if (hoverImage == null && image != null) {
                hoverImage = image;
                image = cache.getGrayImage(this.action.getImageDescriptor());
            }
            if (hoverImage == null && image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if (disabledImage != null) {
                ((ToolItem)this.widget).setDisabledImage(disabledImage);
            }
            ((ToolItem)this.widget).setHotImage(hoverImage);
            ((ToolItem)this.widget).setImage(image);
            return image != null;
        }
        if (this.widget instanceof Item || this.widget instanceof Button) {
            Image image = cache.getImage(this.action.getHoverImageDescriptor());
            if (image == null) {
                image = cache.getImage(this.action.getImageDescriptor());
            }
            if (image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if (this.widget instanceof Item) {
                ((Item)this.widget).setImage(image);
            } else if (this.widget instanceof Button) {
                ((Button)this.widget).setImage(image);
            }
            return image != null;
        }
        return false;
    }

    protected String shortenText(String textValue, ToolItem item) {
        if (textValue == null) {
            return null;
        }
        GC gc = new GC((Drawable)item.getDisplay());
        int maxWidth = item.getImage().getBounds().width * 4;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        for (int i = textValue.length(); i > 0; --i) {
            String test = textValue.substring(0, i);
            test = test + ellipsis;
            if (gc.textExtent((String)test).x >= maxWidth) continue;
            gc.dispose();
            return test;
        }
        gc.dispose();
        return textValue;
    }

    static {
        USE_COLOR_ICONS = true;
    }

    private static final class ImageCache {
        private final ReferenceCleanerThread greyCleaner;
        private final Map greyMap = new HashMap();
        private final ReferenceQueue greyReferenceQueue = new ReferenceQueue();
        private final ReferenceCleanerThread imageCleaner;
        private final Map imageMap = new HashMap();
        private final ReferenceQueue imageReferenceQueue = new ReferenceQueue();
        private Image missingImage = null;

        private ImageCache() {
            this.greyCleaner = new ReferenceCleanerThread(this.greyReferenceQueue, this.greyMap);
            this.imageCleaner = new ReferenceCleanerThread(this.imageReferenceQueue, this.imageMap);
            this.greyCleaner.start();
            this.imageCleaner.start();
        }

        private final void dispose() {
            if (this.missingImage != null && !this.missingImage.isDisposed()) {
                this.missingImage.dispose();
                this.missingImage = null;
            }
            this.imageCleaner.stopCleaning();
            Iterator imageItr = this.imageMap.entrySet().iterator();
            while (imageItr.hasNext()) {
                Map.Entry entry = imageItr.next();
                WeakReference reference = (WeakReference)entry.getKey();
                reference.clear();
                Image image = (Image)entry.getValue();
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
            this.imageMap.clear();
            this.greyCleaner.stopCleaning();
            Iterator greyItr = this.greyMap.entrySet().iterator();
            while (greyItr.hasNext()) {
                Map.Entry entry = greyItr.next();
                WeakReference reference = (WeakReference)entry.getKey();
                reference.clear();
                Image image = (Image)entry.getValue();
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
            this.greyMap.clear();
        }

        private final Image getGrayImage(ImageDescriptor descriptor) {
            if (descriptor == null) {
                return null;
            }
            HashableWeakReference key = new HashableWeakReference(descriptor, this.imageReferenceQueue);
            Object value = this.greyMap.get(key);
            if (value instanceof Image) {
                key.clear();
                return (Image)value;
            }
            Image image = this.getImage(descriptor);
            if (image != null) {
                Image greyImage = new Image(null, image, 2);
                this.greyMap.put(key, greyImage);
                return greyImage;
            }
            return null;
        }

        private final Image getImage(ImageDescriptor descriptor) {
            if (descriptor == null) {
                return null;
            }
            HashableWeakReference key = new HashableWeakReference(descriptor, this.imageReferenceQueue);
            Object value = this.imageMap.get(key);
            if (value instanceof Image) {
                key.clear();
                return (Image)value;
            }
            Image image = descriptor.createImage();
            this.imageMap.put(key, image);
            return image;
        }

        private final Image getMissingImage() {
            if (this.missingImage == null) {
                this.missingImage = this.getImage(ImageDescriptor.getMissingImageDescriptor());
            }
            return this.missingImage;
        }

        private static class ReferenceCleanerThread
        extends Thread {
            private static int threads = 0;
            private final WeakReference endMarker;
            private final ReferenceQueue referenceQueue;
            private final Map map;

            private ReferenceCleanerThread(ReferenceQueue referenceQueue, Map map) {
                super("Reference Cleaner - " + ++threads);
                if (referenceQueue == null) {
                    throw new NullPointerException("The reference queue should not be null.");
                }
                if (map == null) {
                    throw new NullPointerException("The map should not be null.");
                }
                this.endMarker = new WeakReference<ReferenceQueue>(referenceQueue, referenceQueue);
                this.referenceQueue = referenceQueue;
                this.map = map;
            }

            private final void stopCleaning() {
                this.endMarker.enqueue();
            }

            public final void run() {
                while (true) {
                    Reference reference = null;
                    try {
                        reference = this.referenceQueue.remove();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (reference == this.endMarker) break;
                    final Object value = this.map.remove(reference);
                    if (value instanceof Image) {
                        Display.getCurrent().syncExec(new Runnable(){

                            public void run() {
                                Image image = (Image)value;
                                if (!image.isDisposed()) {
                                    image.dispose();
                                }
                            }
                        });
                    }
                    if (reference == null) continue;
                    reference.clear();
                }
            }
        }

        private static final class HashableWeakReference
        extends WeakReference {
            private HashableWeakReference(Object referent, ReferenceQueue referenceQueue) {
                super(referent, referenceQueue);
            }

            public final int hashCode() {
                Object referent = this.get();
                if (referent == null) {
                    return super.hashCode();
                }
                return referent.hashCode();
            }

            public final boolean equals(Object object) {
                Object referent = this.get();
                if (referent == null) {
                    return super.equals(object);
                }
                if (object instanceof HashableWeakReference) {
                    object = ((HashableWeakReference)object).get();
                }
                return referent.equals(object);
            }
        }
    }
}

