/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.NestedRegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class ConfigurationElement
extends NestedRegistryModelObject
implements IConfigurationElement {
    int PLUGIN_ERROR = 1;
    private String value = null;
    private ConfigurationProperty[] properties = null;
    private IConfigurationElement[] children = null;

    /*
     * Enabled aggressive block sorting
     */
    public Object createExecutableExtension(String attributeName) throws CoreException {
        Object initData;
        String className;
        String pluginName;
        block13: {
            String executable;
            String prop;
            block12: {
                prop = null;
                pluginName = null;
                className = null;
                initData = null;
                if (attributeName != null) {
                    prop = this.getAttribute(attributeName);
                } else {
                    prop = this.getValue();
                    if (prop != null && (prop = prop.trim()).equals("")) {
                        prop = null;
                    }
                }
                if (prop != null) break block12;
                IConfigurationElement[] exec = this.getChildren(attributeName);
                if (exec.length == 0) {
                    String message = Policy.bind("plugin.extDefNotFound", attributeName);
                    Status status = new Status(4, "org.eclipse.core.runtime", this.PLUGIN_ERROR, message, null);
                    InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(status);
                    throw new CoreException(status);
                }
                IConfigurationElement element = exec[0];
                pluginName = element.getAttribute("plugin");
                className = element.getAttribute("class");
                IConfigurationElement[] parms = element.getChildren("parameter");
                if (parms != null) {
                    Hashtable<String, String> initParms = new Hashtable<String, String>(parms.length + 1);
                    for (int i = 0; i < parms.length; ++i) {
                        String pname = parms[i].getAttribute("name");
                        if (pname == null) continue;
                        initParms.put(pname, parms[i].getAttribute("value"));
                    }
                    if (!initParms.isEmpty()) {
                        initData = initParms;
                    }
                }
                break block13;
            }
            int i = prop.indexOf(58);
            if (i != -1) {
                executable = prop.substring(0, i).trim();
                initData = prop.substring(i + 1).trim();
            } else {
                executable = prop;
            }
            i = executable.indexOf(47);
            if (i != -1) {
                pluginName = executable.substring(0, i).trim();
                className = executable.substring(i + 1).trim();
            } else {
                className = executable;
            }
        }
        if (className != null && !className.equals("")) {
            return this.createExecutableExtension(InternalPlatform.getDefault().getBundle(this.getDeclaringExtension().getNamespace()), pluginName, className, initData, this, attributeName);
        }
        String message = Policy.bind("plugin.extDefNoClass", attributeName);
        Status status = new Status(4, "org.eclipse.core.runtime", this.PLUGIN_ERROR, message, null);
        InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(status);
        throw new CoreException(status);
    }

    Object createExecutableExtension(Bundle bundle, String pluginName, String className, Object initData, IConfigurationElement cfig, String propertyName) throws CoreException {
        String id = bundle.getSymbolicName();
        if (pluginName != null && !pluginName.equals("") && !pluginName.equals(id)) {
            Bundle otherBundle = null;
            otherBundle = InternalPlatform.getDefault().getBundle(pluginName);
            return this.createExecutableExtension(otherBundle, className, initData, cfig, propertyName);
        }
        return this.createExecutableExtension(bundle, className, initData, cfig, propertyName);
    }

    public Object createExecutableExtension(Bundle bundle, String className, Object initData, IConfigurationElement cfig, String propertyName) throws CoreException {
        Class classInstance = null;
        try {
            classInstance = bundle.loadClass(className);
        }
        catch (Exception e1) {
            this.throwException(Policy.bind("plugin.loadClassError", bundle.getSymbolicName(), className), e1);
        }
        catch (LinkageError e) {
            this.throwException(Policy.bind("plugin.loadClassError", bundle.getSymbolicName(), className), e);
        }
        Object result = null;
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e) {
            this.throwException(Policy.bind("plugin.instantiateClassError", bundle.getSymbolicName(), className), e);
        }
        if (result instanceof IExecutableExtension) {
            try {
                ((IExecutableExtension)result).setInitializationData(cfig, propertyName, initData);
            }
            catch (CoreException ce) {
                InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(ce.getStatus());
                throw new CoreException(ce.getStatus());
            }
            catch (Exception te) {
                this.throwException(Policy.bind("policy.initObjectError", bundle.getSymbolicName(), className), te);
            }
        }
        return result;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.core.runtime", this.PLUGIN_ERROR, message, exception);
        InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(status);
        throw new CoreException(status);
    }

    public Extension getParentExtension() {
        Object p = this.getParent();
        while (p != null && p instanceof ConfigurationElement) {
            p = ((ConfigurationElement)p).getParent();
        }
        return (Extension)p;
    }

    public IExtension getDeclaringExtension() {
        return this.getParentExtension();
    }

    public ConfigurationProperty[] getProperties() {
        return this.properties;
    }

    public String getValue() {
        String s = this.getValueAsIs();
        if (s == null) {
            return null;
        }
        return s;
    }

    public String getValueAsIs() {
        return this.value;
    }

    public IConfigurationElement[] getChildren() {
        return this.children == null ? new IConfigurationElement[]{} : this.children;
    }

    public IConfigurationElement[] getChildren(String name) {
        IConfigurationElement[] list = this.getChildren();
        if (list == null) {
            return new IConfigurationElement[0];
        }
        ArrayList<IConfigurationElement> children = new ArrayList<IConfigurationElement>();
        for (int i = 0; i < list.length; ++i) {
            IConfigurationElement element = list[i];
            if (!name.equals(element.getName())) continue;
            children.add(list[i]);
        }
        return children.toArray(new IConfigurationElement[children.size()]);
    }

    public String getAttribute(String name) {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return null;
        }
        ConfigurationProperty found = null;
        for (int i = 0; i < list.length; ++i) {
            if (!name.equals(list[i].getName())) continue;
            found = list[i];
            break;
        }
        return found == null ? null : found.getValue();
    }

    public String getAttributeAsIs(String name) {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!name.equals(list[i].getName())) continue;
            return list[i].getValue();
        }
        return null;
    }

    public String[] getAttributeNames() {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return new String[0];
        }
        String[] result = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = list[i].getName();
        }
        return result;
    }

    public void setProperties(ConfigurationProperty[] value) {
        this.properties = value;
    }

    public void setChildren(IConfigurationElement[] value) {
        this.children = value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setLocalizedValue(String value) {
        this.value = value;
        ((ExtensionRegistry)InternalPlatform.getDefault().getRegistry()).setDirty(true);
    }
}

