/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelp;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class WelcomeItem {
    private String text;
    private int[][] boldRanges;
    private int[][] helpRanges;
    private String[] helpIds;
    private String[] helpHrefs;
    private int[][] actionRanges;
    private String[] actionPluginIds;
    private String[] actionClasses;

    public WelcomeItem(String text, int[][] boldRanges, int[][] actionRanges, String[] actionPluginIds, String[] actionClasses, int[][] helpRanges, String[] helpIds, String[] helpHrefs) {
        this.text = text;
        this.boldRanges = boldRanges;
        this.actionRanges = actionRanges;
        this.actionPluginIds = actionPluginIds;
        this.actionClasses = actionClasses;
        this.helpRanges = helpRanges;
        this.helpIds = helpIds;
        this.helpHrefs = helpHrefs;
    }

    public int[][] getActionRanges() {
        return this.actionRanges;
    }

    public int[][] getBoldRanges() {
        return this.boldRanges;
    }

    public int[][] getHelpRanges() {
        return this.helpRanges;
    }

    public String getText() {
        return this.text;
    }

    public boolean isLinkAt(int offset) {
        int i;
        for (i = 0; i < this.helpRanges.length; ++i) {
            if (offset < this.helpRanges[i][0] || offset >= this.helpRanges[i][0] + this.helpRanges[i][1]) continue;
            return true;
        }
        for (i = 0; i < this.actionRanges.length; ++i) {
            if (offset < this.actionRanges[i][0] || offset >= this.actionRanges[i][0] + this.actionRanges[i][1]) continue;
            return true;
        }
        return false;
    }

    public void logActionLinkError(String actionPluginId, String actionClass) {
        IDEWorkbenchPlugin.log(IDEWorkbenchMessages.getString("WelcomeItem.unableToLoadClass") + actionPluginId + " " + actionClass);
    }

    private void openHelpTopic(String topic, String href) {
        IHelp helpSupport = WorkbenchHelp.getHelpSupport();
        if (helpSupport != null) {
            if (href != null) {
                helpSupport.displayHelpResource(href);
            } else {
                helpSupport.displayHelpResource(topic);
            }
        }
    }

    private void runAction(String pluginId, String className) {
        IAction action;
        Class<?> actionClass;
        IPluginDescriptor desc = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        if (desc == null) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        try {
            actionClass = desc.getPluginClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        try {
            action = (IAction)actionClass.newInstance();
        }
        catch (InstantiationException e) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        catch (IllegalAccessException e) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        catch (ClassCastException e) {
            this.logActionLinkError(pluginId, className);
            return;
        }
        action.run();
    }

    public void triggerLinkAt(int offset) {
        int i;
        for (i = 0; i < this.helpRanges.length; ++i) {
            if (offset < this.helpRanges[i][0] || offset >= this.helpRanges[i][0] + this.helpRanges[i][1]) continue;
            this.openHelpTopic(this.helpIds[i], this.helpHrefs[i]);
            return;
        }
        for (i = 0; i < this.actionRanges.length; ++i) {
            if (offset < this.actionRanges[i][0] || offset >= this.actionRanges[i][0] + this.actionRanges[i][1]) continue;
            this.runAction(this.actionPluginIds[i], this.actionClasses[i]);
            return;
        }
    }
}

