/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.build.BinSection;
import org.eclipse.pde.internal.ui.editor.build.BuildClasspathSection;
import org.eclipse.pde.internal.ui.editor.build.BuildContentsSection;
import org.eclipse.pde.internal.ui.editor.build.RuntimeInfoSection;
import org.eclipse.pde.internal.ui.editor.build.SrcSection;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPage
extends PDEFormPage {
    public static final String FORM_TITLE = "BuildEditor.BuildPage.title";
    public static final String PAGE_ID = "build";
    private BuildClasspathSection classpathSection;
    private BuildContentsSection srcSection;
    private BuildContentsSection binSection;
    private RuntimeInfoSection runtimeSection;
    private Button customButton;

    public BuildPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEPlugin.getResourceString("BuildPage.name"));
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        FormToolkit toolkit = mform.getToolkit();
        GridLayout layout = new GridLayout();
        ScrolledForm form = mform.getForm();
        form.setText(PDEPlugin.getResourceString(FORM_TITLE));
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 10;
        layout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)layout);
        this.customButton = toolkit.createButton(form.getBody(), this.getCustomText(), 32);
        this.customButton.setAlignment(16384);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.customButton.setLayoutData((Object)gd);
        Label label = toolkit.createLabel(form.getBody(), null);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.customButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isCustom = BuildPage.this.customButton.getSelection();
                IBuildEntry customEntry = BuildPage.this.getCustomBuildEntry();
                BuildPage.this.setCustomEntryValue(customEntry, isCustom);
                BuildPage.this.handleCustomCheckState(isCustom);
            }
        });
        this.runtimeSection = new RuntimeInfoSection(this, form.getBody());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.runtimeSection.getSection().setLayoutData((Object)gd);
        this.binSection = new BinSection(this, form.getBody());
        gd = new GridData(1808);
        this.binSection.getSection().setLayoutData((Object)gd);
        this.srcSection = new SrcSection(this, form.getBody());
        gd = new GridData(1808);
        this.srcSection.getSection().setLayoutData((Object)gd);
        this.classpathSection = new BuildClasspathSection(this, form.getBody());
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        this.classpathSection.getSection().setLayoutData((Object)gd);
        mform.addPart((IFormPart)this.runtimeSection);
        mform.addPart((IFormPart)this.srcSection);
        mform.addPart((IFormPart)this.binSection);
        mform.addPart((IFormPart)this.classpathSection);
        this.handleCustomCheckState(this.getCustomSelection());
        WorkbenchHelp.setHelp((Control)form, (String)"org.eclipse.pde.doc.user.build_page");
    }

    private IBuildModel getBuildModel() {
        InputContext context = this.getPDEEditor().getContextManager().findContext("build-context");
        return (IBuildModel)context.getModel();
    }

    private IBuildEntry getCustomBuildEntry() {
        IBuildModel buildModel = this.getBuildModel();
        IBuildEntry customEntry = buildModel.getBuild().getEntry("custom");
        if (customEntry != null) {
            return customEntry;
        }
        try {
            customEntry = buildModel.getFactory().createEntry("custom");
            buildModel.getBuild().add(customEntry);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return customEntry;
    }

    private boolean getCustomSelection() {
        IBuildModel model = this.getBuildModel();
        IBuild build = model.getBuild();
        IBuildEntry customEntry = build.getEntry("custom");
        if (customEntry == null || customEntry.getTokens().length == 0) {
            return false;
        }
        return customEntry.getTokens()[0].equals("true");
    }

    private void handleCustomCheckState(boolean isCustom) {
        this.customButton.setSelection(isCustom);
        this.enableAllSections(!isCustom);
    }

    public void enableAllSections(boolean enable) {
        this.runtimeSection.enableSection(enable);
        this.binSection.enableSection(enable);
        this.srcSection.enableSection(enable);
        this.classpathSection.enableSection(enable);
    }

    private void setCustomEntryValue(IBuildEntry customEntry, boolean isCustom) {
        String[] tokens = customEntry.getTokens();
        try {
            if (tokens.length != 0) {
                for (int i = 0; i < tokens.length; ++i) {
                    customEntry.removeToken(tokens[i]);
                }
            }
            if (isCustom) {
                customEntry.addToken("true");
            } else {
                this.getBuildModel().getBuild().remove(customEntry);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private String getCustomText() {
        return PDEPlugin.getResourceString("BuildPage.custom");
    }
}

