/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.internal.samples;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.ui.internal.samples.SampleWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class ReviewPage
extends WizardPage {
    private SampleWizard wizard;
    private ScrolledFormText formText;

    public ReviewPage(SampleWizard wizard) {
        super("last");
        this.wizard = wizard;
        this.setTitle(PDEPlugin.getResourceString("ReviewPage.title"));
        this.setDescription(PDEPlugin.getResourceString("ReviewPage.desc"));
    }

    public void setVisible(boolean visible) {
        this.setPageComplete(this.wizard.getSelection() != null);
        if (this.formText != null) {
            this.updateContent();
        }
        super.setVisible(visible);
    }

    private void updateContent() {
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        IConfigurationElement selection = this.wizard.getSelection();
        if (selection != null) {
            this.setMessage(null);
            IConfigurationElement[] desc = selection.getChildren("description");
            if (desc.length == 1) {
                buf.append(PDEPlugin.getFormattedMessage("ReviewPage.descContent", new String[]{selection.getAttribute("name"), desc[0].getValue()}));
            } else {
                buf.append(PDEPlugin.getFormattedMessage("ReviewPage.content", selection.getAttribute("name")));
            }
        } else {
            this.setMessage(PDEPlugin.getResourceString("ReviewPage.noSampleFound"), 2);
        }
        buf.append("</form>");
        this.formText.setText(buf.toString());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.formText = new ScrolledFormText(container, true);
        this.formText.setBackground(parent.getBackground());
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.formText.setLayoutData((Object)gd);
        HyperlinkSettings settings = new HyperlinkSettings(parent.getDisplay());
        this.formText.getFormText().setHyperlinkSettings(settings);
        this.setControl((Control)container);
        this.updateContent();
    }
}

