/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.util.Policy;

public abstract class ContributionManager
implements IContributionManager {
    private List contributions = new ArrayList();
    private boolean isDirty = true;
    private int dynamicItems = 0;
    private IContributionManagerOverrides overrides;

    protected ContributionManager() {
    }

    public void add(IAction action) {
        this.add(new ActionContributionItem(action));
    }

    public void add(IContributionItem item) {
        if (this.allowItem(item)) {
            item.setParent(this);
            this.contributions.add(item);
            this.itemAdded(item);
        }
    }

    private void addToGroup(String groupName, IContributionItem item, boolean append) {
        Iterator items = this.contributions.iterator();
        int i = 0;
        while (items.hasNext()) {
            String id;
            IContributionItem o = (IContributionItem)items.next();
            if (o.isGroupMarker() && (id = o.getId()) != null && id.equalsIgnoreCase(groupName)) {
                ++i;
                if (append) {
                    IContributionItem ci;
                    while (items.hasNext() && !(ci = (IContributionItem)items.next()).isGroupMarker()) {
                        ++i;
                    }
                }
                if (this.allowItem(item)) {
                    item.setParent(this);
                    this.contributions.add(i, item);
                    this.itemAdded(item);
                }
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Group not found: " + groupName);
    }

    public void appendToGroup(String groupName, IAction action) {
        this.addToGroup(groupName, new ActionContributionItem(action), true);
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        this.addToGroup(groupName, item, true);
    }

    protected boolean allowItem(IContributionItem itemToAdd) {
        return true;
    }

    protected void dumpStatistics() {
        int size = 0;
        if (this.contributions != null) {
            size = this.contributions.size();
        }
        System.out.println(this.toString());
        System.out.println("   Number of elements: " + size);
        int sum = 0;
        for (int i = 0; i < size; ++i) {
            if (!((IContributionItem)this.contributions.get(i)).isVisible()) continue;
            ++sum;
        }
        System.out.println("   Number of visible elements: " + sum);
        System.out.println("   Is dirty: " + this.isDirty());
    }

    public IContributionItem find(String id) {
        Iterator e = this.contributions.iterator();
        while (e.hasNext()) {
            IContributionItem item = (IContributionItem)e.next();
            String itemId = item.getId();
            if (itemId == null || !itemId.equalsIgnoreCase(id)) continue;
            return item;
        }
        return null;
    }

    public IContributionItem[] getItems() {
        IContributionItem[] items = new IContributionItem[this.contributions.size()];
        this.contributions.toArray(items);
        return items;
    }

    public IContributionManagerOverrides getOverrides() {
        if (this.overrides == null) {
            this.overrides = new IContributionManagerOverrides(){

                public Boolean getEnabled(IContributionItem item) {
                    return null;
                }

                public Integer getAccelerator(IContributionItem item) {
                    return null;
                }

                public String getAcceleratorText(IContributionItem item) {
                    return null;
                }

                public String getText(IContributionItem item) {
                    return null;
                }
            };
        }
        return this.overrides;
    }

    protected boolean hasDynamicItems() {
        return this.dynamicItems > 0;
    }

    public int indexOf(String id) {
        for (int i = 0; i < this.contributions.size(); ++i) {
            IContributionItem item = (IContributionItem)this.contributions.get(i);
            String itemId = item.getId();
            if (itemId == null || !itemId.equalsIgnoreCase(id)) continue;
            return i;
        }
        return -1;
    }

    protected int indexOf(IContributionItem item) {
        return this.contributions.indexOf(item);
    }

    public void insert(int index, IContributionItem item) {
        if (index > this.contributions.size()) {
            throw new IndexOutOfBoundsException("inserting " + item.getId() + " at " + index);
        }
        if (this.allowItem(item)) {
            item.setParent(this);
            this.contributions.add(index, item);
            this.itemAdded(item);
        }
    }

    public void insertAfter(String ID, IAction action) {
        this.insertAfter(ID, new ActionContributionItem(action));
    }

    public void insertAfter(String ID, IContributionItem item) {
        IContributionItem ci = this.find(ID);
        if (ci == null) {
            throw new IllegalArgumentException("can't find ID");
        }
        int ix = this.contributions.indexOf(ci);
        if (ix >= 0 && this.allowItem(item)) {
            item.setParent(this);
            this.contributions.add(ix + 1, item);
            this.itemAdded(item);
        }
    }

    public void insertBefore(String ID, IAction action) {
        this.insertBefore(ID, new ActionContributionItem(action));
    }

    public void insertBefore(String ID, IContributionItem item) {
        IContributionItem ci = this.find(ID);
        if (ci == null) {
            throw new IllegalArgumentException("can't find ID " + ID);
        }
        int ix = this.contributions.indexOf(ci);
        if (ix >= 0 && this.allowItem(item)) {
            item.setParent(this);
            this.contributions.add(ix, item);
            this.itemAdded(item);
        }
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        if (this.hasDynamicItems()) {
            Iterator iter = this.contributions.iterator();
            while (iter.hasNext()) {
                IContributionItem item = (IContributionItem)iter.next();
                if (!item.isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.contributions.isEmpty();
    }

    protected void itemAdded(IContributionItem item) {
        this.markDirty();
        if (item.isDynamic()) {
            ++this.dynamicItems;
        }
    }

    protected void itemRemoved(IContributionItem item) {
        this.markDirty();
        if (item.isDynamic()) {
            --this.dynamicItems;
        }
    }

    public void markDirty() {
        this.setDirty(true);
    }

    public void prependToGroup(String groupName, IAction action) {
        this.addToGroup(groupName, new ActionContributionItem(action), false);
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        this.addToGroup(groupName, item, false);
    }

    public IContributionItem remove(String ID) {
        IContributionItem ci = this.find(ID);
        if (ci == null) {
            return null;
        }
        return this.remove(ci);
    }

    public IContributionItem remove(IContributionItem item) {
        if (this.contributions.remove(item)) {
            this.itemRemoved(item);
            return item;
        }
        return null;
    }

    public void removeAll() {
        this.contributions.clear();
        this.dynamicItems = 0;
        this.markDirty();
    }

    public boolean replaceItem(String identifier, IContributionItem replacementItem) {
        if (identifier == null) {
            return false;
        }
        int index = this.indexOf(identifier);
        if (index < 0) {
            return false;
        }
        IContributionItem oldItem = (IContributionItem)this.contributions.get(index);
        this.itemRemoved(oldItem);
        this.contributions.set(index, replacementItem);
        this.itemAdded(replacementItem);
        for (int i = this.contributions.size() - 1; i > index; --i) {
            IContributionItem item = (IContributionItem)this.contributions.get(i);
            if (item == null || !identifier.equals(item.getId())) continue;
            if (Policy.TRACE_TOOLBAR) {
                System.out.println("Removing duplicate on replace: " + identifier);
            }
            this.contributions.remove(i);
            this.itemRemoved(item);
        }
        return true;
    }

    protected void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setOverrides(IContributionManagerOverrides newOverrides) {
        this.overrides = newOverrides;
    }

    protected void internalSetItems(IContributionItem[] items) {
        this.contributions.clear();
        for (int i = 0; i < items.length; ++i) {
            if (!this.allowItem(items[i])) continue;
            this.contributions.add(items[i]);
        }
    }
}

