/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class ChangeElementTreeViewer
extends CheckboxTreeViewer {
    public ChangeElementTreeViewer(Composite parentComposite) {
        super(parentComposite, 0);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ChangeElement element = (ChangeElement)event.getElement();
                boolean checked = event.getChecked();
                element.setActive(checked);
                ChangeElementTreeViewer.this.setSubtreeChecked(element, checked);
                ChangeElementTreeViewer.this.setSubtreeGrayed(element, false);
                for (ChangeElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                    int active = parent.getActive();
                    boolean grayed = active == 1;
                    ChangeElementTreeViewer.this.setChecked(parent, checked ? true : grayed);
                    ChangeElementTreeViewer.this.setGrayed(parent, grayed);
                }
            }
        });
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.initializeChildren((ChangeElement)input);
    }

    protected void doUpdateItem(Item item, Object element) {
        super.doUpdateItem(item, element);
        TreeItem treeItem = (TreeItem)item;
        ChangeElement ce = (ChangeElement)element;
        int state = ce.getActive();
        boolean checked = state != 0;
        treeItem.setChecked(checked);
        boolean grayed = state == 1;
        treeItem.setGrayed(grayed);
    }

    protected void revealNext() {
        this.revealElement(true);
    }

    protected void revealPrevious() {
        this.revealElement(false);
    }

    private void initializeChildren(ChangeElement element) {
        if (element == null) {
            return;
        }
        ChangeElement[] children = element.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            boolean grayed;
            boolean checked;
            ChangeElement child = children[i];
            int state = child.getActive();
            boolean bl = checked = state != 0;
            if (checked) {
                this.setChecked(child, checked);
            }
            boolean bl2 = grayed = state == 1;
            if (!grayed) continue;
            this.setGrayed(child, grayed);
        }
    }

    private void setSubtreeGrayed(Object element, boolean grayed) {
        TreeItem item;
        Widget widget = this.findItem(element);
        if (widget instanceof TreeItem && (item = (TreeItem)widget).getGrayed() != grayed) {
            item.setGrayed(grayed);
            this.grayChildren(this.getChildren((Widget)item), grayed);
        }
    }

    private void grayChildren(Item[] items, boolean grayed) {
        for (int i = 0; i < items.length; ++i) {
            TreeItem item;
            Item element = items[i];
            if (!(element instanceof TreeItem) || (item = (TreeItem)element).getGrayed() == grayed) continue;
            item.setGrayed(grayed);
            this.grayChildren(this.getChildren((Widget)item), grayed);
        }
    }

    private void revealElement(boolean next) {
        ChangeElement leaf;
        ChangeElement candidate;
        ChangeElement current = (ChangeElement)this.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (!selection.isEmpty()) {
            current = (ChangeElement)selection.iterator().next();
        }
        if ((candidate = this.getLeaf(current, next)) == null && (candidate = this.getElement(current, next)) != null && (leaf = this.getLeaf(candidate, next)) != null) {
            candidate = leaf;
        }
        if (candidate != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)candidate), true);
        } else {
            this.getControl().getDisplay().beep();
        }
    }

    private ChangeElement getLeaf(ChangeElement element, boolean first) {
        ChangeElement result = null;
        ChangeElement[] children = element.getChildren();
        while (children != null && children.length > 0) {
            result = children[first ? 0 : children.length - 1];
            children = result.getChildren();
        }
        return result;
    }

    private ChangeElement getElement(ChangeElement element, boolean next) {
        ChangeElement parent;
        while ((parent = element.getParent()) != null) {
            ChangeElement candidate = this.getSibling(parent.getChildren(), element, next);
            if (candidate != null) {
                return candidate;
            }
            element = parent;
        }
        return null;
    }

    private ChangeElement getSibling(ChangeElement[] children, ChangeElement element, boolean next) {
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != element) continue;
            if (next) {
                if (i < children.length - 1) {
                    return children[i + 1];
                }
                return null;
            }
            if (i > 0) {
                return children[i - 1];
            }
            return null;
        }
        return null;
    }
}

