/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;

public class PackageReferencePattern
extends AndPattern
implements IIndexConstants {
    protected char[] pkgName;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{IIndexConstants.REF};

    public PackageReferencePattern(char[] pkgName, int matchRule) {
        this(matchRule);
        if (pkgName == null || pkgName.length == 0) {
            this.pkgName = null;
            this.segments = new char[][]{CharOperation.NO_CHAR};
            this.mustResolve = false;
        } else {
            this.pkgName = this.isCaseSensitive() ? pkgName : CharOperation.toLowerCase(pkgName);
            this.segments = CharOperation.splitOn('.', this.pkgName);
            this.mustResolve = true;
        }
    }

    PackageReferencePattern(int matchRule) {
        super(1, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        this.pkgName = key;
    }

    public SearchPattern getBlankPattern() {
        return new PackageReferencePattern(8);
    }

    public char[] getIndexKey() {
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    protected boolean hasNextQuery() {
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    protected void resetQuery() {
        this.currentSegment = this.segments.length - 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("PackageReferencePattern: <");
        if (this.pkgName != null) {
            buffer.append(this.pkgName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.getMatchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
                break;
            }
            case 4: {
                buffer.append("regexp match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

