/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.eval.CodeSnippetCodeStream;
import org.eclipse.jdt.internal.eval.CodeSnippetScope;
import org.eclipse.jdt.internal.eval.CodeSnippetThisReference;
import org.eclipse.jdt.internal.eval.EvaluationConstants;
import org.eclipse.jdt.internal.eval.EvaluationContext;

public class CodeSnippetMessageSend
extends MessageSend
implements ProblemReasons,
EvaluationConstants {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetMessageSend(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.binding.canBeSeenBy(this.receiverType, this, currentScope)) {
            boolean isStatic = this.binding.isStatic();
            if (!isStatic && (this.bits & 0x1FE0) != 0) {
                ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                Object[] path = currentScope.getEmulationPath(targetType, true, false);
                if (path == null) {
                    currentScope.problemReporter().needImplementation();
                } else {
                    codeStream.generateOuterAccess(path, this, targetType, currentScope);
                }
            } else {
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
            }
            if (this.arguments != null) {
                int max = this.arguments.length;
                for (int i = 0; i < max; ++i) {
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                }
            }
            if (isStatic) {
                codeStream.invokestatic(this.binding);
            } else if (this.receiver.isSuper()) {
                codeStream.invokespecial(this.binding);
            } else if (this.binding.declaringClass.isInterface()) {
                codeStream.invokeinterface(this.binding);
            } else {
                codeStream.invokevirtual(this.binding);
            }
        } else {
            ((CodeSnippetCodeStream)codeStream).generateEmulationForMethod(currentScope, this.binding);
            boolean isStatic = this.binding.isStatic();
            if (!isStatic && (this.bits & 0x1FE0) != 0) {
                currentScope.problemReporter().needImplementation();
            } else {
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
            }
            if (isStatic) {
                codeStream.aconst_null();
            }
            if (this.arguments != null) {
                int argsLength = this.arguments.length;
                codeStream.generateInlinedValue(argsLength);
                codeStream.newArray(currentScope, new ArrayBinding(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT), 1));
                codeStream.dup();
                for (int i = 0; i < argsLength; ++i) {
                    codeStream.generateInlinedValue(i);
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    TypeBinding parameterBinding = this.binding.parameters[i];
                    if (parameterBinding.isBaseType() && parameterBinding != BaseTypes.NullBinding) {
                        ((CodeSnippetCodeStream)codeStream).generateObjectWrapperForType(this.binding.parameters[i]);
                    }
                    codeStream.aastore();
                    if (i >= argsLength - 1) continue;
                    codeStream.dup();
                }
            } else {
                codeStream.generateInlinedValue(0);
                codeStream.newArray(currentScope, new ArrayBinding(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT), 1));
            }
            ((CodeSnippetCodeStream)codeStream).invokeJavaLangReflectMethodInvoke();
            if (this.binding.returnType.isBaseType()) {
                int typeID = this.binding.returnType.id;
                if (typeID == 6) {
                    codeStream.pop();
                }
                ((CodeSnippetCodeStream)codeStream).checkcast(typeID);
                ((CodeSnippetCodeStream)codeStream).getBaseTypeValue(typeID);
            } else {
                codeStream.checkcast(this.binding.returnType);
            }
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            switch (this.binding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (!(this.binding.declaringClass == this.qualifyingType || this.qualifyingType.isArrayType() || (currentScope.environment().options.targetJDK < 0x2E0000L || this.receiver.isImplicitThis() && this.binding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(currentScope))) {
            this.codegenBinding = currentScope.enclosingSourceType().getUpdatedMethodBinding(this.binding, (ReferenceBinding)this.qualifyingType);
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = NotAConstant;
        this.qualifyingType = this.receiverType = this.receiver.resolveType(scope);
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            for (int i = 0; i < length; ++i) {
                argumentTypes[i] = this.arguments[i].resolveType(scope);
                if (argumentTypes[i] != null) continue;
                argHasError = true;
            }
            if (argHasError) {
                return null;
            }
        }
        if (this.receiverType == null) {
            return null;
        }
        if (this.receiverType.isBaseType()) {
            scope.problemReporter().errorNoMethodFor(this, this.receiverType, argumentTypes);
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? scope.getImplicitMethod(this.selector, argumentTypes, this) : scope.getMethod(this.receiverType, this.selector, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding instanceof ProblemMethodBinding && ((ProblemMethodBinding)this.binding).problemId() == 2) {
                MethodBinding privateBinding;
                if (this.evaluationContext.declaringTypeName != null) {
                    this.delegateThis = scope.getField(scope.enclosingSourceType(), EvaluationConstants.DELEGATE_THIS, this);
                    if (this.delegateThis == null) {
                        this.constant = NotAConstant;
                        scope.problemReporter().invalidMethod(this, this.binding);
                        return null;
                    }
                } else {
                    this.constant = NotAConstant;
                    scope.problemReporter().invalidMethod(this, this.binding);
                    return null;
                }
                CodeSnippetScope localScope = new CodeSnippetScope(scope);
                MethodBinding methodBinding2 = privateBinding = this.receiver instanceof CodeSnippetThisReference && ((CodeSnippetThisReference)this.receiver).isImplicit ? localScope.getImplicitMethod((ReferenceBinding)this.delegateThis.type, this.selector, argumentTypes, this) : localScope.getMethod(this.delegateThis.type, this.selector, argumentTypes, this);
                if (!privateBinding.isValidBinding()) {
                    if (this.binding.declaringClass == null) {
                        if (this.receiverType instanceof ReferenceBinding) {
                            this.binding.declaringClass = (ReferenceBinding)this.receiverType;
                        } else {
                            scope.problemReporter().errorNoMethodFor(this, this.receiverType, argumentTypes);
                            return null;
                        }
                    }
                    scope.problemReporter().invalidMethod(this, this.binding);
                    return null;
                }
                this.binding = privateBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    if (this.receiverType instanceof ReferenceBinding) {
                        this.binding.declaringClass = (ReferenceBinding)this.receiverType;
                    } else {
                        scope.problemReporter().errorNoMethodFor(this, this.receiverType, argumentTypes);
                        return null;
                    }
                }
                scope.problemReporter().invalidMethod(this, this.binding);
                return null;
            }
        }
        if (!this.binding.isStatic() && this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0) {
            scope.problemReporter().mustUseAStaticMethod(this, this.binding);
            return null;
        }
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                this.arguments[i].implicitWidening(this.binding.parameters[i], argumentTypes[i]);
            }
        }
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            scope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
            return null;
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        this.resolvedType = this.binding.returnType;
        return this.resolvedType;
    }
}

