/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.jdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.jdt.internal.formatter.AbortFormatting;
import org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Location;
import org.eclipse.jdt.internal.formatter.OptimizedReplaceEdit;
import org.eclipse.jdt.internal.formatter.align.Alignment;
import org.eclipse.jdt.internal.formatter.align.AlignmentException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class Scribe {
    private static final String EMPTY_STRING = "";
    private static final int INITIAL_SIZE = 100;
    private boolean checkLineWrapping;
    public int column;
    private int[][] commentPositions;
    public Alignment currentAlignment;
    public int currentToken;
    private OptimizedReplaceEdit[] edits;
    public int editsIndex;
    private char fillingSpace;
    public CodeFormatterVisitor formatter;
    public int indentationLevel;
    public int lastNumberOfNewLines;
    public int line;
    private int[] lineEnds;
    private String lineSeparator;
    public Alignment memberAlignment;
    public boolean needSpace = false;
    public int nlsTagCounter;
    public int pageWidth;
    public boolean pendingSpace = false;
    public Scanner scanner;
    public int scannerEndPosition;
    public int tabSize;
    private int textRegionEnd;
    private int textRegionStart;
    public boolean useTab;

    Scribe(CodeFormatterVisitor formatter, Map settings, int offset, int length, CodeSnippetParsingUtil codeSnippetParsingUtil) {
        RecordedParsingInformation information;
        Object assertModeSetting;
        this.scanner = settings != null ? ((assertModeSetting = settings.get("org.eclipse.jdt.core.compiler.source")) != null ? new Scanner(true, true, false, "1.4".equals(assertModeSetting) ? 0x300000L : 0x2F0000L, null, null, true) : new Scanner(true, true, false, 0x2F0000L, null, null, true)) : new Scanner(true, true, false, 0x2F0000L, null, null, true);
        this.formatter = formatter;
        this.pageWidth = formatter.preferences.page_width;
        this.tabSize = formatter.preferences.tab_size;
        this.useTab = formatter.preferences.use_tab;
        this.fillingSpace = (char)formatter.preferences.filling_space;
        this.setLineSeparatorAndIdentationLevel(formatter.preferences);
        this.textRegionStart = offset;
        this.textRegionEnd = offset + length - 1;
        if (codeSnippetParsingUtil != null && (information = codeSnippetParsingUtil.recordedParsingInformation) != null) {
            this.lineEnds = information.lineEnds;
            this.commentPositions = information.commentPositions;
        }
        this.reset();
    }

    private final void addDeleteEdit(int start, int end) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, EMPTY_STRING);
    }

    private final void addInsertEdit(int insertPosition, String insertedString) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(insertPosition, 0, insertedString);
    }

    private final void addOptimizedReplaceEdit(int offset, int length, String replacement) {
        if (this.editsIndex > 0) {
            OptimizedReplaceEdit previous = this.edits[this.editsIndex - 1];
            int previousOffset = previous.offset;
            int previousLength = previous.length;
            int endOffsetOfPreviousEdit = previousOffset + previousLength;
            int replacementLength = replacement.length();
            String previousReplacement = previous.replacement;
            int previousReplacementLength = previousReplacement.length();
            if (previousOffset == offset && previousLength == length && (replacementLength == 0 || previousReplacementLength == 0)) {
                if (this.currentAlignment != null) {
                    Location location = this.currentAlignment.location;
                    if (location.editsIndex == this.editsIndex) {
                        --location.editsIndex;
                        location.textEdit = previous;
                    }
                }
                --this.editsIndex;
                return;
            }
            if (endOffsetOfPreviousEdit == offset) {
                if (length != 0) {
                    if (replacementLength != 0) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, previousReplacement + replacement);
                    } else if (previousLength + length == previousReplacementLength) {
                        boolean canBeRemoved = true;
                        for (int i = previousOffset; i < previousOffset + previousReplacementLength; ++i) {
                            if (this.scanner.source[i] == previousReplacement.charAt(i - previousOffset)) continue;
                            this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousReplacementLength, previousReplacement);
                            canBeRemoved = false;
                            break;
                        }
                        if (canBeRemoved) {
                            if (this.currentAlignment != null) {
                                Location location = this.currentAlignment.location;
                                if (location.editsIndex == this.editsIndex) {
                                    --location.editsIndex;
                                    location.textEdit = previous;
                                }
                            }
                            --this.editsIndex;
                        }
                    } else {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, previousReplacement);
                    }
                } else if (replacementLength != 0) {
                    this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength, previousReplacement + replacement);
                }
            } else {
                this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
            }
        } else {
            this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
        }
    }

    private final void addReplaceEdit(int start, int end, String replacement) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, replacement);
    }

    public void alignFragment(Alignment alignment, int fragmentIndex) {
        alignment.fragmentIndex = fragmentIndex;
        alignment.checkColumn();
        alignment.performFragmentEffect();
    }

    public void checkNLSTag(int sourceStart) {
        if (this.hasNLSTag(sourceStart)) {
            ++this.nlsTagCounter;
        }
    }

    public void consumeNextToken() {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart) {
        return this.createAlignment(name, mode, 2, count, sourceRestart);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart) {
        return this.createAlignment(name, mode, tieBreakRule, count, sourceRestart, this.formatter.preferences.continuation_indentation, false);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, continuationIndent, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        Alignment alignment = new Alignment(name, mode, tieBreakRule, this, count, sourceRestart, continuationIndent);
        if (adjust && this.memberAlignment != null) {
            Alignment current = this.memberAlignment;
            while (current.enclosing != null) {
                current = current.enclosing;
            }
            if ((current.mode & 0x100) != 0) {
                int indentSize = this.useTab ? 1 : this.tabSize;
                switch (current.chunkKind) {
                    case 2: 
                    case 3: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                        alignment.update();
                        break;
                    }
                    case 1: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                        alignment.update();
                    }
                }
            } else {
                block4 : switch (current.mode & 0x70) {
                    case 16: 
                    case 32: 
                    case 48: 
                    case 64: 
                    case 80: {
                        int indentSize = this.useTab ? 1 : this.tabSize;
                        switch (current.chunkKind) {
                            case 2: 
                            case 3: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                                alignment.update();
                                break block4;
                            }
                            case 1: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                                alignment.update();
                            }
                        }
                    }
                }
            }
        }
        return alignment;
    }

    public Alignment createMemberAlignment(String name, int mode, int count, int sourceRestart) {
        Alignment mAlignment = this.createAlignment(name, mode, 2, count, sourceRestart);
        mAlignment.breakIndentationLevel = this.indentationLevel;
        return mAlignment;
    }

    public void enterAlignment(Alignment alignment) {
        alignment.enclosing = this.currentAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.currentAlignment = alignment;
    }

    public void enterMemberAlignment(Alignment alignment) {
        alignment.enclosing = this.memberAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.memberAlignment = alignment;
    }

    public void exitAlignment(Alignment alignment, boolean discardAlignment) {
        Alignment current = this.currentAlignment;
        while (current != null && current != alignment) {
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment.location.outputIndentationLevel;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        if (discardAlignment) {
            this.currentAlignment = alignment.enclosing;
        }
    }

    public void exitMemberAlignment(Alignment alignment) {
        Alignment current = this.memberAlignment;
        while (current != null && current != alignment) {
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = current.location.outputIndentationLevel;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        this.memberAlignment = current.enclosing;
    }

    public Alignment getAlignment(String name) {
        if (this.currentAlignment != null) {
            return this.currentAlignment.getAlignment(name);
        }
        return null;
    }

    public int getColumnIndentationLevel() {
        if (this.useTab) {
            return (this.column - 1) / this.tabSize;
        }
        return this.column - 1;
    }

    public final int getCommentIndex(int position) {
        if (this.commentPositions == null) {
            return -1;
        }
        int length = this.commentPositions.length;
        if (length == 0) {
            return -1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            int bound = this.commentPositions[m][1];
            if (bound < 0) {
                bound = -bound;
            }
            if (bound < position) {
                g = m + 1;
                continue;
            }
            if (bound > position) {
                d = m - 1;
                continue;
            }
            return m;
        }
        return -(g + 1);
    }

    public String getEmptyLines(int linesNumber) {
        if (this.nlsTagCounter > 0) {
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.lastNumberOfNewLines == 0) {
            ++linesNumber;
            for (int i = 0; i < linesNumber; ++i) {
                buffer.append(this.lineSeparator);
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            for (int i = 0; i < linesNumber; ++i) {
                buffer.append(this.lineSeparator);
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= linesNumber) {
                return EMPTY_STRING;
            }
            int realNewLineNumber = linesNumber - this.lastNumberOfNewLines + 1;
            for (int i = 0; i < realNewLineNumber; ++i) {
                buffer.append(this.lineSeparator);
            }
            this.lastNumberOfNewLines += realNewLineNumber;
            this.line += realNewLineNumber;
            this.column = 1;
            this.needSpace = false;
        }
        return String.valueOf(buffer);
    }

    public int getIndentationLevel(int someColumn) {
        if (someColumn == 1) {
            return this.indentationLevel;
        }
        if (this.useTab) {
            return (someColumn - 1) / this.tabSize;
        }
        return someColumn - 1;
    }

    public OptimizedReplaceEdit getLastEdit() {
        if (this.editsIndex > 0) {
            return this.edits[this.editsIndex - 1];
        }
        return null;
    }

    public final int getLineEnd(int lineNumber) {
        if (this.lineEnds == null) {
            return -1;
        }
        if (lineNumber >= this.lineEnds.length + 1) {
            return this.scannerEndPosition;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        return this.lineEnds[lineNumber - 1];
    }

    Alignment getMemberAlignment() {
        return this.memberAlignment;
    }

    public String getNewLine() {
        if (this.nlsTagCounter > 0) {
            return EMPTY_STRING;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return EMPTY_STRING;
        }
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        return this.lineSeparator;
    }

    public int getNextIndentationLevel(int someColumn) {
        if (someColumn == 1) {
            return this.indentationLevel;
        }
        if (this.useTab) {
            int rem = (someColumn - 1) % this.tabSize;
            return rem == 0 ? (someColumn - 1) / this.tabSize : (someColumn - 1) / this.tabSize + 1;
        }
        return someColumn - 1;
    }

    private String getPreserveEmptyLines(int count) {
        if (count > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                return this.getEmptyLines(linesToPreserve);
            }
            return this.getNewLine();
        }
        return EMPTY_STRING;
    }

    public TextEdit getRootEdit() {
        MultiTextEdit edit = null;
        int length = this.textRegionEnd - this.textRegionStart + 1;
        edit = this.textRegionStart <= 0 ? (length <= 0 ? new MultiTextEdit(0, 0) : new MultiTextEdit(0, this.textRegionEnd + 1)) : new MultiTextEdit(this.textRegionStart, this.textRegionEnd - this.textRegionStart + 1);
        int max = this.editsIndex;
        for (int i = 0; i < max; ++i) {
            OptimizedReplaceEdit currentEdit = this.edits[i];
            if (!this.isValidEdit(currentEdit)) continue;
            edit.addChild((TextEdit)new ReplaceEdit(currentEdit.offset, currentEdit.length, currentEdit.replacement));
        }
        this.edits = null;
        return edit;
    }

    public void handleLineTooLong() {
        int relativeDepth = 0;
        int outerMostDepth = -1;
        Alignment targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.tieBreakRule == 1 && targetAlignment.couldBreak()) {
                outerMostDepth = relativeDepth;
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
        if (outerMostDepth >= 0) {
            throw new AlignmentException(1, outerMostDepth);
        }
        relativeDepth = 0;
        targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.couldBreak()) {
                throw new AlignmentException(1, relativeDepth);
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
    }

    private boolean hasNLSTag(int sourceStart) {
        int index = Arrays.binarySearch(this.lineEnds, sourceStart);
        int currentLineEnd = this.getLineEnd(-index);
        if (currentLineEnd != -1) {
            int lineIndexForComment;
            int start;
            int commentIndex = this.getCommentIndex(currentLineEnd);
            if (commentIndex < 0) {
                commentIndex = -commentIndex - 2;
            }
            if (commentIndex >= 0 && commentIndex < this.commentPositions.length && (start = this.commentPositions[commentIndex][0]) < 0 && (lineIndexForComment = Arrays.binarySearch(this.lineEnds, start = -start)) == index) {
                return this.indexOf("//$NON-NLS-".toCharArray(), this.scanner.source, start, currentLineEnd) != -1;
            }
        }
        return false;
    }

    public void indent() {
        this.indentationLevel = this.useTab ? ++this.indentationLevel : (this.indentationLevel += this.tabSize);
    }

    private int indexOf(char[] toBeFound, char[] source, int start, int end) {
        if (toBeFound == null || source == null) {
            throw new IllegalArgumentException();
        }
        int toBeFoundLength = toBeFound.length;
        if (end < start || end - start + 1 < toBeFoundLength) {
            return -1;
        }
        int indexInSource = 0;
        for (int i = start; i < end; ++i) {
            int j;
            if (source[i] != toBeFound[indexInSource]) continue;
            ++indexInSource;
            for (j = i + 1; j < end && indexInSource < toBeFoundLength && toBeFound[indexInSource] == source[j]; ++indexInSource, ++j) {
            }
            if (j == i + toBeFoundLength) {
                return i;
            }
            indexInSource = 0;
        }
        return -1;
    }

    public void initializeScanner(char[] compilationUnitSource) {
        this.scanner.setSource(compilationUnitSource);
        this.scannerEndPosition = compilationUnitSource.length;
        this.scanner.resetTo(0, this.scannerEndPosition);
        this.edits = new OptimizedReplaceEdit[100];
    }

    private boolean isValidEdit(OptimizedReplaceEdit edit) {
        int editLength = edit.length;
        int editReplacementLength = edit.replacement.length();
        int editOffset = edit.offset;
        if (editLength != 0) {
            if (this.textRegionStart <= editOffset && editOffset + editLength - 1 <= this.textRegionEnd) {
                if (editReplacementLength != 0 && editLength == editReplacementLength) {
                    int max = editOffset + editLength;
                    for (int i = editOffset; i < max; ++i) {
                        if (this.scanner.source[i] == edit.replacement.charAt(i - editOffset)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            if (editOffset + editLength == this.textRegionStart) {
                int replacementStringIndex;
                int i;
                int max = editOffset + editLength;
                for (i = editOffset; i < max && (replacementStringIndex = i - editOffset) < editReplacementLength && this.scanner.source[i] == edit.replacement.charAt(replacementStringIndex); ++i) {
                }
                if (i - editOffset != editReplacementLength && i != editOffset + editLength - 1) {
                    edit.offset = this.textRegionStart;
                    edit.length = 0;
                    edit.replacement = edit.replacement.substring(i - editOffset);
                    return true;
                }
            }
        } else if (this.textRegionStart <= editOffset && editOffset <= this.textRegionEnd) {
            return true;
        }
        return false;
    }

    private void preserveEmptyLines(int count, int insertPosition) {
        if (count > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                this.printEmptyLines(linesToPreserve, insertPosition);
            } else {
                this.printNewLine(insertPosition);
            }
        }
    }

    private void print(char[] s, boolean considerSpaceIfAny) {
        if (this.checkLineWrapping && s.length + this.column > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.lastNumberOfNewLines = 0;
        this.printIndentationIfNecessary();
        if (considerSpaceIfAny) {
            this.space();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), " ");
        }
        this.pendingSpace = false;
        this.needSpace = false;
        this.column += s.length;
        this.needSpace = true;
    }

    private void printBlockComment(char[] s, boolean isJavadoc) {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        boolean isNewLine = false;
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        this.printIndentationIfNecessary();
        if (this.pendingSpace) {
            this.addInsertEdit(currentTokenStartPosition, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int previousStart = currentTokenStartPosition;
        while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.currentPosition;
            switch (currentCharacter) {
                case 13: {
                    start = previousStart;
                    isNewLine = true;
                    if (!this.scanner.getNextChar('\n')) break;
                    currentCharacter = 10;
                    nextCharacterStart = this.scanner.currentPosition;
                    break;
                }
                case 10: {
                    start = previousStart;
                    isNewLine = true;
                    break;
                }
                default: {
                    if (isNewLine) {
                        if (Character.isWhitespace((char)currentCharacter)) {
                            int previousStartPosition = this.scanner.currentPosition;
                            while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && Character.isWhitespace((char)currentCharacter)) {
                                previousStart = nextCharacterStart;
                                previousStartPosition = this.scanner.currentPosition;
                                currentCharacter = this.scanner.getNextChar();
                                nextCharacterStart = this.scanner.currentPosition;
                            }
                            if (currentCharacter == 13 || currentCharacter == 10) {
                                nextCharacterStart = previousStartPosition;
                            }
                        }
                        this.column = 1;
                        ++this.line;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(this.lineSeparator);
                        this.printIndentationIfNecessary(buffer);
                        buffer.append(this.fillingSpace);
                        this.addReplaceEdit(start, previousStart - 1, String.valueOf(buffer));
                    } else {
                        this.column += nextCharacterStart - previousStart;
                    }
                    isNewLine = false;
                }
            }
            previousStart = nextCharacterStart;
            this.scanner.currentPosition = nextCharacterStart;
        }
        this.lastNumberOfNewLines = 0;
        this.needSpace = false;
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
        if (isJavadoc) {
            this.printNewLine();
        }
    }

    public void printComment() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasLineComment = false;
            boolean hasWhitespace = false;
            int count = 0;
            block12: while ((this.currentToken = this.scanner.getNextToken()) != 54) {
                switch (this.currentToken) {
                    case 1000: {
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        count = 0;
                        int max = whiteSpaces.length;
                        block13: for (int i = 0; i < max; ++i) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    continue block13;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                        }
                        if (count == 0) {
                            hasWhitespace = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasComment) {
                            if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasLineComment) {
                            this.preserveEmptyLines(count, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (count != 0 && this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                            this.addReplaceEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), this.getPreserveEmptyLines(count - 1));
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        continue block12;
                    }
                    case 1001: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printCommentLine(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        count = 0;
                        continue block12;
                    }
                    case 1002: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        continue block12;
                    }
                    case 1003: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        continue block12;
                    }
                }
                this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                return;
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printCommentLine(char[] s) {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        if (this.indexOf("//$NON-NLS-".toCharArray(), this.scanner.source, currentTokenStartPosition, currentTokenEndPosition) != -1) {
            this.nlsTagCounter = 0;
        }
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        this.printIndentationIfNecessary();
        if (this.pendingSpace) {
            this.addInsertEdit(currentTokenStartPosition, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int previousStart = currentTokenStartPosition;
        block4: while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.currentPosition;
            switch (currentCharacter) {
                case 13: {
                    start = previousStart;
                    break block4;
                }
                case 10: {
                    start = previousStart;
                    break block4;
                }
                default: {
                    previousStart = nextCharacterStart;
                    continue block4;
                }
            }
        }
        if (start != currentTokenStartPosition) {
            this.addReplaceEdit(start, currentTokenEndPosition - 1, this.lineSeparator);
        }
        ++this.line;
        this.column = 1;
        this.needSpace = false;
        this.lastNumberOfNewLines = 1;
        if (this.currentAlignment != null) {
            this.indentationLevel = this.memberAlignment != null ? (this.currentAlignment.location.inputOffset > this.memberAlignment.location.inputOffset ? Math.max(this.indentationLevel, this.currentAlignment.breakIndentationLevel) : Math.max(this.indentationLevel, this.memberAlignment.breakIndentationLevel)) : Math.max(this.indentationLevel, this.currentAlignment.breakIndentationLevel);
        }
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
    }

    public void printEmptyLines(int linesNumber) {
        this.printEmptyLines(linesNumber, this.scanner.getCurrentTokenEndPosition() + 1);
    }

    private void printEmptyLines(int linesNumber, int insertPosition) {
        if (this.nlsTagCounter > 0) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.lastNumberOfNewLines == 0) {
            ++linesNumber;
            for (int i = 0; i < linesNumber; ++i) {
                buffer.append(this.lineSeparator);
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            for (int i = 0; i < linesNumber; ++i) {
                buffer.append(this.lineSeparator);
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= linesNumber) {
                return;
            }
            int realNewLineNumber = linesNumber - this.lastNumberOfNewLines + 1;
            for (int i = 0; i < realNewLineNumber; ++i) {
                buffer.append(this.lineSeparator);
            }
            this.lastNumberOfNewLines += realNewLineNumber;
            this.line += realNewLineNumber;
            this.column = 1;
            this.needSpace = false;
        }
        this.addInsertEdit(insertPosition, buffer.toString());
    }

    private void printIndentationIfNecessary() {
        int indentationColumn = (this.useTab ? this.indentationLevel * this.tabSize : this.indentationLevel) + 1;
        if (this.column < indentationColumn) {
            StringBuffer buffer = new StringBuffer();
            int max = this.indentationLevel;
            for (int i = this.getColumnIndentationLevel(); i < max; ++i) {
                if (this.useTab) {
                    this.tab(buffer);
                    continue;
                }
                ++this.column;
                buffer.append(this.fillingSpace);
                this.needSpace = false;
            }
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), buffer.toString());
            this.pendingSpace = false;
        }
    }

    private void printIndentationIfNecessary(StringBuffer buffer) {
        int indentationColumn = (this.useTab ? this.indentationLevel * this.tabSize : this.indentationLevel) + 1;
        if (this.column < indentationColumn) {
            int max = this.indentationLevel;
            for (int i = this.getColumnIndentationLevel(); i < max; ++i) {
                if (this.useTab) {
                    this.tab(buffer);
                    continue;
                }
                ++this.column;
                buffer.append(this.fillingSpace);
                this.needSpace = false;
            }
        }
    }

    public void printModifiers() {
        try {
            boolean isFirstModifier = true;
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            block13: while ((this.currentToken = this.scanner.getNextToken()) != 54) {
                switch (this.currentToken) {
                    case 55: 
                    case 57: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: {
                        this.print(this.scanner.getRawTokenSource(), !isFirstModifier);
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                        continue block13;
                    }
                    case 1002: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        continue block13;
                    }
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        continue block13;
                    }
                    case 1001: {
                        this.printCommentLine(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        continue block13;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int max = whiteSpaces.length;
                        block14: for (int i = 0; i < max; ++i) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    continue block14;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                        }
                        if (count >= 1 && hasComment) {
                            this.printNewLine();
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = false;
                        continue block13;
                    }
                }
                this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                return;
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNewLine() {
        if (this.nlsTagCounter > 0) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(this.scanner.getCurrentTokenEndPosition() + 1, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
    }

    public void printNewLine(int insertPosition) {
        if (this.nlsTagCounter > 0) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(insertPosition, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
    }

    public void printNextToken(int expectedTokenType) {
        this.printNextToken(expectedTokenType, false);
    }

    public void printNextToken(int expectedTokenType, boolean considerSpaceIfAny) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (expectedTokenType != this.currentToken) {
                throw new AbortFormatting("unexpected token type, expecting:" + expectedTokenType + ", actual:" + this.currentToken);
            }
            this.print(currentTokenSource, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNextToken(int[] expectedTokenTypes) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (Arrays.binarySearch(expectedTokenTypes, this.currentToken) < 0) {
                StringBuffer expectations = new StringBuffer(5);
                for (int i = 0; i < expectedTokenTypes.length; ++i) {
                    if (i > 0) {
                        expectations.append(',');
                    }
                    expectations.append(expectedTokenTypes[i]);
                }
                throw new AbortFormatting("unexpected token type, expecting:[" + expectations.toString() + "], actual:" + this.currentToken);
            }
            this.print(currentTokenSource, false);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printQualifiedReference(int sourceEnd) {
        int currentTokenStartPosition = this.scanner.currentPosition;
        try {
            do {
                this.printComment();
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 54: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1002: 
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        this.printCommentLine(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 3: 
                    case 28: {
                        this.print(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            } while (this.scanner.currentPosition <= sourceEnd);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printRule(StringBuffer stringBuffer) {
        int i;
        for (i = 0; i < this.pageWidth; ++i) {
            if (i % this.tabSize == 0) {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('-');
        }
        stringBuffer.append(this.lineSeparator);
        for (i = 0; i < this.pageWidth / this.tabSize; ++i) {
            stringBuffer.append(i);
            stringBuffer.append('\t');
        }
    }

    public void printTrailingComment() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasWhitespaces = false;
            boolean hasComment = false;
            boolean hasLineComment = false;
            block11: while ((this.currentToken = this.scanner.getNextToken()) != 54) {
                switch (this.currentToken) {
                    case 1000: {
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int max = whiteSpaces.length;
                        block12: for (int i = 0; i < max; ++i) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    continue block12;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                        }
                        if (hasLineComment) {
                            if (count >= 1) {
                                currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(count, currentTokenStartPosition);
                                this.addDeleteEdit(currentTokenStartPosition, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        if (count >= 1) {
                            if (hasComment) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        hasWhitespaces = true;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        continue block11;
                    }
                    case 1001: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printCommentLine(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        continue block11;
                    }
                    case 1002: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        continue block11;
                    }
                }
                this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                return;
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    void redoAlignment(AlignmentException e) {
        if (e.relativeDepth > 0) {
            --e.relativeDepth;
            this.currentAlignment = this.currentAlignment.enclosing;
            throw e;
        }
        this.resetAt(this.currentAlignment.location);
        this.scanner.resetTo(this.currentAlignment.location.inputOffset, this.scanner.eofPosition);
        this.currentAlignment.chunkKind = 0;
    }

    void redoMemberAlignment(AlignmentException e) {
        this.resetAt(this.memberAlignment.location);
        this.scanner.resetTo(this.memberAlignment.location.inputOffset, this.scanner.eofPosition);
        this.memberAlignment.chunkKind = 0;
    }

    public void reset() {
        this.checkLineWrapping = true;
        this.line = 0;
        this.column = 1;
        this.editsIndex = 0;
        this.nlsTagCounter = 0;
    }

    private void resetAt(Location location) {
        this.line = location.outputLine;
        this.column = location.outputColumn;
        this.indentationLevel = location.outputIndentationLevel;
        this.lastNumberOfNewLines = location.lastNumberOfNewLines;
        this.needSpace = location.needSpace;
        this.pendingSpace = location.pendingSpace;
        this.editsIndex = location.editsIndex;
        this.nlsTagCounter = location.nlsTagCounter;
        if (this.editsIndex > 0) {
            this.edits[this.editsIndex - 1] = location.textEdit;
        }
        this.formatter.lastLocalDeclarationSourceStart = location.lastLocalDeclarationSourceStart;
    }

    private void resize() {
        this.edits = new OptimizedReplaceEdit[this.editsIndex * 2];
        System.arraycopy(this.edits, 0, this.edits, 0, this.editsIndex);
    }

    public void setLineSeparatorAndIdentationLevel(DefaultCodeFormatterOptions preferences) {
        this.lineSeparator = preferences.line_separator;
        this.indentationLevel = this.useTab ? preferences.initial_indentation_level : preferences.initial_indentation_level * this.tabSize;
    }

    public void space() {
        if (!this.needSpace) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.pendingSpace = true;
        ++this.column;
        this.needSpace = false;
    }

    private void tab(StringBuffer buffer) {
        this.lastNumberOfNewLines = 0;
        int complement = this.tabSize - (this.column - 1) % this.tabSize;
        if (this.useTab) {
            buffer.append('\t');
        } else {
            for (int i = 0; i < complement; ++i) {
                buffer.append(this.fillingSpace);
            }
        }
        this.column += complement;
        this.needSpace = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(page witdh = " + this.pageWidth + ") - (useTab = " + this.useTab + ") - (tabSize = " + this.tabSize + ")").append(this.lineSeparator).append("(line = " + this.line + ") - (column = " + this.column + ") - (identationLevel = " + this.indentationLevel + ")").append(this.lineSeparator).append("(needSpace = " + this.needSpace + ") - (lastNumberOfNewLines = " + this.lastNumberOfNewLines + ") - (checkLineWrapping = " + this.checkLineWrapping + ")").append(this.lineSeparator).append("==================================================================================").append(this.lineSeparator);
        this.printRule(stringBuffer);
        return stringBuffer.toString();
    }

    public void unIndent() {
        this.indentationLevel = this.useTab ? --this.indentationLevel : (this.indentationLevel -= this.tabSize);
    }
}

