/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.measurement;

import org.osgi.util.measurement.Unit;

public class Measurement
implements Comparable {
    final double value;
    final double error;
    final long time;
    final Unit unit;
    private String name;

    public Measurement(double d, double d2, Unit unit, long l) {
        this.value = d;
        this.error = Math.abs(d2);
        this.unit = unit != null ? unit : Unit.unity;
        this.time = l;
    }

    public Measurement(double d, double d2, Unit unit) {
        this(d, d2, unit, 0L);
    }

    public Measurement(double d, Unit unit) {
        this(d, 0.0, unit, 0L);
    }

    public Measurement(double d) {
        this(d, 0.0, null, 0L);
    }

    public final double getValue() {
        return this.value;
    }

    public final double getError() {
        return this.error;
    }

    public final Unit getUnit() {
        return this.unit;
    }

    public final long getTime() {
        return this.time;
    }

    public Measurement mul(Measurement measurement) {
        double d = measurement.value;
        return new Measurement(this.value * d, Math.abs(this.value) * measurement.error + this.error * Math.abs(d), this.unit.mul(measurement.unit), this.time);
    }

    public Measurement mul(double d, Unit unit) {
        return new Measurement(this.value * d, this.error * Math.abs(d), this.unit.mul(unit), this.time);
    }

    public Measurement mul(double d) {
        return new Measurement(this.value * d, this.error * Math.abs(d), this.unit, this.time);
    }

    public Measurement div(Measurement measurement) {
        double d = measurement.value;
        return new Measurement(this.value / d, (Math.abs(this.value) * measurement.error + this.error * Math.abs(d)) / (d * d), this.unit.div(measurement.unit), this.time);
    }

    public Measurement div(double d, Unit unit) {
        return new Measurement(this.value / d, this.error / Math.abs(d), this.unit.div(unit), this.time);
    }

    public Measurement div(double d) {
        return new Measurement(this.value / d, this.error / Math.abs(d), this.unit, this.time);
    }

    public Measurement add(Measurement measurement) {
        return new Measurement(this.value + measurement.value, this.error + measurement.error, this.unit.add(measurement.unit), this.time);
    }

    public Measurement add(double d, Unit unit) {
        return new Measurement(this.value + d, this.error, this.unit.add(unit), this.time);
    }

    public Measurement add(double d) {
        return new Measurement(this.value + d, this.error, this.unit, this.time);
    }

    public Measurement sub(Measurement measurement) {
        return new Measurement(this.value - measurement.value, this.error + measurement.error, this.unit.sub(measurement.unit), this.time);
    }

    public Measurement sub(double d, Unit unit) {
        return new Measurement(this.value - d, this.error, this.unit.sub(unit), this.time);
    }

    public Measurement sub(double d) {
        return new Measurement(this.value - d, this.error, this.unit, this.time);
    }

    public String toString() {
        if (this.name == null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.value);
            if (this.error != 0.0) {
                stringBuffer.append(" +/- ");
                stringBuffer.append(this.error);
            }
            if ((string = this.unit.toString()).length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            this.name = stringBuffer.toString();
        }
        return this.name;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        Measurement measurement = (Measurement)object;
        if (!this.unit.equals(measurement.unit)) {
            throw new ArithmeticException("Cannot compare " + this + " and " + measurement);
        }
        if (this.value == measurement.value) {
            return 0;
        }
        if (this.value < measurement.value) {
            if (this.value + this.error >= measurement.value - measurement.error) {
                return 0;
            }
            return -1;
        }
        if (this.value - this.error <= measurement.value + measurement.error) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value + this.error);
        return (int)(l ^ l >>> 32) ^ this.unit.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Measurement)) {
            return false;
        }
        Measurement measurement = (Measurement)object;
        return this.value == measurement.value && this.error == measurement.error && this.unit.equals(measurement.unit);
    }
}

