/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public abstract class ProcessorBasedRefactoring
extends Refactoring {
    private RefactoringParticipant[] fParticipants;
    private SharableParticipants fSharedParticipants = new SharableParticipants();
    private static final RefactoringParticipant[] EMPTY_PARTICIPANTS = new RefactoringParticipant[0];

    protected ProcessorBasedRefactoring() {
    }

    public abstract RefactoringProcessor getProcessor();

    public final boolean isApplicable() throws CoreException {
        return this.getProcessor().isApplicable();
    }

    public String getName() {
        return this.getProcessor().getProcessorName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 10);
        pm.setTaskName(RefactoringCoreMessages.getString("ProcessorBasedRefactoring.initial_conditions"));
        result.merge(this.getProcessor().checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 8)));
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        pm.done();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        CheckConditionsContext context = this.createCheckConditionsContext();
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.getString("ProcessorBasedRefactoring.final_conditions"));
        result.merge(this.getProcessor().checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 5), context));
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fParticipants = this.getProcessor().loadParticipants(result, this.fSharedParticipants);
        if (this.fParticipants == null) {
            this.fParticipants = EMPTY_PARTICIPANTS;
        }
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        SubProgressMonitor sm = new SubProgressMonitor(pm, 2);
        sm.beginTask("", this.fParticipants.length);
        for (int i = 0; i < this.fParticipants.length && !result.hasFatalError(); ++i) {
            result.merge(this.fParticipants[i].checkConditions((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sm, 1), context));
            if (!sm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        sm.done();
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", this.fParticipants.length + 2);
        pm.setTaskName(RefactoringCoreMessages.getString("ProcessorBasedRefactoring.create_change"));
        Change processorChange = this.getProcessor().createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        HashMap<Change, RefactoringParticipant> participantMap = new HashMap<Change, RefactoringParticipant>();
        for (int i = 0; i < this.fParticipants.length; ++i) {
            RefactoringParticipant participant = this.fParticipants[i];
            try {
                Change change = participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (change != null) {
                    changes.add(change);
                    participantMap.put(change, participant);
                }
            }
            catch (CoreException e) {
                this.disableParticipant(participant, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.disableParticipant(participant, e);
                throw e;
            }
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        Change postChange = this.getProcessor().postCreateChange(changes.toArray(new Change[changes.size()]), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ProcessorChange result = new ProcessorChange(this.getName());
        result.add(processorChange);
        result.addAll(changes.toArray(new Change[changes.size()]));
        result.setParticipantMap(participantMap);
        if (postChange != null) {
            result.add(postChange);
        }
        return result;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance((Object)this)) {
            return this;
        }
        if (clazz.isInstance((Object)this.getProcessor())) {
            return this.getProcessor();
        }
        return super.getAdapter(clazz);
    }

    public String toString() {
        return this.getName();
    }

    private CheckConditionsContext createCheckConditionsContext() throws CoreException {
        CheckConditionsContext result = new CheckConditionsContext();
        ValidateEditChecker checker = new ValidateEditChecker(this.getValidationContext());
        result.add(checker);
        return result;
    }

    private void disableParticipant(RefactoringParticipant participant, Throwable e) {
        ParticipantDescriptor descriptor = participant.getDescriptor();
        descriptor.disable();
        RefactoringCorePlugin.logRemovedParticipant(descriptor, e);
    }

    private static class ProcessorChange
    extends CompositeChange {
        private Map fParticipantMap;

        public ProcessorChange(String name) {
            super(name);
        }

        public void setParticipantMap(Map map) {
            this.fParticipantMap = map;
        }

        protected void internalHandleException(Change change, Throwable e) {
            RefactoringParticipant participant = (RefactoringParticipant)((Object)this.fParticipantMap.get(change));
            if (participant != null) {
                ParticipantDescriptor descriptor = participant.getDescriptor();
                descriptor.disable();
                RefactoringCorePlugin.logRemovedParticipant(descriptor, e);
            }
        }
    }
}

