/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class JavadocTagsSubProcessor {
    public static void getMissingJavadocCommentProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration(node);
        if (declaration == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding binding = Bindings.getBindingOfParentType((ASTNode)declaration);
        if (binding == null) {
            return;
        }
        if (declaration instanceof MethodDeclaration) {
            String string;
            MethodDeclaration methodDecl = (MethodDeclaration)declaration;
            IMethodBinding methodBinding = methodDecl.resolveBinding();
            if (methodBinding != null) {
                methodBinding = Bindings.findDeclarationInHierarchy(binding, methodBinding.getName(), methodBinding.getParameterTypes());
            }
            if ((string = CodeGeneration.getMethodComment(cu, binding.getName(), methodDecl, methodBinding, String.valueOf('\n'))) != null) {
                String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.method.description");
                proposals.add(JavadocTagsSubProcessor.getNewJavadocTagProposal(cu, declaration.getStartPosition(), string, label));
            }
        } else if (declaration instanceof TypeDeclaration) {
            String typeQualifiedName = Bindings.getTypeQualifiedName(binding);
            String string = CodeGeneration.getTypeComment(cu, typeQualifiedName, String.valueOf('\n'));
            if (string != null) {
                String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.type.description");
                proposals.add(JavadocTagsSubProcessor.getNewJavadocTagProposal(cu, declaration.getStartPosition(), string, label));
            }
        } else if (declaration instanceof FieldDeclaration) {
            String comment = "/**\n *\n */\n";
            List fragments = ((FieldDeclaration)declaration).fragments();
            if (fragments != null && fragments.size() > 0) {
                VariableDeclaration decl = (VariableDeclaration)fragments.get(0);
                String fieldName = decl.getName().getIdentifier();
                String typeName = binding.getName();
                comment = CodeGeneration.getFieldComment(cu, typeName, fieldName, String.valueOf('\n'));
            }
            String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.field.description");
            proposals.add(JavadocTagsSubProcessor.getNewJavadocTagProposal(cu, declaration.getStartPosition(), comment, label));
        }
    }

    private static CUCorrectionProposal getNewJavadocTagProposal(ICompilationUnit cu, final int insertPosition, final String comment, String label) {
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif");
        return new CUCorrectionProposal(label, cu, 1, image){

            protected void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
                try {
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    int tabWidth = CodeFormatterUtil.getTabWidth();
                    IRegion region = document.getLineInformationOfOffset(insertPosition);
                    String lineContent = document.get(region.getOffset(), region.getLength());
                    String indentString = Strings.getIndentString(lineContent, tabWidth);
                    String str = Strings.changeIndent(comment, 0, tabWidth, indentString, lineDelimiter);
                    InsertEdit edit = new InsertEdit(insertPosition, str);
                    rootEdit.addChild((TextEdit)edit);
                    if (comment.charAt(comment.length() - 1) != '\n') {
                        rootEdit.addChild((TextEdit)new InsertEdit(insertPosition, lineDelimiter));
                        rootEdit.addChild((TextEdit)new InsertEdit(insertPosition, indentString));
                    }
                }
                catch (BadLocationException e) {
                    throw new CoreException(JavaUIStatus.createError(4, e));
                }
            }
        };
    }

    public static void getMissingJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Type type;
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration(node);
        if (!(declaration instanceof MethodDeclaration)) {
            return;
        }
        Javadoc javadoc = declaration.getJavadoc();
        if (javadoc == null) {
            return;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)declaration;
        AST ast = javadoc.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal("", context.getCompilationUnit(), rewrite, 1, image);
        switch (problem.getProblemId()) {
            case -1610612265: {
                String name = ASTNodes.asString(node);
                proposal.setDisplayName(CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.paramtag.description"));
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@param");
                newTag.fragments().add(ast.newSimpleName(name));
                List params = methodDecl.parameters();
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousParamNames(params, node.getParent()));
                break;
            }
            case -1610612261: {
                proposal.setDisplayName(CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.returntag.description"));
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@return");
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, null);
                break;
            }
            case -1610612259: {
                proposal.setDisplayName(CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.throwstag.description"));
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@throws");
                List exceptions = methodDecl.thrownExceptions();
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousExceptionNames(exceptions, node));
                break;
            }
            default: {
                return;
            }
        }
        proposals.add(proposal);
        rewrite = ASTRewrite.create((AST)ast);
        tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
        String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.allmissing.description");
        ASTRewriteCorrectionProposal addAllMissing = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
        List list = methodDecl.parameters();
        for (int i = list.size() - 1; i >= 0; --i) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)list.get(i);
            String name = decl.getName().getIdentifier();
            if (JavadocTagsSubProcessor.findTag(javadoc, "@param", name) != null) continue;
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@param");
            newTag.fragments().add(ast.newSimpleName(name));
            JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousParamNames(list, (ASTNode)decl));
        }
        if (!(methodDecl.isConstructor() || (type = methodDecl.getReturnType()).isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID || JavadocTagsSubProcessor.findTag(javadoc, "@return", null) != null)) {
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@return");
            JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, null);
        }
        List thrownExceptions = methodDecl.thrownExceptions();
        for (int i = thrownExceptions.size() - 1; i >= 0; --i) {
            String name;
            Name exception = (Name)thrownExceptions.get(i);
            ITypeBinding binding = exception.resolveTypeBinding();
            if (binding == null || JavadocTagsSubProcessor.findThrowsTag(javadoc, name = binding.getName()) != null) continue;
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@throws");
            newTag.fragments().add(ast.newSimpleName(name));
            JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousExceptionNames(thrownExceptions, (ASTNode)exception));
        }
        proposals.add(addAllMissing);
    }

    private static Set getPreviousParamNames(List params, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        for (int i = 0; i < params.size(); ++i) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)params.get(i);
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add(curr.getName().getIdentifier());
        }
        return previousNames;
    }

    private static Set getPreviousExceptionNames(List list, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        for (int i = 0; i < list.size() && missingNode != list.get(i); ++i) {
            Name curr = (Name)list.get(i);
            previousNames.add(ASTNodes.getSimpleNameIdentifier(curr));
        }
        return previousNames;
    }

    public static TagElement findTag(Javadoc javadoc, String name, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        for (int i = 0; i < nTags; ++i) {
            TagElement curr = (TagElement)tags.get(i);
            if (!name.equals(curr.getTagName())) continue;
            if (arg != null) {
                String argument = JavadocTagsSubProcessor.getArgument(curr);
                if (!arg.equals(argument)) continue;
                return curr;
            }
            return curr;
        }
        return null;
    }

    public static TagElement findParamTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        for (int i = 0; i < nTags; ++i) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if (!"@param".equals(currName) || !arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) continue;
            return curr;
        }
        return null;
    }

    public static TagElement findThrowsTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        for (int i = 0; i < nTags; ++i) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if (!"@throws".equals(currName) && !"@exception".equals(currName) || !arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) continue;
            return curr;
        }
        return null;
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set sameKindLeadingNames) {
        JavadocTagsSubProcessor.insertTag(rewriter, newElement, sameKindLeadingNames, null);
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set sameKindLeadingNames, TextEditGroup groupDescription) {
        List tags = rewriter.getRewrittenList();
        String insertedTagName = newElement.getTagName();
        TagElement after = null;
        for (int i = tags.size() - 1; i >= 0; --i) {
            String arg;
            TagElement curr = (TagElement)tags.get(i);
            String tagName = curr.getTagName();
            if (tagName == null || JavadocTagsSubProcessor.isTagLeading(insertedTagName, tagName)) {
                after = curr;
                break;
            }
            if (sameKindLeadingNames == null || !JavadocTagsSubProcessor.isSameTag(insertedTagName, tagName) || (arg = JavadocTagsSubProcessor.getArgument(curr)) == null || !sameKindLeadingNames.contains(arg)) continue;
            after = curr;
            break;
        }
        if (after != null) {
            rewriter.insertAfter((ASTNode)newElement, after, groupDescription);
        } else {
            rewriter.insertFirst((ASTNode)newElement, groupDescription);
        }
    }

    private static boolean isSameTag(String insertedTagName, String tagName) {
        if (insertedTagName.equals(tagName)) {
            return true;
        }
        if ("@exception".equals(tagName)) {
            return "@throws".equals(insertedTagName);
        }
        return false;
    }

    private static boolean isTagLeading(String insertedTagName, String tagName) {
        if ("@exception".equals(insertedTagName) || "@throws".equals(insertedTagName)) {
            return "@param".equals(tagName) || "@return".equals(tagName);
        }
        if ("@return".equals(insertedTagName)) {
            return "@param".equals(tagName);
        }
        return false;
    }

    private static String getArgument(TagElement curr) {
        Object first;
        List fragments = curr.fragments();
        if (!fragments.isEmpty() && (first = fragments.get(0)) instanceof Name) {
            return ASTNodes.getSimpleNameIdentifier((Name)first);
        }
        return null;
    }

    public static void getRemoveJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ASTNode node;
        for (node = problem.getCoveringNode(context.getASTRoot()); node != null && !(node instanceof TagElement); node = node.getParent()) {
        }
        if (node == null) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        rewrite.remove(node, null);
        String label = CorrectionMessages.getString("JavadocTagsSubProcessor.removetag.description");
        Image image = JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        proposals.add(new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image));
    }
}

