/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class LaunchGroupExtension
implements ILaunchGroup {
    private IConfigurationElement fConfig;
    private ImageDescriptor fImageDescriptor;
    private ImageDescriptor fBannerImageDescriptor;

    public LaunchGroupExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor == null) {
            this.fImageDescriptor = this.createImageDescriptor("image");
        }
        return this.fImageDescriptor;
    }

    public ImageDescriptor getBannerImageDescriptor() {
        if (this.fBannerImageDescriptor == null) {
            this.fBannerImageDescriptor = this.createImageDescriptor("bannerImage");
        }
        return this.fBannerImageDescriptor;
    }

    public String getLabel() {
        return this.getConfigurationElement().getAttribute("label");
    }

    public String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public String getMode() {
        return this.getConfigurationElement().getAttribute("mode");
    }

    protected ImageDescriptor createImageDescriptor(String attribute) {
        Bundle bundle = Platform.getBundle((String)this.getConfigurationElement().getDeclaringExtension().getNamespace());
        URL iconURL = bundle.getEntry("/");
        String iconPath = this.getConfigurationElement().getAttribute(attribute);
        if (iconPath != null) {
            try {
                iconURL = new URL(iconURL, iconPath);
                return ImageDescriptor.createFromURL((URL)iconURL);
            }
            catch (MalformedURLException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public boolean isPublic() {
        String string = this.getConfigurationElement().getAttribute("public");
        if (string == null) {
            return true;
        }
        return string.equals("true");
    }
}

