/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.DebugViewDecoratingLabelProvider;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DebugViewLabelDecorator
extends LabelProvider
implements ILabelDecorator,
IDebugEventSetListener {
    private IDebugModelPresentation fPresentation;
    private DebugViewDecoratingLabelProvider fLabelProvider;
    protected LabelJob fNextJob = null;
    private Set resumedThreads = new HashSet();
    private IStackFrame fCurrentStackFrame = null;
    private Object fCurrentStackFrameLock = new Object();

    public DebugViewLabelDecorator(IDebugModelPresentation presentation) {
        this.fPresentation = presentation;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void setLabelProvider(DebugViewDecoratingLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        this.computeText(element);
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeText(Object element) {
        DebugViewLabelDecorator debugViewLabelDecorator = this;
        synchronized (debugViewLabelDecorator) {
            if (this.fNextJob == null) {
                this.fNextJob = new LabelJob(DebugUIViewsMessages.getString("DebugViewLabelDecorator.0"), this.fPresentation);
            }
            this.fNextJob.computeText(element);
        }
    }

    public void labelsComputed(final Object[] computedElements) {
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                DebugViewLabelDecorator.this.fLabelProvider.labelsComputed(computedElements);
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            if (event.getKind() == 2) {
                this.handleSuspendEvent(event);
                continue;
            }
            if (event.getKind() == 8) {
                this.handleTerminateEvent(event);
                continue;
            }
            if (event.getKind() != 1) continue;
            this.handleResumeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResumeEvent(DebugEvent event) {
        if (event.getSource() instanceof IThread && (event.isEvaluation() || event.isStepStart())) {
            IStackFrame frame;
            IThread thread = (IThread)event.getSource();
            Object object = this.fCurrentStackFrameLock;
            synchronized (object) {
                if (this.fCurrentStackFrame == null) {
                    return;
                }
                frame = this.fCurrentStackFrame;
            }
            if (thread == frame.getThread()) {
                this.resumedThreads.add(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSuspendEvent(DebugEvent event) {
        Object source = event.getSource();
        Set set = this.resumedThreads;
        synchronized (set) {
            if (!this.resumedThreads.remove(source)) {
                return;
            }
        }
        if (!event.isEvaluation() && (event.getDetail() & 8) == 0) {
            return;
        }
        IThread thread = (IThread)source;
        try {
            IStackFrame[] frames = thread.getStackFrames();
            for (int i = 0; i < frames.length; ++i) {
                this.computeText(frames[i]);
            }
        }
        catch (DebugException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTerminateEvent(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugTarget) {
            ArrayList copiedThreads = new ArrayList(this.resumedThreads);
            ListIterator iterator = copiedThreads.listIterator();
            while (iterator.hasNext()) {
                IThread thread = (IThread)iterator.next();
                if (thread.getDebugTarget() != source) continue;
                iterator.remove();
            }
            Set set = this.resumedThreads;
            synchronized (set) {
                this.resumedThreads.retainAll(copiedThreads);
            }
        }
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    protected class LabelJob
    extends Job
    implements ISchedulingRule {
        private Vector fElementQueue = new Vector();
        private IDebugModelPresentation fJobPresentation;

        public LabelJob(String name, IDebugModelPresentation presentation) {
            super(name);
            this.fJobPresentation = presentation;
            this.setRule(this);
            this.setSystem(true);
        }

        public void computeText(Object element) {
            if (!this.fElementQueue.contains(element)) {
                if (element instanceof IStackFrame) {
                    this.fElementQueue.add(element);
                } else {
                    this.fElementQueue.add(0, element);
                }
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            DebugViewLabelDecorator debugViewLabelDecorator = DebugViewLabelDecorator.this;
            synchronized (debugViewLabelDecorator) {
                DebugViewLabelDecorator.this.fNextJob = null;
            }
            int numElements = this.fElementQueue.size();
            monitor.beginTask(MessageFormat.format(DebugUIViewsMessages.getString("DebugViewLabelDecorator.1"), Integer.toString(numElements)), numElements);
            while (!this.fElementQueue.isEmpty() && !monitor.isCanceled()) {
                Object element;
                StringBuffer message = new StringBuffer(MessageFormat.format(DebugUIViewsMessages.getString("DebugViewLabelDecorator.1"), Integer.toString(this.fElementQueue.size())));
                if (DebugViewLabelDecorator.this.fNextJob != null) {
                    message.append(MessageFormat.format(DebugUIViewsMessages.getString("DebugViewLabelDecorator.2"), Integer.toString(DebugViewLabelDecorator.this.fNextJob.fElementQueue.size())));
                }
                monitor.setTaskName(message.toString());
                int blockSize = 10;
                if (this.fElementQueue.size() < blockSize) {
                    blockSize = this.fElementQueue.size();
                }
                ArrayList computedElements = new ArrayList();
                for (int i = 0; i < blockSize && (element = this.fElementQueue.remove(0)) != null; ++i) {
                    Object object;
                    if (element instanceof IStackFrame) {
                        object = DebugViewLabelDecorator.this.fCurrentStackFrameLock;
                        synchronized (object) {
                            DebugViewLabelDecorator.this.fCurrentStackFrame = (IStackFrame)element;
                        }
                        IThread thread = DebugViewLabelDecorator.this.fCurrentStackFrame.getThread();
                        Set set = DebugViewLabelDecorator.this.resumedThreads;
                        synchronized (set) {
                            if (!thread.isTerminated() && !thread.isSuspended()) {
                                DebugViewLabelDecorator.this.resumedThreads.add(thread);
                                continue;
                            }
                        }
                    }
                    DebugViewLabelDecorator.this.fLabelProvider.textComputed(element, this.fJobPresentation.getText(element));
                    object = DebugViewLabelDecorator.this.fCurrentStackFrameLock;
                    synchronized (object) {
                        DebugViewLabelDecorator.this.fCurrentStackFrame = null;
                    }
                    computedElements.add(element);
                }
                DebugViewLabelDecorator.this.labelsComputed(computedElements.toArray());
                monitor.worked(computedElements.size());
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof LabelJob && this.fJobPresentation == ((LabelJob)rule).fJobPresentation;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof LabelJob && this.fJobPresentation == ((LabelJob)rule).fJobPresentation;
        }
    }
}

