/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.help.ui.internal.search;
import org.eclipse.help.internal.search.*;
import org.eclipse.jface.viewers.*;
/**
 * Sorts results of help sarch in search view by title.
 */
public class SorterByTitle extends ViewerSorter {
	/**
	 * @see org.eclipse.jface.viewers.ViewerSorter#compare(org.eclipse.jface.viewers.Viewer,java.lang.Object,java.lang.Object)
	 */
	public int compare(Viewer viewer, Object e1, Object e2) {
		try {
			String title1 = ((SearchHit) e1).getLabel();
			String title2 = ((SearchHit) e2).getLabel();
			return super.getCollator().compare(title1, title2);
		} catch (Exception e) {
		}
		return super.compare(viewer, e1, e2);
	}
}