/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.StringUtils;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class LogContent
implements HttpContent {
    private final HttpContent httpContent;
    private final String contentType;
    private final String contentEncoding;
    private final long contentLength;
    private final int contentLoggingLimit;

    LogContent(HttpContent httpContent, String contentType, String contentEncoding, long contentLength, int contentLoggingLimit) {
        this.httpContent = httpContent;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.contentEncoding = contentEncoding;
        Preconditions.checkArgument(contentLoggingLimit >= 0, "The content logging limit must be non-negative.");
        this.contentLoggingLimit = contentLoggingLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        ByteArrayOutputStream debugStream = new ByteArrayOutputStream();
        try {
            this.httpContent.writeTo(debugStream);
            byte[] debugContent = debugStream.toByteArray();
            if (debugContent.length <= this.contentLoggingLimit) {
                HttpTransport.LOGGER.config(StringUtils.newStringUtf8(debugContent));
            }
            out.write(debugContent);
        }
        finally {
            debugStream.close();
        }
        out.flush();
    }

    @Override
    public String getEncoding() {
        return this.contentEncoding;
    }

    @Override
    public long getLength() {
        return this.contentLength;
    }

    @Override
    public String getType() {
        return this.contentType;
    }

    int getContentLoggingLimit() {
        return this.contentLoggingLimit;
    }

    public static boolean isTextBasedContentType(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/"));
    }

    @Override
    public boolean retrySupported() {
        return this.httpContent.retrySupported();
    }
}

