/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.util.Data;
import com.google.api.client.util.escape.CharEscapers;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class UriTemplate {
    static final Map<Character, CompositeOutput> COMPOSITE_PREFIXES = new HashMap<Character, CompositeOutput>();
    private static final String COMPOSITE_NON_EXPLODE_JOINER = ",";

    static CompositeOutput getCompositeOutput(String propertyName) {
        CompositeOutput compositeOutput = COMPOSITE_PREFIXES.get(Character.valueOf(propertyName.charAt(0)));
        return compositeOutput == null ? CompositeOutput.SIMPLE : compositeOutput;
    }

    private static Map<String, Object> getMap(Object obj) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : Data.mapOf(obj).entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            map.put(entry.getKey(), value);
        }
        return map;
    }

    public static String expand(String baseUrl, String uriTemplate, Object parameters, boolean addUnusedParamsAsQueryParams) {
        String pathUri;
        if (uriTemplate.startsWith("/")) {
            GenericUrl url = new GenericUrl(baseUrl);
            url.setRawPath(null);
            pathUri = url.build() + uriTemplate;
        } else {
            pathUri = uriTemplate.startsWith("http://") || uriTemplate.startsWith("https://") ? uriTemplate : baseUrl + uriTemplate;
        }
        return UriTemplate.expand(pathUri, parameters, addUnusedParamsAsQueryParams);
    }

    public static String expand(String pathUri, Object parameters, boolean addUnusedParamsAsQueryParams) {
        Map<String, Object> variableMap = UriTemplate.getMap(parameters);
        StringBuilder pathBuf = new StringBuilder();
        int cur = 0;
        int length = pathUri.length();
        while (cur < length) {
            String varName;
            Object value;
            int next = pathUri.indexOf(123, cur);
            if (next == -1) {
                if (cur == 0 && !addUnusedParamsAsQueryParams) {
                    return pathUri;
                }
                pathBuf.append(pathUri.substring(cur));
                break;
            }
            pathBuf.append(pathUri.substring(cur, next));
            int close = pathUri.indexOf(125, next + 2);
            String template = pathUri.substring(next + 1, close);
            cur = close + 1;
            boolean containsExplodeModifier = template.endsWith("*");
            CompositeOutput compositeOutput = UriTemplate.getCompositeOutput(template);
            int varNameStartIndex = compositeOutput.getVarNameStartIndex();
            int varNameEndIndex = template.length();
            if (containsExplodeModifier) {
                --varNameEndIndex;
            }
            if ((value = variableMap.remove(varName = template.substring(varNameStartIndex, varNameEndIndex))) instanceof Iterator) {
                Iterator iterator = (Iterator)value;
                value = UriTemplate.getListPropertyValue(varName, iterator, containsExplodeModifier, compositeOutput);
            } else if (!Data.isValueOfPrimitiveType(value)) {
                Map<String, Object> map = UriTemplate.getMap(value);
                value = UriTemplate.getMapPropertyValue(varName, map, containsExplodeModifier, compositeOutput);
            } else if (value != null) {
                value = CharEscapers.escapeUriPath(value.toString());
            }
            if (value == null) continue;
            pathBuf.append(value);
        }
        if (addUnusedParamsAsQueryParams) {
            GenericUrl.addQueryParams(variableMap.entrySet(), pathBuf);
        }
        return pathBuf.toString();
    }

    private static String getListPropertyValue(String varName, Iterator<?> iterator, boolean containsExplodeModifier, CompositeOutput compositeOutput) {
        String joiner;
        if (!iterator.hasNext()) {
            return null;
        }
        StringBuilder retBuf = new StringBuilder();
        retBuf.append(compositeOutput.getOutputPrefix());
        if (containsExplodeModifier) {
            joiner = compositeOutput.getExplodeJoiner();
        } else {
            joiner = COMPOSITE_NON_EXPLODE_JOINER;
            if (compositeOutput.requiresVarAssignment()) {
                retBuf.append(CharEscapers.escapeUriPath(varName));
                retBuf.append("=");
            }
        }
        while (iterator.hasNext()) {
            retBuf.append(compositeOutput.getEncodedValue(iterator.next().toString()));
            if (!iterator.hasNext()) continue;
            retBuf.append(joiner);
        }
        return retBuf.toString();
    }

    private static String getMapPropertyValue(String varName, Map<String, Object> map, boolean containsExplodeModifier, CompositeOutput compositeOutput) {
        String mapElementsJoiner;
        String joiner;
        if (map.isEmpty()) {
            return null;
        }
        StringBuilder retBuf = new StringBuilder();
        retBuf.append(compositeOutput.getOutputPrefix());
        if (containsExplodeModifier) {
            joiner = compositeOutput.getExplodeJoiner();
            mapElementsJoiner = "=";
        } else {
            joiner = COMPOSITE_NON_EXPLODE_JOINER;
            mapElementsJoiner = COMPOSITE_NON_EXPLODE_JOINER;
            if (compositeOutput.requiresVarAssignment()) {
                retBuf.append(CharEscapers.escapeUriPath(varName));
                retBuf.append("=");
            }
        }
        Iterator<Map.Entry<String, Object>> mapIterator = map.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry<String, Object> entry = mapIterator.next();
            String encodedKey = compositeOutput.getEncodedValue(entry.getKey());
            String encodedValue = compositeOutput.getEncodedValue(entry.getValue().toString());
            retBuf.append(encodedKey);
            retBuf.append(mapElementsJoiner);
            retBuf.append(encodedValue);
            if (!mapIterator.hasNext()) continue;
            retBuf.append(joiner);
        }
        return retBuf.toString();
    }

    private static enum CompositeOutput {
        PLUS(Character.valueOf('+'), "", ",", false, true),
        HASH(Character.valueOf('#'), "#", ",", false, true),
        DOT(Character.valueOf('.'), ".", ".", false, false),
        FORWARD_SLASH(Character.valueOf('/'), "/", "/", false, false),
        SEMI_COLON(Character.valueOf(';'), ";", ";", true, false),
        QUERY(Character.valueOf('?'), "?", "&", true, false),
        AMP(Character.valueOf('&'), "&", "&", true, false),
        SIMPLE(null, "", ",", false, false);

        private final Character propertyPrefix;
        private final String outputPrefix;
        private final String explodeJoiner;
        private final boolean requiresVarAssignment;
        private final boolean reservedExpansion;

        private CompositeOutput(Character propertyPrefix, String outputPrefix, String explodeJoiner, boolean requiresVarAssignment, boolean reservedExpansion) {
            this.propertyPrefix = propertyPrefix;
            this.outputPrefix = Preconditions.checkNotNull(outputPrefix);
            this.explodeJoiner = Preconditions.checkNotNull(explodeJoiner);
            this.requiresVarAssignment = requiresVarAssignment;
            this.reservedExpansion = reservedExpansion;
            if (propertyPrefix != null) {
                COMPOSITE_PREFIXES.put(propertyPrefix, this);
            }
        }

        String getOutputPrefix() {
            return this.outputPrefix;
        }

        String getExplodeJoiner() {
            return this.explodeJoiner;
        }

        boolean requiresVarAssignment() {
            return this.requiresVarAssignment;
        }

        int getVarNameStartIndex() {
            return this.propertyPrefix == null ? 0 : 1;
        }

        String getEncodedValue(String value) {
            String encodedValue = this.reservedExpansion ? CharEscapers.escapeUriPath(value) : CharEscapers.escapeUri(value);
            return encodedValue;
        }
    }
}

