/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Log2;
import com.google.appengine.repackaged.com.google.common.logging.Log2FileHandler;
import com.google.appengine.repackaged.com.google.common.logging.Log2Formatter;
import com.google.appengine.repackaged.com.google.common.logging.LogContext;
import java.text.DateFormat;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Deprecated
@GoogleInternal
public final class Log2Logger
implements com.google.appengine.repackaged.com.google.common.logging.Logger {
    private int threshold;
    private static final Logger log = Logger.getLogger("com.google.appengine.repackaged.com.google.common.base.Log2");
    private static boolean selfInstalledHandler = false;
    private static boolean useRootHandler = false;

    Log2Logger() {
        Handler[] handlers = log.getHandlers();
        if (handlers.length == 0 && !useRootHandler) {
            ConsoleHandler ch = new ConsoleHandler();
            ch.setFormatter(new Log2Formatter());
            this.addHandler(ch);
            this.setThreshold(0);
        }
    }

    Log2Logger(String filePath, String linkName, @Nullable String extension, DateFormat recordTsFormat, DateFormat fileNameTsFormat, long rotateSize) {
        Handler[] handlers = log.getHandlers();
        if ((handlers.length == 0 || selfInstalledHandler) && !useRootHandler) {
            if (selfInstalledHandler) {
                log.removeHandler(handlers[0]);
            }
            Log2FileHandler h = new Log2FileHandler(filePath, linkName, extension, recordTsFormat, fileNameTsFormat, rotateSize);
            this.addHandler((Handler)h);
            this.setThreshold(0);
        }
    }

    public static void useRootHandler() {
        if (!useRootHandler) {
            Handler[] handlers;
            for (Handler handler : handlers = log.getHandlers()) {
                log.removeHandler(handler);
            }
            log.setUseParentHandlers(true);
            useRootHandler = true;
        }
    }

    @Override
    public void setThreshold(int level) {
        Level javaLevel;
        if (level == 2) {
            javaLevel = Level.WARNING;
        } else if (level == 1) {
            javaLevel = Level.INFO;
        } else if (level == 0) {
            javaLevel = Level.FINEST;
        } else {
            throw new RuntimeException("Invalid level passed to Log2Logger.setThreshold ");
        }
        log.setLevel(javaLevel);
        if (selfInstalledHandler) {
            Handler[] handlers = log.getHandlers();
            handlers[0].setLevel(javaLevel);
        }
        this.threshold = level;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void logDebug(String msg) {
        if (log.isLoggable(Level.FINE)) {
            this.logAfterSettingCaller(Level.FINE, msg);
        }
    }

    @Override
    public void logEvent(String msg) {
        if (log.isLoggable(Level.INFO)) {
            LogRecord lr = new LogRecord(Level.INFO, msg);
            this.doCallerInference(lr);
            log.log(lr);
        }
    }

    @Override
    public void logTimedEvent(String msg, long start, long end) {
        log.info(end - start + " ms.: " + msg);
    }

    @Override
    public void setErrorEmail(String emailAddr) {
    }

    @Override
    public void logException(Throwable t) {
        this.logException(t, "");
    }

    @Override
    public void logException(Throwable t, String msg) {
        if (log.isLoggable(Level.WARNING)) {
            this.logAfterSettingCaller(Level.WARNING, msg, t);
        }
    }

    @Override
    public void logSevereException(Throwable t) {
        this.logSevereException(t, "");
    }

    @Override
    public void logSevereException(Throwable t, String msg) {
        if (log.isLoggable(Level.SEVERE)) {
            this.logAfterSettingCaller(Level.SEVERE, msg, t);
        }
    }

    @Override
    public void logError(String msg) {
        this.logAfterSettingCaller(Level.WARNING, msg + "\n" + Log2.getExceptionTrace(new LoggedError()));
    }

    @Override
    public String getThreadTag() {
        return LogContext.getThreadTag();
    }

    @Override
    public void setThreadTag(String s) {
        LogContext.setThreadTag(s);
    }

    @Override
    public void close() {
        Handler[] handlers;
        for (Handler handler : handlers = log.getHandlers()) {
            handler.close();
        }
    }

    private void addHandler(Handler handler) {
        log.addHandler(handler);
        boolean useParentHandlers = false;
        String val = LogManager.getLogManager().getProperty(log.getName() + ".useParentHandlers");
        String string = val = val == null ? "" : val.toLowerCase();
        if (val.equals("true") || val.equals("1")) {
            useParentHandlers = true;
        }
        log.setUseParentHandlers(useParentHandlers);
        selfInstalledHandler = true;
    }

    private void doCallerInference(LogRecord record) {
        String loggerClassName = Log2.class.getName();
        StackTraceElement[] callStack = new Throwable().getStackTrace();
        int lastLoggerCallIndex = Integer.MAX_VALUE;
        for (int i = 0; i < callStack.length; ++i) {
            String className = callStack[i].getClassName();
            if (className.equals(loggerClassName)) {
                lastLoggerCallIndex = i;
                continue;
            }
            if (lastLoggerCallIndex == Integer.MAX_VALUE) continue;
            record.setSourceClassName(callStack[i].getClassName());
            record.setSourceMethodName(callStack[i].getMethodName());
            break;
        }
    }

    private void logAfterSettingCaller(Level level, String msg, Throwable t) {
        LogRecord lr = new LogRecord(level, msg);
        if (t != null) {
            lr.setThrown(t);
        }
        this.doCallerInference(lr);
        log.log(lr);
    }

    private void logAfterSettingCaller(Level level, String msg) {
        this.logAfterSettingCaller(level, msg, null);
    }

    private static class LoggedError
    extends Throwable {
        private static final long serialVersionUID = 1L;

        private LoggedError() {
        }
    }
}

