/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor_pool;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import java.util.HashMap;

public final class DescriptorPool {
    private final HashMap<String, Descriptors.FileDescriptor> fileNameToFileDescriptor;
    private final HashMap<String, Descriptors.Descriptor> typeNameToDescriptor;

    private DescriptorPool(HashMap<String, Descriptors.Descriptor> typeNameToDescriptor, HashMap<String, Descriptors.FileDescriptor> fileNameToFileDescriptor) {
        this.typeNameToDescriptor = Maps.newHashMap(typeNameToDescriptor);
        this.fileNameToFileDescriptor = Maps.newHashMap(fileNameToFileDescriptor);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Descriptors.Descriptor getDescriptorForTypeName(String typeName) {
        return this.typeNameToDescriptor.get(typeName);
    }

    public Descriptors.FileDescriptor getFileDescriptorForFileName(String fileName) {
        return this.fileNameToFileDescriptor.get(fileName);
    }

    public static final class Builder {
        private final HashMap<String, Descriptors.Descriptor> typeNameToDescriptor = Maps.newHashMap();
        private final HashMap<String, Descriptors.FileDescriptor> fileNameToFileDescriptor = Maps.newHashMap();

        private Builder() {
        }

        public void populateFromMessageType(Message message) {
            Descriptors.Descriptor desc = message.getDescriptorForType();
            this.addFile(desc.getFile());
        }

        public DescriptorPool build() {
            return new DescriptorPool(this.typeNameToDescriptor, this.fileNameToFileDescriptor);
        }

        private void addFile(Descriptors.FileDescriptor file) {
            if (this.fileNameToFileDescriptor.put(file.getName(), file) != null) {
                return;
            }
            for (Descriptors.FileDescriptor dependency : file.getDependencies()) {
                this.addFile(dependency);
            }
            for (Descriptors.Descriptor type : file.getMessageTypes()) {
                this.addMessageType(type);
            }
        }

        private void addMessageType(Descriptors.Descriptor type) {
            if (this.typeNameToDescriptor.put(type.getFullName(), type) != null) {
                return;
            }
            for (Descriptors.Descriptor nested : type.getNestedTypes()) {
                this.addMessageType(nested);
            }
        }
    }
}

