/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import com.google.cloud.sql.jdbc.internal.SqlClientFactory;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.googleapi.GoogleApiClientFactory;
import com.google.cloud.sql.jdbc.internal.googleapi.RefreshTokenAccessTokenRefresher;
import com.google.cloud.sql.jdbc.internal.googleapi.RpcGoogleApi;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class Driver
extends com.google.cloud.sql.jdbc.Driver {
    private static final Logger logger = Logger.getLogger(Driver.class.getName());
    private static final String PREFS_PACKAGE = "/com/google/cloud/sqlservice/oauth2";
    private static final Preferences DEFAULT_PREFS = Preferences.userRoot().node("/com/google/cloud/sqlservice/oauth2");
    private final Preferences prefs;

    private static void registerDriver() {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Could not register driver automatically.", e);
        }
    }

    public Driver() {
        this(new GoogleApiClientFactory(new RefreshTokenAccessTokenRefresher(), new NetHttpTransport(), RpcGoogleApi.TokenCachePolicy.CACHE_ALL, DEFAULT_PREFS), DEFAULT_PREFS);
    }

    Driver(SqlClientFactory clientFactory, Preferences prefs) {
        super(clientFactory);
        this.prefs = prefs;
    }

    @Override
    public Connection connect(String urlString, Properties info) throws SQLException {
        String accessToken;
        Url url;
        String refreshToken;
        if (!this.acceptsURL(urlString)) {
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        if ((refreshToken = (url = Url.create(urlString, info)).getOAuth2RefreshToken()) == null) {
            refreshToken = this.prefs.get(url.getOAuth2RefreshTokenKey(), null);
        }
        if (!Util.isEmpty(refreshToken)) {
            info.put(ConnectionProperty.OAUTH2_REFRESH_TOKEN.key(), refreshToken);
        }
        if ((accessToken = url.getOAuth2AccessToken()) == null) {
            accessToken = this.prefs.get(url.getOAuth2AccessTokenKey(), null);
        }
        if (!Util.isEmpty(accessToken)) {
            logger.fine("Using cached Access token.");
            info.put(ConnectionProperty.OAUTH2_ACCESS_TOKEN.key(), accessToken);
        }
        Util.checkParameter(refreshToken != null || accessToken != null, "Unable to load OAuth2 refresh or access token. Please run the google_sql command line tool once to setup cached credentials. See: http://code.google.com/apis/sql/docs/commandline.html", new Object[0]);
        return this.connectImpl(urlString, info);
    }

    protected Connection connectImpl(String urlStr, Properties info) throws SQLException {
        return super.connect(urlStr, info);
    }

    static {
        Driver.registerDriver();
    }
}

