/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    private static boolean verbose;
    private static Logger logger;

    private Log() {
    }

    static void setVerbose(boolean verbose) {
        Log.verbose = verbose;
    }

    public static void vlog(String message, Object ... args) {
        if (verbose) {
            if (args.length == 0) {
                System.err.println(message);
            } else {
                System.err.println(MessageFormat.format(message, args));
            }
        }
        logger.log(Level.FINE, message, args);
    }

    public static void logException(Throwable t) {
        if (verbose) {
            if (t instanceof SQLException) {
                SQLException sqlEx = (SQLException)t;
                StringBuilder s = new StringBuilder();
                s.append("message=").append(sqlEx.getLocalizedMessage()).append(';');
                s.append("sqlstate=").append(sqlEx.getSQLState()).append(';');
                s.append("errorcode=").append(sqlEx.getErrorCode()).append(';');
                System.err.println(s.toString());
            }
            t.printStackTrace();
        } else {
            logger.log(Level.WARNING, t.getMessage(), t);
        }
    }

    static {
        logger = Logger.getLogger(Log.class.getName());
    }
}

