/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.CreationCostAnalysis;
import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.math.BigDecimal;
import java.util.Collection;

public class LocalDatastoreCostAnalysis {
    private static final BigDecimal ONE_MILLION = new BigDecimal(1000000);
    private static final BigDecimal DOLLARS_PER_WRITE = new BigDecimal(1).divide(ONE_MILLION);
    private static final BigDecimal PENNIES_PER_WRITE = DOLLARS_PER_WRITE.divide(new BigDecimal(100));
    private final LocalCompositeIndexManager indexManager;

    public LocalDatastoreCostAnalysis(LocalCompositeIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public CreationCostAnalysis getCreationCostAnalysis(Entity e) {
        int writeOps = this.getWriteOps(e);
        return new CreationCostAnalysis(writeOps, LocalDatastoreCostAnalysis.writesToPennies(writeOps));
    }

    static BigDecimal writesToPennies(int writes) {
        return PENNIES_PER_WRITE.multiply(new BigDecimal(writes));
    }

    int getWriteOps(Entity e) {
        int writes = 2 + this.calculateWritesForBuiltInIndices(e);
        for (OnestoreEntity.Index index : this.indexManager.getIndicesForKind(e.getKind())) {
            writes += this.calculateWritesForCompositeIndex(e, index);
        }
        return writes;
    }

    private int calculateWritesForBuiltInIndices(Entity e) {
        int writes = 0;
        for (String propName : e.getProperties().keySet()) {
            if (e.isUnindexedProperty(propName)) continue;
            Object val = e.getProperty(propName);
            int propertyValueCount = val instanceof Collection ? ((Collection)val).size() : 1;
            writes += 2 * propertyValueCount;
        }
        return writes;
    }

    private int calculateWritesForCompositeIndex(Entity e, OnestoreEntity.Index index) {
        int compositeIndexValueCount = 1;
        for (OnestoreEntity.Index.Property prop : index.propertys()) {
            if (!e.hasProperty(prop.getName()) || e.isUnindexedProperty(prop.getName())) {
                return 0;
            }
            Object val = e.getProperty(prop.getName());
            if (!(val instanceof Collection)) continue;
            compositeIndexValueCount *= ((Collection)val).size();
        }
        int ancestorCount = 1;
        if (index.isAncestor()) {
            for (Key key = e.getKey().getParent(); key != null; key = key.getParent()) {
                ++ancestorCount;
            }
        }
        return compositeIndexValueCount * ancestorCount;
    }
}

