/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.apphosting.api.ApiProxy;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedFileName {
    private String fileSystem;
    private String namePart;
    private Map<String, String> paramMap = new HashMap<String, String>(10);
    private static final String regex = "^/([^/]+)/([^\\?]+)(?:\\?)?(.*)$";
    private static final Pattern pattern = Pattern.compile("^/([^/]+)/([^\\?]+)(?:\\?)?(.*)$");

    public ParsedFileName(String decoratedName) {
        String[] paramArray;
        Matcher m = pattern.matcher(decoratedName);
        if (!m.matches()) {
            throw new ApiProxy.ApplicationException(5, decoratedName);
        }
        this.fileSystem = m.group(1);
        this.namePart = m.group(2);
        String params = m.group(3);
        for (String paramPair : paramArray = params.split("&")) {
            String[] pair = paramPair.split("=");
            if (2 != pair.length) continue;
            String key = pair[0];
            String valueEncoded = pair[1];
            String value = null;
            try {
                value = URLDecoder.decode(valueEncoded, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.paramMap.put(key, value);
        }
    }

    public String getParam(String param) {
        return this.paramMap.get(param);
    }

    public String getFileSystem() {
        return this.fileSystem;
    }

    public String getNamePart() {
        return this.namePart;
    }
}

