/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.taskqueue.dev.UrlFetchJob;
import com.google.apphosting.utils.config.QueueXml;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

class UrlFetchJobDetail
extends JobDetail {
    private static final String TASK_NAME_PROP = "taskName";
    private static final String QUEUE_NAME_PROP = "queueName";
    private static final String ADD_REQUEST_PROP = "addRequest";
    private static final String SERVER_URL = "serverUrl";
    private static final String RETRY_COUNT = "retryCount";
    private static final String RETRY_DELAY_MS = "retryDelayMs";
    private static final String CALLBACK = "callback";
    private static final String QUEUE_XML_ENTRY = "queueXmlEntry";
    private static final String RETRY_PARAMETERS = "retryParameters";
    private static final String FIRST_TRY_MS = "firstTryMs";
    private static final TaskQueuePb.TaskQueueRetryParameters DEFAULT_RETRY_PARAMETERS = new TaskQueuePb.TaskQueueRetryParameters();

    UrlFetchJobDetail(String taskName, String queueName, TaskQueuePb.TaskQueueAddRequest addRequest, String url, LocalTaskQueueCallback callback, QueueXml.Entry queueXmlEntry, TaskQueuePb.TaskQueueRetryParameters retryParameters) {
        super(taskName, queueName, UrlFetchJob.class);
        JobDataMap dataMap = this.getJobDataMap();
        dataMap.put(TASK_NAME_PROP, taskName);
        dataMap.put(QUEUE_NAME_PROP, queueName);
        dataMap.put((Object)ADD_REQUEST_PROP, addRequest);
        dataMap.put(SERVER_URL, url);
        dataMap.put((Object)CALLBACK, callback);
        dataMap.put(RETRY_COUNT, 0);
        dataMap.put((Object)QUEUE_XML_ENTRY, queueXmlEntry);
        if (retryParameters == null) {
            retryParameters = DEFAULT_RETRY_PARAMETERS;
        }
        dataMap.put((Object)RETRY_PARAMETERS, retryParameters);
        dataMap.put(FIRST_TRY_MS, 0L);
    }

    String getTaskName() {
        return (String)this.getJobDataMap().get(TASK_NAME_PROP);
    }

    String getQueueName() {
        return (String)this.getJobDataMap().get(QUEUE_NAME_PROP);
    }

    TaskQueuePb.TaskQueueAddRequest getAddRequest() {
        return (TaskQueuePb.TaskQueueAddRequest)this.getJobDataMap().get(ADD_REQUEST_PROP);
    }

    String getServerUrl() {
        return (String)this.getJobDataMap().get(SERVER_URL);
    }

    int getRetryCount() {
        return (Integer)this.getJobDataMap().get(RETRY_COUNT);
    }

    int getRetryDelayMs() {
        return (Integer)this.getJobDataMap().get(RETRY_DELAY_MS);
    }

    long getFirstTryMs() {
        return (Long)this.getJobDataMap().get(FIRST_TRY_MS);
    }

    QueueXml.Entry getQueueXmlEntry() {
        return (QueueXml.Entry)this.getJobDataMap().get(QUEUE_XML_ENTRY);
    }

    TaskQueuePb.TaskQueueRetryParameters getRetryParameters() {
        return (TaskQueuePb.TaskQueueRetryParameters)this.getJobDataMap().get(RETRY_PARAMETERS);
    }

    UrlFetchJobDetail retry(long firstTryMs) {
        UrlFetchJobDetail newJob = new UrlFetchJobDetail(this.getTaskName(), this.getQueueName(), this.getAddRequest(), this.getServerUrl(), this.getCallback(), this.getQueueXmlEntry(), this.getRetryParameters());
        JobDataMap newDataMap = newJob.getJobDataMap();
        newDataMap.put(RETRY_COUNT, this.getRetryCount());
        newDataMap.put(FIRST_TRY_MS, firstTryMs);
        newJob.incrementRetryDelayMs();
        return newJob;
    }

    int incrementRetryDelayMs() {
        int retryCount = this.getRetryCount() + 1;
        this.getJobDataMap().put(RETRY_COUNT, retryCount);
        TaskQueuePb.TaskQueueRetryParameters params = this.getRetryParameters();
        int exponent = Math.min(retryCount - 1, params.getMaxDoublings());
        int linearSteps = retryCount - exponent;
        int minBackoffMs = (int)(params.getMinBackoffSec() * 1000.0);
        int maxBackoffMs = (int)(params.getMaxBackoffSec() * 1000.0);
        int backoffMs = minBackoffMs;
        if (exponent > 0) {
            backoffMs = (int)((double)backoffMs * Math.pow(2.0, Math.min(1023, exponent)));
        }
        if (linearSteps > 1) {
            backoffMs *= linearSteps;
        }
        backoffMs = Math.min(maxBackoffMs, backoffMs);
        this.getJobDataMap().put(RETRY_DELAY_MS, backoffMs);
        return backoffMs;
    }

    LocalTaskQueueCallback getCallback() {
        return (LocalTaskQueueCallback)this.getJobDataMap().get(CALLBACK);
    }
}

