/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen.directio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mediautil.gen.directio.ByteCounter;
import mediautil.gen.directio.IterativeReader;

public class OutStreamToIterativeReader
extends OutputStream {
    private static byte UNINITIALISED = 0;
    private static byte OPEN = 1;
    private static byte CLOSED = (byte)2;
    private boolean isDetached;
    protected byte[] q;
    protected int qBegin;
    protected int qEnd;
    protected int qSize;
    private int minReadSize;
    private int readCushion;
    private IterativeReader reader;
    private static final int DEF_BUF_SIZE = 3072;
    private byte openFlag = UNINITIALISED;
    private byte[] oneByteArr = new byte[1];
    private ReaderInputStream readerStream;

    public OutStreamToIterativeReader(int bufSize, int minReadSize, int readCushion) {
        int minBufSize;
        if (minReadSize <= 0) {
            minReadSize = 1;
        }
        if (readCushion <= 0) {
            readCushion = 1;
        }
        if (bufSize < (minBufSize = minReadSize + readCushion + 512)) {
            bufSize = minBufSize;
        }
        this.q = new byte[bufSize];
        this.qBegin = 0;
        this.qEnd = 0;
        this.qSize = 0;
        this.minReadSize = minReadSize;
        this.readCushion = readCushion;
        this.isDetached = false;
    }

    public OutStreamToIterativeReader() {
        this(3072, 1024, 1024);
    }

    public InputStream getReaderInputStream() {
        if (this.readerStream == null) {
            this.readerStream = new ReaderInputStream();
        }
        if (this.reader != null && this.openFlag == UNINITIALISED) {
            this.openFlag = OPEN;
        }
        return this.readerStream;
    }

    public void setIterativeReader(IterativeReader iterativeReader) {
        if (iterativeReader == null) {
            throw new NullPointerException("Reader is null");
        }
        if (this.readerStream != null && this.openFlag == UNINITIALISED) {
            this.openFlag = OPEN;
        }
        this.reader = iterativeReader;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block9: {
            if (this.openFlag != OPEN) {
                throw new IOException("Stream is closed or IterativeReader not set yet");
            }
            int excessSkip = this.readerStream.writeBufRemain;
            if (excessSkip < 0) {
                off -= excessSkip;
                this.readerStream.writeBufRemain = excessSkip = (len += excessSkip) >= 0 ? 0 : len;
            }
            if (len > 0 && !this.isDetached) {
                int curSize = this.qSize + len;
                if (curSize > this.q.length) {
                    int readSize = curSize - this.readCushion;
                    this.readerStream.writeBuf = b;
                    this.readerStream.writeBufPos = off;
                    this.readerStream.writeBufRemain = len;
                    do {
                        if (this.reader.nextRead(readSize) == 0) continue;
                        this.readerStream.close();
                        break block9;
                    } while ((readSize = this.qSize + this.readerStream.writeBufRemain - this.readCushion) > this.minReadSize);
                    off = this.readerStream.writeBufPos;
                    len = this.readerStream.writeBufRemain;
                    this.readerStream.writeBufRemain = 0;
                }
                if (len > 0) {
                    int remain = this.q.length - this.qEnd;
                    if (remain > len) {
                        remain = len;
                    }
                    System.arraycopy(b, off, this.q, this.qEnd, remain);
                    off += remain;
                    this.qEnd += remain;
                    if (this.qEnd >= this.q.length) {
                        this.qEnd = 0;
                    }
                    if ((remain = len - remain) > 0) {
                        System.arraycopy(b, off, this.q, this.qEnd, remain);
                        this.qEnd += remain;
                    }
                    this.qSize += len;
                }
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByteArr[0] = (byte)(b & 0xFF);
        this.write(this.oneByteArr, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.openFlag = CLOSED;
        if (!this.isDetached) {
            int curSize;
            while ((curSize = this.qSize + this.readerStream.writeBufRemain) > 0) {
                if (this.reader.nextRead(curSize) == 0) continue;
                this.readerStream.close();
                break;
            }
        }
    }

    public boolean isReaderDetached() {
        return this.isDetached;
    }

    private class ReaderInputStream
    extends InputStream
    implements ByteCounter {
        private byte[] oneByteArr = new byte[1];
        public byte[] writeBuf;
        public int writeBufPos;
        public int writeBufRemain = 0;
        private int[] counterArr;
        private boolean upMode;
        private long totalBytes = 0L;

        private ReaderInputStream() {
        }

        @Override
        public void setCounter(int[] counterArr, boolean upMode) {
            int i = counterArr[0];
            this.counterArr = counterArr;
            this.upMode = upMode;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setRequestBuf(byte[] b, int off, int len) {
            this.writeBuf = b;
            this.writeBufPos = off;
            this.writeBufRemain = len;
        }

        private int readOrSkip(byte[] b, int off, int len) throws IOException {
            int retVal;
            int remain;
            if (OutStreamToIterativeReader.this.openFlag == UNINITIALISED || OutStreamToIterativeReader.this.isDetached) {
                throw new IOException("IterativeReader not set or has been detached");
            }
            int qReadSize = OutStreamToIterativeReader.this.qSize;
            if (qReadSize > len) {
                qReadSize = len;
            }
            if (qReadSize > 0) {
                remain = OutStreamToIterativeReader.this.q.length - OutStreamToIterativeReader.this.qBegin;
                if (remain > qReadSize) {
                    remain = qReadSize;
                }
                if (b != null) {
                    System.arraycopy(OutStreamToIterativeReader.this.q, OutStreamToIterativeReader.this.qBegin, b, off, remain);
                    off += remain;
                }
                OutStreamToIterativeReader.this.qBegin += remain;
                if (OutStreamToIterativeReader.this.qBegin == OutStreamToIterativeReader.this.q.length) {
                    OutStreamToIterativeReader.this.qBegin = 0;
                }
                if ((remain = qReadSize - remain) > 0) {
                    if (b != null) {
                        System.arraycopy(OutStreamToIterativeReader.this.q, OutStreamToIterativeReader.this.qBegin, b, off, remain);
                        off += remain;
                    }
                    OutStreamToIterativeReader.this.qBegin += remain;
                }
                OutStreamToIterativeReader.this.qSize -= qReadSize;
                if (OutStreamToIterativeReader.this.qSize == 0) {
                    OutStreamToIterativeReader.this.qBegin = 0;
                    OutStreamToIterativeReader.this.qEnd = 0;
                }
            }
            if ((remain = len - qReadSize) > 0) {
                if (remain > this.writeBufRemain) {
                    if (OutStreamToIterativeReader.this.openFlag == CLOSED) {
                        remain = this.writeBufRemain > 0 ? this.writeBufRemain : 0;
                    } else if (b != null) {
                        throw new IOException("Iterative Reader attempting to read beyond buffer end. Need larger read cushion?");
                    }
                }
                if (b != null) {
                    System.arraycopy(this.writeBuf, this.writeBufPos, b, off, remain);
                }
                this.writeBufPos += remain;
                this.writeBufRemain -= remain;
            }
            if ((retVal = qReadSize + remain) > 0) {
                this.totalBytes += (long)retVal;
                if (this.counterArr != null) {
                    this.counterArr[0] = this.upMode ? this.counterArr[0] + retVal : this.counterArr[0] - retVal;
                }
            }
            return retVal;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 0) {
                throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + len);
            }
            byte b1 = b[off];
            byte b2 = b[off + len - 1];
            int retVal = this.readOrSkip(b, off, len);
            if (retVal == 0) {
                retVal = -1;
            }
            return retVal;
        }

        @Override
        public long skip(long n) throws IOException {
            long retVal = 0L;
            if (n < 0L) {
                n = 0L;
            }
            retVal = this.readOrSkip(null, 0, (int)n);
            return retVal;
        }

        @Override
        public int read() throws IOException {
            int retVal = -1;
            if (this.read(this.oneByteArr) == 1) {
                retVal = this.oneByteArr[0] & 0xFF;
            }
            return retVal;
        }

        @Override
        public int available() throws IOException {
            int retVal = OutStreamToIterativeReader.this.qSize;
            if (retVal < 1 && OutStreamToIterativeReader.this.openFlag != CLOSED) {
                retVal = 1;
            }
            return retVal;
        }

        @Override
        public void close() throws IOException {
            OutStreamToIterativeReader.this.isDetached = true;
            OutStreamToIterativeReader.this.q = null;
        }
    }
}

