/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.beanutils.converters;

import com.google.appengine.repackaged.org.apache.commons.beanutils.ConversionException;
import com.google.appengine.repackaged.org.apache.commons.beanutils.Converter;

public final class FloatConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public FloatConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public FloatConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue());
        }
        try {
            return new Float(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

