/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.util.List;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.StringUtils;

public class CreatorExpression
extends Expression {
    SymbolTable symtbl;
    List tuples;
    List arguments;

    public CreatorExpression(SymbolTable symtbl, List tuples, List args) {
        this.symtbl = symtbl;
        this.tuples = tuples;
        this.arguments = args;
    }

    public String getId() {
        StringBuffer id = new StringBuffer();
        for (int i = 0; i < this.tuples.size(); ++i) {
            if (id.length() > 0) {
                id.append('.');
            }
            id.append((String)this.tuples.get(i));
        }
        return id.toString();
    }

    public List getArguments() {
        return this.arguments;
    }

    public List getTuples() {
        return this.tuples;
    }

    public Symbol bind() {
        if (this.symtbl.hasSymbol(this.getId())) {
            this.symbol = this.symtbl.getSymbol(this.getId());
        } else {
            try {
                String className = this.getId();
                Class cls = this.symtbl.getSymbolResolver().resolveClass(className);
                this.symbol = new PropertySymbol(this.getId(), cls);
            }
            catch (ClassNotResolvedException cnre) {
                throw new NucleusUserException("CreatorExpression defined with class of " + this.getId() + " yet this class is not found");
            }
        }
        return this.symbol;
    }

    public String toString() {
        return "CreatorExpression{" + this.getId() + "(" + StringUtils.collectionToString(this.arguments) + ")}";
    }
}

