/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.StaticFileUtils;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebXml;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.resource.Resource;
import org.mortbay.util.URIUtil;

public class LocalResourceFileServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(LocalResourceFileServlet.class.getName());
    private StaticFileUtils staticFileUtils;
    private Resource resourceBase;
    private String[] welcomeFiles;
    private String resourceRoot;

    public void init() throws ServletException {
        ContextHandler.SContext context = (ContextHandler.SContext)this.getServletContext();
        this.staticFileUtils = new StaticFileUtils(context);
        this.welcomeFiles = context.getContextHandler().getWelcomeFiles();
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        this.resourceRoot = appEngineWebXml.getPublicRoot();
        try {
            this.resourceBase = Resource.newResource(context.getResource("/" + this.resourceRoot));
        }
        catch (MalformedURLException ex) {
            logger.log(Level.WARNING, "Could not initialize:", ex);
            throw new ServletException((Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not initialize:", ex);
            throw new ServletException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInContext;
        String pathInfo;
        String servletPath;
        Boolean included;
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        WebXml webXml = (WebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.webXml");
        Boolean forwarded = (Boolean)request.getAttribute("org.mortbay.jetty.forwarded");
        if (forwarded == null) {
            forwarded = Boolean.FALSE;
        }
        if ((included = (Boolean)request.getAttribute("org.mortbay.jetty.included")) != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if (this.maybeServeWelcomeFile(pathInContext = URIUtil.addPaths(servletPath, pathInfo), included, request, response)) {
            return;
        }
        Resource resource = null;
        try {
            resource = this.getResource(pathInContext);
            if (resource != null && resource.isDirectory()) {
                if (included.booleanValue() || this.staticFileUtils.passConditionalHeaders(request, response, resource)) {
                    response.sendError(403);
                }
            } else if (resource == null || !resource.exists()) {
                logger.warning("No file found for: " + pathInContext);
                response.sendError(404);
            } else {
                boolean isStatic = appEngineWebXml.includesStatic(this.resourceRoot + pathInContext);
                boolean isResource = appEngineWebXml.includesResource(this.resourceRoot + pathInContext);
                boolean usesRuntime = webXml.matches(pathInContext);
                Boolean isWelcomeFile = (Boolean)request.getAttribute("com.google.appengine.tools.development.isWelcomeFile");
                if (isWelcomeFile == null) {
                    isWelcomeFile = false;
                }
                if (!(isStatic || usesRuntime || included.booleanValue() || forwarded.booleanValue())) {
                    logger.warning("Can not serve " + pathInContext + " directly.  " + "You need to include it in <static-files> in your " + "appengine-web.xml.");
                    response.sendError(404);
                    return;
                }
                if (!isResource && !isWelcomeFile.booleanValue() && (included.booleanValue() || forwarded.booleanValue())) {
                    logger.warning("Could not serve " + pathInContext + " from a forward or " + "include.  You need to include it in <resource-files> in " + "your appengine-web.xml.");
                    response.sendError(404);
                    return;
                }
                if (included.booleanValue() || this.staticFileUtils.passConditionalHeaders(request, response, resource)) {
                    this.staticFileUtils.sendData(request, response, included, resource);
                }
            }
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private Resource getResource(String pathInContext) {
        try {
            if (this.resourceBase != null) {
                return this.resourceBase.addPath(pathInContext);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not find: " + pathInContext, ex);
        }
        return null;
    }

    private boolean maybeServeWelcomeFile(String path, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.welcomeFiles == null) {
            return false;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        ContextHandler.SContext context = (ContextHandler.SContext)this.getServletContext();
        ServletHandler handler = ((Context)context.getContextHandler()).getServletHandler();
        PathMap.Entry defaultEntry = handler.getHolderEntry("/");
        PathMap.Entry jspEntry = handler.getHolderEntry("/foo.jsp");
        for (String welcomeName : this.welcomeFiles) {
            RequestDispatcher namedDispatcher;
            String welcomePath = path + welcomeName;
            String relativePath = welcomePath.substring(1);
            PathMap.Entry entry = handler.getHolderEntry(welcomePath);
            if (entry != defaultEntry && entry != jspEntry) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(path + welcomeName);
                return this.staticFileUtils.serveWelcomeFileAsForward(dispatcher, included, request, response);
            }
            Resource welcomeFile = this.getResource(path + welcomeName);
            if (welcomeFile != null && welcomeFile.exists()) {
                RequestDispatcher dispatcher;
                if (entry != defaultEntry) {
                    dispatcher = request.getRequestDispatcher(path + welcomeName);
                    return this.staticFileUtils.serveWelcomeFileAsForward(dispatcher, included, request, response);
                }
                if (appEngineWebXml.includesResource(relativePath)) {
                    dispatcher = request.getRequestDispatcher(path + welcomeName);
                    return this.staticFileUtils.serveWelcomeFileAsForward(dispatcher, included, request, response);
                }
            }
            if ((namedDispatcher = context.getNamedDispatcher(welcomeName)) == null) continue;
            return this.staticFileUtils.serveWelcomeFileAsForward(namedDispatcher, included, request, response);
        }
        return false;
    }
}

