/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.security.urlfetch;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Join;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class URLFetchServiceStreamHandler
extends URLStreamHandler {
    @Override
    protected HttpURLConnection openConnection(URL u) throws IOException {
        return new Connection(u);
    }

    @Override
    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        if (null == p) {
            throw new IllegalArgumentException("p may not be null");
        }
        if (Proxy.NO_PROXY == p) {
            return new Connection(u);
        }
        throw new UnsupportedOperationException("Google App Engine does not support the use of proxies.");
    }

    @Override
    protected synchronized InetAddress getHostAddress(URL u) {
        return null;
    }

    static String trim(String s) {
        if (s == null) {
            return null;
        }
        int notWhitespaceChar = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            notWhitespaceChar = i;
            break;
        }
        if (notWhitespaceChar != 0) {
            s = s.substring(notWhitespaceChar);
        }
        return s.trim();
    }

    static class Connection
    extends HttpURLConnection {
        private final URLFetchService service = URLFetchServiceFactory.getURLFetchService();
        private HTTPResponse response;
        private LinkedHashMap<String, List<String>> responseFields;
        private BufferingOutputStream outputStream;
        private InputStream inputStream;
        private LinkedHashMap<String, List<String>> requestProperties = new LinkedHashMap();

        public Connection(URL url) {
            super(url);
            this.setConnectTimeout(5000);
            this.setReadTimeout(1);
        }

        @Override
        public void disconnect() {
            this.connected = false;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void setChunkedStreamingMode(int chunklen) {
            super.setChunkedStreamingMode(chunklen);
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            method = method.toUpperCase();
            try {
                HTTPMethod.valueOf((String)method);
            }
            catch (IllegalArgumentException e) {
                throw new ProtocolException(method + " is not one of the supported http methods: " + Arrays.asList(HTTPMethod.values()));
            }
            super.setRequestMethod(method);
        }

        @Override
        public int getResponseCode() throws IOException {
            this.getInputStream();
            return this.responseCode;
        }

        @Override
        public String getResponseMessage() throws IOException {
            return "OK";
        }

        @Override
        public InputStream getErrorStream() {
            if (this.connected && this.responseCode >= 400) {
                return this.inputStream;
            }
            return null;
        }

        @Override
        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            this.connected = true;
        }

        @Override
        public String getHeaderField(String name) {
            List fieldValues = (List)((LinkedHashMap)this.getHeaderFields()).get(name.toLowerCase());
            if (fieldValues == null) {
                return null;
            }
            return (String)fieldValues.get(fieldValues.size() - 1);
        }

        public LinkedHashMap<String, List<String>> getHeaderFields() {
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to complete the HTTP request", e);
            }
            return this.responseFields;
        }

        @Override
        public void setRequestProperty(String key, String value) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.requestProperties.put(key, values);
            super.setRequestProperty(key, value);
        }

        @Override
        public void addRequestProperty(String key, String value) {
            List<String> values = this.requestProperties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.requestProperties.put(key, values);
            }
            values.add(value);
            super.addRequestProperty(key, value);
        }

        @Override
        public String getHeaderFieldKey(int n) {
            Map.Entry<String, List<String>> entry = this.getNthEntry(n);
            if (entry != null) {
                return entry.getKey();
            }
            return null;
        }

        @Override
        public String getHeaderField(int n) {
            List<String> values;
            Map.Entry<String, List<String>> entry = this.getNthEntry(n);
            if (entry != null && (values = entry.getValue()) != null) {
                return Join.join(",", values);
            }
            return null;
        }

        @Override
        public Permission getPermission() throws IOException {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (!this.getDoInput()) {
                String msg = "Input was not set on this URLConnection. Use \"setDoInput(true)\"";
                throw new IOException(msg);
            }
            this.fetchResponse();
            byte[] content = this.response.getContent();
            if (content == null) {
                content = new byte[]{};
            }
            this.inputStream = new ByteArrayInputStream(content);
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.outputStream != null) {
                return this.outputStream;
            }
            if (!this.getDoOutput()) {
                String msg = "Output was not set on this URLConnection. Use \"setDoOutput(true)\"";
                throw new IOException(msg);
            }
            if (this.method.equalsIgnoreCase(HTTPMethod.GET.name())) {
                this.method = HTTPMethod.POST.name();
            }
            this.connect();
            this.outputStream = new BufferingOutputStream();
            return this.outputStream;
        }

        private Map.Entry<String, List<String>> getNthEntry(int n) {
            Iterator iterator = ((LinkedHashMap)this.getHeaderFields()).entrySet().iterator();
            Map.Entry last = null;
            for (int i = 0; i <= n; ++i) {
                if (!iterator.hasNext()) {
                    return null;
                }
                last = iterator.next();
            }
            return last;
        }

        private HTTPResponse fetchResponse() throws IOException {
            ArrayList<String> values;
            if (this.response != null) {
                return this.response;
            }
            this.connect();
            String method = this.getRequestMethod();
            HTTPMethod httpMethod = HTTPMethod.valueOf((String)method);
            HTTPRequest request = new HTTPRequest(this.url, httpMethod);
            if (this.getInstanceFollowRedirects()) {
                request.getFetchOptions().followRedirects();
            } else {
                request.getFetchOptions().doNotFollowRedirects();
            }
            int connectTimeoutMillis = this.getConnectTimeout();
            int readTimeoutMillis = this.getReadTimeout();
            double deadlineSeconds = connectTimeoutMillis == 0 || readTimeoutMillis == 0 ? 2.147483647E9 : (double)(this.getConnectTimeout() + this.getReadTimeout()) / 1000.0;
            if (deadlineSeconds > 0.0) {
                request.getFetchOptions().setDeadline(Double.valueOf(deadlineSeconds));
            }
            for (Map.Entry<String, List<String>> entry : this.requestProperties.entrySet()) {
                String name = entry.getKey();
                values = new ArrayList<String>((Collection)entry.getValue());
                for (String value : values) {
                    request.addHeader(new HTTPHeader(name, value));
                }
            }
            if (this.outputStream != null) {
                byte[] output = this.outputStream.toByteArray();
                this.outputStream.close();
                request.setPayload(output);
            }
            this.response = this.service.fetch(request);
            this.responseCode = this.response.getResponseCode();
            if (this.response.getFinalUrl() != null) {
                this.url = this.response.getFinalUrl();
            }
            List headers = this.response.getHeaders();
            this.responseFields = new LinkedHashMap(headers.size());
            for (HTTPHeader header : headers) {
                values = new ArrayList();
                String headerValue = header.getValue();
                StringTokenizer st = new StringTokenizer(headerValue, ",");
                while (st.hasMoreTokens()) {
                    values.add(URLFetchServiceStreamHandler.trim(st.nextToken()));
                }
                values.trimToSize();
                this.responseFields.put(header.getName().toLowerCase(), values);
            }
            return this.response;
        }

        private class BufferingOutputStream
        extends OutputStream {
            private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            private boolean closed;

            @Override
            public void write(int b) throws IOException {
                this.checkOpen();
                this.buffer.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.checkOpen();
                this.buffer.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.checkOpen();
                this.buffer.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.checkOpen();
                this.buffer.flush();
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
                this.closed = true;
                if (!Connection.this.getDoInput()) {
                    Connection.this.fetchResponse();
                }
            }

            public byte[] toByteArray() {
                return this.buffer.toByteArray();
            }

            private void checkOpen() throws IOException {
                if (this.closed) {
                    String msg = "The OutputStream has been committed and can no longer be written to.";
                    throw new IOException(msg);
                }
            }
        }
    }
}

