/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class Results<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -8342630524311776674L;
    private static final int MAX_RESULTS_TO_STRING = 10;
    private final OperationResult operationResult;
    private final Collection<T> results;
    private final long numberFound;
    private final int numberReturned;
    private final Cursor cursor;

    Results(OperationResult operationResult, Collection<T> results, long numberFound, int numberReturned, Cursor cursor) {
        this.operationResult = Preconditions.checkNotNull(operationResult, "operation result cannot be null");
        this.results = Collections.unmodifiableCollection(Preconditions.checkNotNull(results, "search results cannot be null"));
        this.numberFound = numberFound;
        this.numberReturned = numberReturned;
        this.cursor = cursor;
    }

    @Override
    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public long getNumberFound() {
        return this.numberFound;
    }

    public int getNumberReturned() {
        return this.numberReturned;
    }

    public Collection<T> getResults() {
        return this.results;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public String toString() {
        return String.format("Results(operationResult=%s, results=%s, numberFound=%d, numberReturned=%d, cursor=%s)", this.operationResult, Util.iterableToString(this.results, 10), this.numberFound, this.numberReturned, this.cursor);
    }
}

