/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.KeyRegistry;

class EmulatedXAResource
implements XAResource {
    private State state = State.NEW;
    private final KeyRegistry keyRegistry = new KeyRegistry();

    EmulatedXAResource() {
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.state != State.NEW) {
            throw new XAException("Nested transactions are not supported");
        }
        this.state = State.ACTIVE;
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
        if (this.state != State.ACTIVE) {
            throw new XAException("A transaction has not been started, cannot commit");
        }
        this.keyRegistry.clear();
        this.state = State.INACTIVE;
    }

    public void rollback(Xid xid) throws XAException {
        if (this.state != State.ACTIVE) {
            throw new XAException("A transaction has not been started, cannot rollback");
        }
        this.keyRegistry.clear();
        this.state = State.INACTIVE;
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return true;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        throw new XAException("Unsupported operation");
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    KeyRegistry getKeyRegistry() {
        return this.keyRegistry;
    }

    DatastoreTransaction getCurrentTransaction() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NEW,
        ACTIVE,
        INACTIVE;

    }
}

