/**********************************************************************
Copyright (c) 2009 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.store.query.cache;

import java.util.Map;

import org.datanucleus.OMFContext;
import org.datanucleus.util.WeakValueMap;

/**
 * Implementation of a query cache using weak referencing.
 */
public class WeakQueryCache implements QueryCache
{
    private Map<String, CachedQuery> cache = new WeakValueMap();

    public WeakQueryCache(OMFContext omfCtx)
    {
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#clear()
     */
    public void clear()
    {
        cache.clear();
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#close()
     */
    public void close()
    {
        clear();
        cache = null;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#contains(java.lang.String)
     */
    public boolean contains(String queryKey)
    {
        return cache.containsKey(queryKey);
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#evict(java.lang.String)
     */
    public void evict(String queryKey)
    {
        cache.remove(queryKey);
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#get(java.lang.String)
     */
    public CachedQuery get(String queryKey)
    {
        return cache.get(queryKey);
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#isEmpty()
     */
    public boolean isEmpty()
    {
        return cache.isEmpty();
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#put(java.lang.String, org.datanucleus.store.query.cache.CachedQuery)
     */
    public CachedQuery put(String queryKey, CachedQuery cachedQuery)
    {
        return cache.put(queryKey, cachedQuery);
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.query.cache.QueryCache#size()
     */
    public int size()
    {
        return cache.size();
    }
}