/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.utils.HttpRequestParser;
import com.google.appengine.api.xmpp.Error;
import com.google.appengine.api.xmpp.ErrorBuilder;
import com.google.appengine.api.xmpp.JID;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;

class InboundErrorParser
extends HttpRequestParser {
    InboundErrorParser() {
    }

    static Error parseError(HttpServletRequest request) throws IOException {
        try {
            ErrorBuilder builder = new ErrorBuilder();
            MimeMultipart multipart = InboundErrorParser.parseMultipartRequest(request);
            int parts = multipart.getCount();
            for (int i = 0; i < parts; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String fieldName = InboundErrorParser.getFieldName(part);
                if ("from".equals(fieldName)) {
                    builder.withFromJid(new JID(InboundErrorParser.getTextContent(part)));
                    continue;
                }
                if (!"stanza".equals(fieldName)) continue;
                builder.withStanza(InboundErrorParser.getTextContent(part));
            }
            return builder.build();
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Could not parse incoming request.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

