/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadableInterval;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.base.BaseInterval;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import java.io.Serializable;

public final class Interval
extends BaseInterval
implements ReadableInterval,
Serializable {
    private static final long serialVersionUID = 4922451897541386752L;

    public static Interval parse(String str) {
        return new Interval(str);
    }

    public Interval(long startInstant, long endInstant) {
        super(startInstant, endInstant, null);
    }

    public Interval(long startInstant, long endInstant, DateTimeZone zone) {
        super(startInstant, endInstant, ISOChronology.getInstance(zone));
    }

    public Interval(long startInstant, long endInstant, Chronology chronology) {
        super(startInstant, endInstant, chronology);
    }

    public Interval(ReadableInstant start, ReadableInstant end) {
        super(start, end);
    }

    public Interval(ReadableInstant start, ReadableDuration duration) {
        super(start, duration);
    }

    public Interval(ReadableDuration duration, ReadableInstant end) {
        super(duration, end);
    }

    public Interval(ReadableInstant start, ReadablePeriod period) {
        super(start, period);
    }

    public Interval(ReadablePeriod period, ReadableInstant end) {
        super(period, end);
    }

    public Interval(Object interval) {
        super(interval, null);
    }

    public Interval(Object interval, Chronology chronology) {
        super(interval, chronology);
    }

    @Override
    public Interval toInterval() {
        return this;
    }

    public Interval overlap(ReadableInterval interval) {
        if (!this.overlaps(interval = DateTimeUtils.getReadableInterval(interval))) {
            return null;
        }
        long start = Math.max(this.getStartMillis(), interval.getStartMillis());
        long end = Math.min(this.getEndMillis(), interval.getEndMillis());
        return new Interval(start, end, this.getChronology());
    }

    public Interval gap(ReadableInterval interval) {
        interval = DateTimeUtils.getReadableInterval(interval);
        long otherStart = interval.getStartMillis();
        long otherEnd = interval.getEndMillis();
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        if (thisStart > otherEnd) {
            return new Interval(otherEnd, thisStart, this.getChronology());
        }
        if (otherStart > thisEnd) {
            return new Interval(thisEnd, otherStart, this.getChronology());
        }
        return null;
    }

    public boolean abuts(ReadableInterval interval) {
        if (interval == null) {
            long now = DateTimeUtils.currentTimeMillis();
            return this.getStartMillis() == now || this.getEndMillis() == now;
        }
        return interval.getEndMillis() == this.getStartMillis() || this.getEndMillis() == interval.getStartMillis();
    }

    public Interval withChronology(Chronology chronology) {
        if (this.getChronology() == chronology) {
            return this;
        }
        return new Interval(this.getStartMillis(), this.getEndMillis(), chronology);
    }

    public Interval withStartMillis(long startInstant) {
        if (startInstant == this.getStartMillis()) {
            return this;
        }
        return new Interval(startInstant, this.getEndMillis(), this.getChronology());
    }

    public Interval withStart(ReadableInstant start) {
        long startMillis = DateTimeUtils.getInstantMillis(start);
        return this.withStartMillis(startMillis);
    }

    public Interval withEndMillis(long endInstant) {
        if (endInstant == this.getEndMillis()) {
            return this;
        }
        return new Interval(this.getStartMillis(), endInstant, this.getChronology());
    }

    public Interval withEnd(ReadableInstant end) {
        long endMillis = DateTimeUtils.getInstantMillis(end);
        return this.withEndMillis(endMillis);
    }

    public Interval withDurationAfterStart(ReadableDuration duration) {
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        if (durationMillis == this.toDurationMillis()) {
            return this;
        }
        Chronology chrono = this.getChronology();
        long startMillis = this.getStartMillis();
        long endMillis = chrono.add(startMillis, durationMillis, 1);
        return new Interval(startMillis, endMillis, chrono);
    }

    public Interval withDurationBeforeEnd(ReadableDuration duration) {
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        if (durationMillis == this.toDurationMillis()) {
            return this;
        }
        Chronology chrono = this.getChronology();
        long endMillis = this.getEndMillis();
        long startMillis = chrono.add(endMillis, durationMillis, -1);
        return new Interval(startMillis, endMillis, chrono);
    }

    public Interval withPeriodAfterStart(ReadablePeriod period) {
        if (period == null) {
            return this.withDurationAfterStart(null);
        }
        Chronology chrono = this.getChronology();
        long startMillis = this.getStartMillis();
        long endMillis = chrono.add(period, startMillis, 1);
        return new Interval(startMillis, endMillis, chrono);
    }

    public Interval withPeriodBeforeEnd(ReadablePeriod period) {
        if (period == null) {
            return this.withDurationBeforeEnd(null);
        }
        Chronology chrono = this.getChronology();
        long endMillis = this.getEndMillis();
        long startMillis = chrono.add(period, endMillis, -1);
        return new Interval(startMillis, endMillis, chrono);
    }
}

