/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;

public class CoalesceFunctionEvaluator
implements InvocationEvaluator {
    public Object evaluate(InvokeExpression expr, Object ignored, InMemoryExpressionEvaluator eval) {
        List<Expression> args = expr.getArguments();
        if (args == null || args.isEmpty()) {
            return null;
        }
        Iterator<Expression> iter = args.iterator();
        Object argValue = null;
        while (iter.hasNext()) {
            Expression argExpr = iter.next();
            argValue = this.getValueForArgExpression(argExpr, eval);
            if (argValue == null) continue;
            return argValue;
        }
        return null;
    }

    protected Object getValueForArgExpression(Expression argExpr, InMemoryExpressionEvaluator eval) {
        Object argValue = null;
        if (argExpr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)argExpr;
            argValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (argExpr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)argExpr;
            argValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (argExpr instanceof Literal) {
            argValue = ((Literal)argExpr).getLiteral();
        } else {
            throw new NucleusException("Don't support COALESCE with argument of type " + argExpr.getClass().getName());
        }
        return argValue;
    }
}

