/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.TypeConversionUtils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import java.util.LinkedList;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public abstract class DatastoreFieldManager
extends AbstractFieldManager {
    private final TypeConversionUtils typeConversionUtils;
    protected final LinkedList<FieldManagerState> fieldManagerStateStack = new LinkedList();
    protected ExecutionContext ec;
    protected Entity datastoreEntity;

    protected DatastoreFieldManager(ObjectProvider op, Entity datastoreEntity, int[] fieldNumbers) {
        this.ec = op.getExecutionContext();
        this.datastoreEntity = datastoreEntity;
        this.fieldManagerStateStack.addFirst(new FieldManagerState(op));
        DatastoreManager storeManager = (DatastoreManager)this.ec.getStoreManager();
        this.typeConversionUtils = storeManager.getTypeConversionUtils();
        String expectedKind = EntityUtils.determineKind(op.getClassMetaData(), this.ec);
        if (!expectedKind.equals(datastoreEntity.getKind())) {
            throw new NucleusException("ObjectProvider is for <" + expectedKind + "> but key is for <" + datastoreEntity.getKind() + ">.  One way this can happen is if you attempt to fetch an object of one type using" + " a Key of a different type.").setFatal();
        }
    }

    Entity getEntity() {
        return this.datastoreEntity;
    }

    ObjectProvider getObjectProvider() {
        return this.fieldManagerStateStack.getFirst().op;
    }

    AbstractMemberMetaData getMetaData(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (this.fieldManagerStateStack.getFirst().embmd == null) {
            return mmd;
        }
        AbstractMemberMetaData[] embmmds = this.fieldManagerStateStack.getFirst().embmd.getMemberMetaData();
        if (embmmds != null) {
            for (int i = 0; i < embmmds.length; ++i) {
                if (!mmd.getName().equals(embmmds[i].getName())) continue;
                return embmmds[i];
            }
        }
        return mmd;
    }

    protected boolean isPK(int fieldNumber) {
        if (this.fieldManagerStateStack.getFirst().embmd != null) {
            return false;
        }
        int[] pkPositions = this.getClassMetaData().getPKMemberPositions();
        return pkPositions != null && pkPositions[0] == fieldNumber;
    }

    AbstractClassMetaData getClassMetaData() {
        return this.getObjectProvider().getClassMetaData();
    }

    ClassLoaderResolver getClassLoaderResolver() {
        return this.ec.getClassLoaderResolver();
    }

    DatastoreManager getStoreManager() {
        return (DatastoreManager)this.ec.getStoreManager();
    }

    DatastoreTable getDatastoreTable() {
        return this.getStoreManager().getDatastoreClass(this.getClassMetaData().getFullClassName(), this.getClassLoaderResolver());
    }

    protected RuntimeException exceptionForUnexpectedKeyType(String fieldType, int fieldNumber) {
        return new IllegalStateException(fieldType + " for type " + this.getClassMetaData().getName() + " is of unexpected type " + this.getMetaData(fieldNumber).getType().getName() + " (must be String, Long, long, or " + Key.class.getName() + ")");
    }

    protected ObjectProvider getEmbeddedObjectProvider(Class type, int fieldNumber, Object value) {
        ObjectProvider embeddedOP;
        if (value == null) {
            value = JDOImplHelper.getInstance().newInstance(type, (StateManager)this.getObjectProvider());
        }
        if ((embeddedOP = this.ec.findObjectProvider(value)) == null) {
            embeddedOP = ObjectProviderFactory.newForEmbedded((ExecutionContext)this.ec, (Object)value, (boolean)false, (ObjectProvider)this.getObjectProvider(), (int)fieldNumber);
            embeddedOP.setPcObjectType((short)1);
        }
        return embeddedOP;
    }

    protected String getPropertyNameForMember(AbstractMemberMetaData mmd) {
        String propName = EntityUtils.getPropertyName(this.getStoreManager().getIdentifierFactory(), mmd);
        if (this.fieldManagerStateStack.getFirst().index != null) {
            return propName + "." + this.fieldManagerStateStack.getFirst().index;
        }
        return propName;
    }

    TypeConversionUtils getConversionUtils() {
        return this.typeConversionUtils;
    }

    protected static final class FieldManagerState {
        protected final ObjectProvider op;
        protected final EmbeddedMetaData embmd;
        protected final Integer index;

        protected FieldManagerState(ObjectProvider op) {
            this.op = op;
            this.embmd = null;
            this.index = null;
        }

        protected FieldManagerState(ObjectProvider op, EmbeddedMetaData embmd) {
            this.op = op;
            this.embmd = embmd;
            this.index = null;
        }

        protected FieldManagerState(ObjectProvider op, EmbeddedMetaData embmd, int pos) {
            this.op = op;
            this.embmd = embmd;
            this.index = pos;
        }
    }
}

