/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.StorageVersion;
import com.google.appengine.datanucleus.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MetaDataValidator {
    protected static final Localiser GAE_LOCALISER = Localiser.getInstance((String)"com.google.appengine.datanucleus.Localisation", (ClassLoader)DatastoreManager.class.getClassLoader());
    private static final Set<String> ONE_OR_ZERO_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.encoded-pk", "gae.pk-name", "gae.parent-pk");
    private static final Set<String> NOT_PRIMARY_KEY_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.pk-name", "gae.parent-pk");
    private static final Set<String> REQUIRES_ENCODED_STRING_PK_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.pk-name");
    private static final String IGNORABLE_META_DATA_BEHAVIOR_PROPERTY = "datanucleus.appengine.ignorableMetaDataBehavior";
    static final String ADJUST_WARNING_MSG = String.format("You can modify this warning by setting the %s property in your config.  A value of %s will silence the warning.  A value of %s will turn the warning into an exception.", new Object[]{"datanucleus.appengine.ignorableMetaDataBehavior", IgnorableMetaDataBehavior.NONE, IgnorableMetaDataBehavior.ERROR});
    private static final Set<Integer> NON_REPEATABLE_RELATION_TYPES = Utils.newHashSet(4, 3, 2, 1);
    private static final String ALLOW_MULTIPLE_RELATIONS_OF_SAME_TYPE = "datanucleus.appengine.allowMultipleRelationsOfSameType";
    private final DatastoreManager storeMgr;
    private final MetaDataManager metaDataManager;
    private final ClassLoaderResolver clr;

    public MetaDataValidator(DatastoreManager storeMgr, MetaDataManager metaDataManager, ClassLoaderResolver clr) {
        this.storeMgr = storeMgr;
        this.metaDataManager = metaDataManager;
        this.clr = clr;
    }

    public void validate(AbstractClassMetaData acmd) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        NucleusLogger.METADATA.info((Object)("Performing appengine-specific metadata validation for " + acmd.getFullClassName()));
        AbstractMemberMetaData pkMemberMetaData = null;
        Class<Long> pkType = null;
        boolean noParentAllowed = false;
        if (acmd.getIdentityType() == IdentityType.DATASTORE) {
            pkType = Key.class;
            ColumnMetaData colmd = acmd.getIdentityMetaData().getColumnMetaData();
            if (colmd != null) {
                if ("varchar".equalsIgnoreCase(colmd.getJdbcType()) || "char".equalsIgnoreCase(colmd.getJdbcType())) {
                    pkType = String.class;
                } else if ("integer".equalsIgnoreCase(colmd.getJdbcType()) || "numeric".equalsIgnoreCase(colmd.getJdbcType())) {
                    pkType = Long.class;
                }
            }
            if (pkType == Long.class) {
                noParentAllowed = true;
            }
        } else if (acmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = acmd.getPKMemberPositions();
            if (pkPositions == null) {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.NoPkFields", (Object)acmd.getFullClassName());
            }
            if (pkPositions.length != 1) {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.CompositePKNotSupported", (Object)acmd.getFullClassName());
            }
            int pkPos = pkPositions[0];
            pkMemberMetaData = acmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPos);
            pkType = pkMemberMetaData.getType();
            if (pkType.equals(Long.class) || pkType.equals(Long.TYPE) || pkType.equals(Integer.class) || pkType.equals(Integer.TYPE)) {
                noParentAllowed = true;
            } else if (pkType.equals(String.class)) {
                if (!MetaDataUtils.isEncodedPKField(acmd, pkPos)) {
                    noParentAllowed = true;
                } else if (MetaDataValidator.hasIdentityStrategy(IdentityStrategy.SEQUENCE, pkMemberMetaData)) {
                    throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.SequenceInvalidForEncodedStringPK", (Object)pkMemberMetaData.getFullFieldName());
                }
            } else if (pkType.equals(Key.class)) {
                if (MetaDataValidator.hasIdentityStrategy(IdentityStrategy.SEQUENCE, pkMemberMetaData)) {
                    throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.SequenceInvalidForPKType", (Object)pkMemberMetaData.getFullFieldName(), (Object)Key.class.getName());
                }
            } else {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.InvalidPKTypeForField", (Object)pkMemberMetaData.getFullFieldName(), (Object)pkType.getName());
            }
        }
        HashSet<Object> foundOneOrZeroExtensions = Utils.newHashSet(new Object[0]);
        HashMap<Class<?>, String> nonRepeatableRelationTypes = Utils.newHashMap();
        AbstractClassMetaData curCmd = acmd;
        do {
            for (AbstractMemberMetaData ammd : curCmd.getManagedMembers()) {
                this.validateField(acmd, pkMemberMetaData, noParentAllowed, pkType, foundOneOrZeroExtensions, nonRepeatableRelationTypes, ammd);
            }
        } while ((curCmd = curCmd.getSuperAbstractClassMetaData()) != null);
        if (acmd.getUniqueMetaData() != null && acmd.getUniqueMetaData().length > 0) {
            this.handleIgnorableMapping(acmd, null, "AppEngine.MetaData.UniqueConstraintsNotSupported", "The constraint definition will be ignored.");
        }
        NucleusLogger.METADATA.info((Object)("Finished performing appengine-specific metadata validation for " + acmd.getFullClassName()));
    }

    private void validateField(AbstractClassMetaData acmd, AbstractMemberMetaData pkMemberMetaData, boolean noParentAllowed, Class<?> pkClass, Set<String> foundOneOrZeroExtensions, Map<Class<?>, String> nonRepeatableRelationTypes, AbstractMemberMetaData ammd) {
        SequenceMetaData sequenceMetaData;
        for (String extension : ONE_OR_ZERO_EXTENSIONS) {
            if (!ammd.hasExtension(extension) || foundOneOrZeroExtensions.add(extension)) continue;
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.MoreThanOneFieldWithExtension", (Object)acmd.getFullClassName(), (Object)extension);
        }
        if (!(!ammd.hasExtension("gae.encoded-pk") || ammd.isPrimaryKey() && ammd.getType().equals(String.class))) {
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ExtensionForStringPK", (Object)ammd.getFullFieldName(), (Object)"gae.encoded-pk");
        }
        if (ammd.hasExtension("gae.pk-name") && !ammd.getType().equals(String.class)) {
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ExtensionForStringField", (Object)ammd.getFullFieldName(), (Object)"gae.pk-name");
        }
        if (ammd.hasExtension("gae.pk-id") && !ammd.getType().equals(Long.class) && !ammd.getType().equals(Long.TYPE)) {
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ExtensionForLongField", (Object)ammd.getFullFieldName(), (Object)"gae.pk-id");
        }
        if (ammd.hasExtension("gae.parent-pk")) {
            if (noParentAllowed) {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.PKAndParentPKInvalid", (Object)ammd.getFullFieldName(), (Object)pkClass.getName());
            }
            if (!ammd.getType().equals(String.class) && !ammd.getType().equals(Key.class)) {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ParentPKType", (Object)ammd.getFullFieldName());
            }
        }
        for (String extension : NOT_PRIMARY_KEY_EXTENSIONS) {
            if (!ammd.hasExtension(extension) || !ammd.isPrimaryKey()) continue;
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.FieldWithExtensionNotPK", (Object)ammd.getFullFieldName(), (Object)extension);
        }
        if (pkMemberMetaData != null) {
            for (String extension : REQUIRES_ENCODED_STRING_PK_EXTENSIONS) {
                if (!ammd.hasExtension(extension) || pkMemberMetaData.hasExtension("gae.encoded-pk")) continue;
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.FieldWithExtensionForEncodedString", (Object)ammd.getFullFieldName(), (Object)extension);
            }
        }
        if (ammd.hasCollection() && ammd.getCollection().isSerializedElement()) {
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.CollectionWithSerializedElementInvalid", (Object)ammd.getFullFieldName());
        }
        if (ammd.hasArray() && ammd.getArray().isSerializedElement()) {
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ArrayWithSerializedElementInvalid", (Object)ammd.getFullFieldName());
        }
        this.checkForIllegalChildField(ammd, noParentAllowed);
        if (ammd.getRelationType(this.clr) != 0) {
            if (ammd.isDefaultFetchGroup() && !ammd.isEmbedded()) {
                this.handleIgnorableMapping(acmd, ammd, "AppEngine.MetaData.JoinsNotSupported", "The field will be fetched lazily on first access.");
            }
            if (ammd.getRelationType(this.clr) == 5 && MetaDataUtils.isOwnedRelation(ammd, this.storeMgr)) {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ManyToManyRelationNotSupported", (Object)ammd.getFullFieldName());
            }
            if (ammd.getEmbeddedMetaData() == null && NON_REPEATABLE_RELATION_TYPES.contains(ammd.getRelationType(this.clr)) && !this.getBooleanConfigProperty(ALLOW_MULTIPLE_RELATIONS_OF_SAME_TYPE) && !this.storeMgr.storageVersionAtLeast(StorageVersion.READ_OWNED_CHILD_KEYS_FROM_PARENTS)) {
                Class relationClass = ammd.getCollection() != null ? this.clr.classForName(ammd.getCollection().getElementType()) : (ammd.getArray() != null ? this.clr.classForName(ammd.getArray().getElementType()) : this.clr.classForName(ammd.getTypeName()));
                for (Class<?> existingRelationClass : nonRepeatableRelationTypes.keySet()) {
                    if (!existingRelationClass.isAssignableFrom(relationClass) && !relationClass.isAssignableFrom(existingRelationClass)) continue;
                    throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ClassWithMultipleFieldsOfType", (Object)acmd.getFullClassName(), (Object)relationClass.getName(), (Object)ammd.getName(), (Object)nonRepeatableRelationTypes.get(existingRelationClass));
                }
                nonRepeatableRelationTypes.put(relationClass, ammd.getName());
            }
        }
        if (ammd.getValueGeneratorName() != null && (sequenceMetaData = this.metaDataManager.getMetaDataForSequence(this.clr, ammd.getValueGeneratorName())) != null && sequenceMetaData.getInitialValue() != 1) {
            this.handleIgnorableMapping(acmd, ammd, "AppEngine.MetaData.SequenceInitialSizeNotSupported", "The first value for this sequence will be 1.");
        }
    }

    private void checkForIllegalChildField(AbstractMemberMetaData ammd, boolean noParentAllowed) {
        if (!MetaDataUtils.isOwnedRelation(ammd, this.storeMgr)) {
            return;
        }
        int relationType = ammd.getRelationType(this.clr);
        if (relationType == 0 || ammd.isEmbedded()) {
            return;
        }
        AbstractClassMetaData childAcmd = null;
        if (relationType == 4 || relationType == 3) {
            if (ammd.getCollection() != null) {
                childAcmd = ammd.getCollection().getElementClassMetaData(this.clr, this.metaDataManager);
            } else if (ammd.getArray() != null) {
                childAcmd = ammd.getArray().getElementClassMetaData(this.clr, this.metaDataManager);
            } else {
                NucleusLogger.METADATA.warn((Object)("Unable to validate one-to-many relation " + ammd.getFullFieldName()));
            }
            if (ammd.getOrderMetaData() != null) {
                this.verifyOneToManyOrderBy(ammd, childAcmd);
            }
        } else if (relationType == 2 || relationType == 1) {
            childAcmd = this.metaDataManager.getMetaDataForClass(ammd.getType(), this.clr);
        }
        if (childAcmd == null) {
            return;
        }
        if (childAcmd.getIdentityType() == IdentityType.DATASTORE) {
            Class pkType = Long.class;
            ColumnMetaData colmd = childAcmd.getIdentityMetaData().getColumnMetaData();
            if (colmd != null && ("varchar".equalsIgnoreCase(colmd.getJdbcType()) || "char".equalsIgnoreCase(colmd.getJdbcType()))) {
                pkType = String.class;
            }
            if (noParentAllowed && pkType.equals(Long.class)) {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ChildWithPKTypeInvalid", (Object)(childAcmd.getFullClassName() + ".[ID]"), (Object)pkType.getName(), (Object)ammd.getFullFieldName());
            }
        } else {
            int[] pkPositions = childAcmd.getPKMemberPositions();
            if (pkPositions == null) {
                NucleusLogger.METADATA.warn((Object)("Unable to validate relation " + ammd.getFullFieldName()));
                return;
            }
            int pkPos = pkPositions[0];
            AbstractMemberMetaData pkMemberMetaData = childAcmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPos);
            Class pkType = pkMemberMetaData.getType();
            if (noParentAllowed && (pkType.equals(Long.class) || pkType.equals(Long.TYPE) || pkType.equals(String.class) && !pkMemberMetaData.hasExtension("gae.encoded-pk"))) {
                throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.ChildWithPKTypeInvalid", (Object)pkMemberMetaData.getFullFieldName(), (Object)pkType.getName(), (Object)ammd.getFullFieldName());
            }
        }
    }

    private void verifyOneToManyOrderBy(AbstractMemberMetaData ammd, AbstractClassMetaData childAcmd) {
        OrderMetaData omd = ammd.getOrderMetaData();
        OrderMetaData.FieldOrder[] fieldOrders = omd.getFieldOrders();
        if (fieldOrders == null) {
            return;
        }
        for (OrderMetaData.FieldOrder fieldOrder : omd.getFieldOrders()) {
            String propertyName = fieldOrder.getFieldName();
            AbstractMemberMetaData orderField = childAcmd.getMetaDataForMember(propertyName);
            if (!orderField.hasExtension("gae.pk-id") && !orderField.hasExtension("gae.pk-name")) continue;
            throw new InvalidMetaDataException(GAE_LOCALISER, "AppEngine.MetaData.OrderPartOfPK", (Object)ammd.getFullFieldName(), (Object)propertyName);
        }
    }

    private static boolean hasIdentityStrategy(IdentityStrategy strat, AbstractMemberMetaData ammd) {
        return ammd.getValueStrategy() != null && ammd.getValueStrategy().equals((Object)strat);
    }

    private boolean getBooleanConfigProperty(String configProperty) {
        return this.metaDataManager.getNucleusContext().getPersistenceConfiguration().getBooleanProperty(configProperty);
    }

    private IgnorableMetaDataBehavior getIgnorableMetaDataBehavior() {
        return IgnorableMetaDataBehavior.valueOf(this.metaDataManager.getNucleusContext().getStoreManager().getStringProperty(IGNORABLE_META_DATA_BEHAVIOR_PROPERTY), IgnorableMetaDataBehavior.WARN);
    }

    void handleIgnorableMapping(AbstractClassMetaData acmd, AbstractMemberMetaData ammd, String localiserKey, String warningOnlyMsg) {
        switch (this.getIgnorableMetaDataBehavior()) {
            case WARN: {
                if (ammd == null) {
                    this.warn(String.format("Meta-data warning for %s: %s  %s  %s", acmd.getFullClassName(), GAE_LOCALISER.msg(localiserKey), warningOnlyMsg, ADJUST_WARNING_MSG));
                    break;
                }
                this.warn(String.format("Meta-data warning for %s.%s: %s  %s  %s", acmd.getFullClassName(), ammd.getName(), GAE_LOCALISER.msg(localiserKey, (Object)ammd.getFullFieldName()), warningOnlyMsg, ADJUST_WARNING_MSG));
                break;
            }
            case ERROR: {
                if (ammd == null) {
                    throw new InvalidMetaDataException(GAE_LOCALISER, localiserKey, (Object)acmd.getFullClassName());
                }
                throw new InvalidMetaDataException(GAE_LOCALISER, localiserKey, (Object)ammd.getFullFieldName());
            }
        }
    }

    void warn(String msg) {
        NucleusLogger.METADATA.warn((Object)msg);
    }

    static enum IgnorableMetaDataBehavior {
        NONE,
        WARN,
        ERROR;


        private static IgnorableMetaDataBehavior valueOf(String val, IgnorableMetaDataBehavior returnIfNull) {
            if (val == null) {
                return returnIfNull;
            }
            return IgnorableMetaDataBehavior.valueOf(val);
        }
    }
}

