/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.query.QueryExceptionWrappers;
import com.google.appengine.datanucleus.query.RuntimeExceptionObserver;
import java.util.Iterator;
import org.datanucleus.api.ApiAdapter;

class RuntimeExceptionWrappingIterator
implements Iterator<Entity> {
    final ApiAdapter api;
    final Iterator<Entity> inner;
    final Utils.Supplier<Boolean> hasNextSupplier;
    final Utils.Supplier<Entity> nextSupplier;
    final Utils.Supplier<Void> removeSupplier;

    RuntimeExceptionWrappingIterator(ApiAdapter api, final Iterator<Entity> inner, final RuntimeExceptionObserver exceptionObserver) {
        if (inner == null) {
            throw new NullPointerException("inner cannot be null");
        }
        this.api = api;
        this.inner = inner;
        Utils.Supplier<Boolean> datastoreHasNextSupplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                boolean success = false;
                try {
                    boolean result = inner.hasNext();
                    success = true;
                    Boolean bl = result;
                    return bl;
                }
                finally {
                    if (!success) {
                        exceptionObserver.onException();
                    }
                }
            }
        });
        Utils.Supplier<Entity> datastoreNextSupplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Entity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Entity get() {
                boolean success = false;
                try {
                    Entity result = (Entity)inner.next();
                    success = true;
                    Entity entity = result;
                    return entity;
                }
                finally {
                    if (!success) {
                        exceptionObserver.onException();
                    }
                }
            }
        });
        Utils.Supplier<Void> datastoreRemoveSupplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void get() {
                boolean success = false;
                try {
                    inner.remove();
                    success = true;
                    Void void_ = null;
                    return void_;
                }
                finally {
                    if (!success) {
                        exceptionObserver.onException();
                    }
                }
            }
        });
        this.hasNextSupplier = QueryExceptionWrappers.dataNucleusToApi(api, datastoreHasNextSupplier);
        this.nextSupplier = QueryExceptionWrappers.dataNucleusToApi(api, datastoreNextSupplier);
        this.removeSupplier = QueryExceptionWrappers.dataNucleusToApi(api, datastoreRemoveSupplier);
    }

    @Override
    public boolean hasNext() {
        return this.hasNextSupplier.get();
    }

    @Override
    public Entity next() {
        return this.nextSupplier.get();
    }

    @Override
    public void remove() {
        this.removeSupplier.get();
    }
}

