/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.security.openid.OpenIdLoginService;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenIdAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(OpenIdAuthenticator.class);
    public static final String CLAIMS = "org.eclipse.jetty.security.openid.claims";
    public static final String RESPONSE = "org.eclipse.jetty.security.openid.response";
    public static final String ERROR_PAGE = "org.eclipse.jetty.security.openid.error_page";
    public static final String J_URI = "org.eclipse.jetty.security.openid.URI";
    public static final String J_POST = "org.eclipse.jetty.security.openid.POST";
    public static final String J_METHOD = "org.eclipse.jetty.security.openid.METHOD";
    public static final String CSRF_TOKEN = "org.eclipse.jetty.security.openid.csrf_token";
    public static final String J_SECURITY_CHECK = "/j_security_check";
    private OpenIdConfiguration _configuration;
    private String _errorPage;
    private String _errorPath;
    private boolean _alwaysSaveUri;

    public OpenIdAuthenticator() {
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration, String errorPage) {
        this._configuration = configuration;
        if (errorPage != null) {
            this.setErrorPage(errorPage);
        }
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        String error = configuration.getInitParameter(ERROR_PAGE);
        if (error != null) {
            this.setErrorPage(error);
        }
        if (this._configuration != null) {
            return;
        }
        LoginService loginService = configuration.getLoginService();
        if (!(loginService instanceof OpenIdLoginService)) {
            throw new IllegalArgumentException("invalid LoginService");
        }
        this._configuration = ((OpenIdLoginService)loginService).getConfiguration();
    }

    public String getAuthMethod() {
        return "OPENID";
    }

    public void setAlwaysSaveUri(boolean alwaysSave) {
        this._alwaysSaveUri = alwaysSave;
    }

    public boolean isAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    private void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this._errorPath = null;
            this._errorPage = null;
        } else {
            if (!path.startsWith("/")) {
                LOG.warn("error-page must start with /", new Object[0]);
                path = "/" + path;
            }
            this._errorPage = path;
            this._errorPath = path;
            if (this._errorPath.indexOf(63) > 0) {
                this._errorPath = this._errorPath.substring(0, this._errorPath.indexOf(63));
            }
        }
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        UserIdentity user;
        if (LOG.isDebugEnabled()) {
            LOG.debug("login {} {} {}", new Object[]{username, credentials, request});
        }
        if ((user = super.login(username, credentials, request)) != null) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, credentials);
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
            session.setAttribute(CLAIMS, ((OpenIdCredentials)credentials).getClaims());
            session.setAttribute(RESPONSE, ((OpenIdCredentials)credentials).getResponse());
        }
        return user;
    }

    public void logout(ServletRequest request) {
        super.logout(request);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
        session.removeAttribute(CLAIMS);
        session.removeAttribute(RESPONSE);
    }

    public void prepareRequest(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null || session.getAttribute("org.eclipse.jetty.security.UserIdentity") == null) {
            return;
        }
        String juri = (String)session.getAttribute(J_URI);
        if (juri == null || juri.length() == 0) {
            return;
        }
        String method = (String)session.getAttribute(J_METHOD);
        if (method == null || method.length() == 0) {
            return;
        }
        StringBuffer buf = httpRequest.getRequestURL();
        if (httpRequest.getQueryString() != null) {
            buf.append("?").append(httpRequest.getQueryString());
        }
        if (!juri.equals(buf.toString())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restoring original method {} for {} with method {}", new Object[]{method, juri, httpRequest.getMethod()});
        }
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        baseRequest.setMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        Response baseResponse = baseRequest.getResponse();
        String uri = request.getRequestURI();
        if (uri == null) {
            uri = "/";
        }
        if (!(mandatory |= this.isJSecurityCheck(uri))) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        if (this.isErrorPage(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo())) && !DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        try {
            Authentication authentication;
            if (request.isRequestedSessionIdFromURL()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session ID should be cookie for OpenID authentication to work", new Object[0]);
                }
                baseResponse.sendRedirect(OpenIdAuthenticator.getRedirectCode(baseRequest.getHttpVersion()), URIUtil.addPaths((String)request.getContextPath(), (String)this._errorPage));
                return Authentication.SEND_FAILURE;
            }
            if (this.isJSecurityCheck(uri)) {
                String authCode = request.getParameter("code");
                if (authCode != null) {
                    String state = request.getParameter("state");
                    String antiForgeryToken = (String)request.getSession().getAttribute(CSRF_TOKEN);
                    if (antiForgeryToken == null || !antiForgeryToken.equals(state)) {
                        LOG.warn("auth failed 403: invalid state parameter", new Object[0]);
                        if (response != null) {
                            response.sendError(403);
                        }
                        return Authentication.SEND_FAILURE;
                    }
                    OpenIdCredentials credentials = new OpenIdCredentials(authCode, this.getRedirectUri(request), this._configuration);
                    UserIdentity user = this.login(null, credentials, (ServletRequest)request);
                    HttpSession session = request.getSession(false);
                    if (user != null) {
                        String nuri;
                        HttpSession httpSession = session;
                        synchronized (httpSession) {
                            nuri = (String)session.getAttribute(J_URI);
                            if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                                nuri = "/";
                            }
                        }
                        OpenIdAuthentication openIdAuth = new OpenIdAuthentication(this.getAuthMethod(), user);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("authenticated {}->{}", new Object[]{openIdAuth, nuri});
                        }
                        response.setContentLength(0);
                        baseResponse.sendRedirect(OpenIdAuthenticator.getRedirectCode(baseRequest.getHttpVersion()), nuri);
                        return openIdAuth;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OpenId authentication FAILED", new Object[0]);
                }
                if (this._errorPage == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth failed 403", new Object[0]);
                    }
                    if (response != null) {
                        response.sendError(403);
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth failed {}", new Object[]{this._errorPage});
                    }
                    baseResponse.sendRedirect(OpenIdAuthenticator.getRedirectCode(baseRequest.getHttpVersion()), URIUtil.addPaths((String)request.getContextPath(), (String)this._errorPage));
                }
                return Authentication.SEND_FAILURE;
            }
            HttpSession session = request.getSession(false);
            Authentication authentication2 = authentication = session == null ? null : (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authentication != null) {
                if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth revoked {}", new Object[]{authentication});
                    }
                    session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                } else {
                    HttpSession antiForgeryToken = session;
                    synchronized (antiForgeryToken) {
                        String jUri = (String)session.getAttribute(J_URI);
                        if (jUri != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("auth retry {}->{}", new Object[]{authentication, jUri});
                            }
                            StringBuffer buf = request.getRequestURL();
                            if (request.getQueryString() != null) {
                                buf.append("?").append(request.getQueryString());
                            }
                            if (jUri.equals(buf.toString())) {
                                MultiMap jPost = (MultiMap)session.getAttribute(J_POST);
                                if (jPost != null) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("auth rePOST {}->{}", new Object[]{authentication, jUri});
                                    }
                                    baseRequest.setContentParameters(jPost);
                                }
                                session.removeAttribute(J_URI);
                                session.removeAttribute(J_METHOD);
                                session.removeAttribute(J_POST);
                            }
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth {}", new Object[]{authentication});
                    }
                    return authentication;
                }
            }
            if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("auth deferred {}", new Object[]{session == null ? null : session.getId()});
                }
                return Authentication.UNAUTHENTICATED;
            }
            HttpSession antiForgeryToken = session = session != null ? session : request.getSession(true);
            synchronized (antiForgeryToken) {
                if (session.getAttribute(J_URI) == null || this.isAlwaysSaveUri()) {
                    StringBuffer buf = request.getRequestURL();
                    if (request.getQueryString() != null) {
                        buf.append("?").append(request.getQueryString());
                    }
                    session.setAttribute(J_URI, (Object)buf.toString());
                    session.setAttribute(J_METHOD, (Object)request.getMethod());
                    if (MimeTypes.Type.FORM_ENCODED.is(req.getContentType()) && HttpMethod.POST.is(request.getMethod())) {
                        MultiMap formParameters = new MultiMap();
                        baseRequest.extractFormParameters(formParameters);
                        session.setAttribute(J_POST, (Object)formParameters);
                    }
                }
            }
            String challengeUri = this.getChallengeUri(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("challenge {}->{}", new Object[]{session.getId(), challengeUri});
            }
            baseResponse.sendRedirect(OpenIdAuthenticator.getRedirectCode(baseRequest.getHttpVersion()), challengeUri);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + J_SECURITY_CHECK.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isErrorPage(String pathInContext) {
        return pathInContext != null && pathInContext.equals(this._errorPath);
    }

    private static int getRedirectCode(HttpVersion httpVersion) {
        return httpVersion.getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
    }

    private String getRedirectUri(HttpServletRequest request) {
        StringBuffer redirectUri = new StringBuffer(128);
        URIUtil.appendSchemeHostPort((StringBuffer)redirectUri, (String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort());
        redirectUri.append(request.getContextPath());
        redirectUri.append(J_SECURITY_CHECK);
        return redirectUri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getChallengeUri(HttpServletRequest request) {
        String antiForgeryToken;
        HttpSession session;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            antiForgeryToken = session.getAttribute(CSRF_TOKEN) == null ? new BigInteger(130, new SecureRandom()).toString(32) : (String)session.getAttribute(CSRF_TOKEN);
            session.setAttribute(CSRF_TOKEN, (Object)antiForgeryToken);
        }
        StringBuilder scopes = new StringBuilder();
        for (String s : this._configuration.getScopes()) {
            scopes.append(" ").append(s);
        }
        return this._configuration.getAuthEndpoint() + "?client_id=" + UrlEncoded.encodeString((String)this._configuration.getClientId(), (Charset)StandardCharsets.UTF_8) + "&redirect_uri=" + UrlEncoded.encodeString((String)this.getRedirectUri(request), (Charset)StandardCharsets.UTF_8) + "&scope=openid" + UrlEncoded.encodeString((String)scopes.toString(), (Charset)StandardCharsets.UTF_8) + "&state=" + antiForgeryToken + "&response_type=code";
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }

    public static class OpenIdAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public OpenIdAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        public String toString() {
            return "OpenId" + super.toString();
        }
    }
}

