/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CloudDatastoreV1Client;
import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.primitives.Bytes;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

class InternalTransactionCloudDatastoreV1
implements TransactionImpl.InternalTransaction {
    private static final String TXN_ID_PREFIX = "v1-";
    private final CommitRequest.Builder commitReqBuilder = CommitRequest.newBuilder();
    private static final AtomicLong clientIdGenerator = new AtomicLong();
    private static final Map<String, InternalTransactionCloudDatastoreV1> internalTransactionRegister = new MapMaker().weakValues().makeMap();
    private final String clientId;
    private final Map<com.google.appengine.repackaged.com.google.datastore.v1.Key, byte[]> mutationMap;
    private final Future<BeginTransactionResponse> beginTxnFuture;
    protected final CloudDatastoreV1Client dsApiProxy;
    private boolean isWritable;
    private final boolean isReadOnly;

    private InternalTransactionCloudDatastoreV1(CloudDatastoreV1Client dsApiProxy, Future<BeginTransactionResponse> beginTxnFuture, boolean isReadOnly) {
        String string = String.valueOf(TXN_ID_PREFIX);
        String string2 = String.valueOf(Long.toString(clientIdGenerator.getAndIncrement()));
        this.clientId = string2.length() != 0 ? string.concat(string2) : new String(string);
        this.mutationMap = Maps.newLinkedHashMap();
        this.isWritable = true;
        this.dsApiProxy = dsApiProxy;
        this.beginTxnFuture = beginTxnFuture;
        this.isReadOnly = isReadOnly;
    }

    static TransactionImpl.InternalTransaction create(CloudDatastoreV1Client dsApiProxy, Future<BeginTransactionResponse> future, boolean isReadOnly) {
        return InternalTransactionCloudDatastoreV1.registerTxn(new InternalTransactionCloudDatastoreV1(dsApiProxy, future, isReadOnly));
    }

    byte[] serializeMutation(Mutation mutation) {
        byte[] bytes = this.commitReqBuilder.addMutations(mutation).buildPartial().toByteArray();
        this.commitReqBuilder.clearMutations();
        return bytes;
    }

    Future<?> sendCommit(Collection<byte[]> mutations) {
        byte[][] protoSegmentsArray = new byte[mutations.size() + 1][];
        protoSegmentsArray[0] = CommitRequest.newBuilder().setTransaction(this.getTransactionBytes()).build().toByteArray();
        int arrayIndex = 1;
        for (byte[] mutData : mutations) {
            protoSegmentsArray[arrayIndex++] = mutData;
        }
        try {
            return this.dsApiProxy.rawCommit(Bytes.concat(protoSegmentsArray));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
    }

    static InternalTransactionCloudDatastoreV1 registerTxn(InternalTransactionCloudDatastoreV1 txn) {
        internalTransactionRegister.put(txn.clientId, txn);
        return txn;
    }

    ByteString getTransactionBytes() {
        return FutureHelper.quietGet(this.beginTxnFuture).getTransaction();
    }

    void deferPut(Entity entity) {
        this.deferPut(DataTypeTranslator.toV1Entity(entity));
    }

    void deferPut(Entity.Builder entityProto) {
        this.checkWritable();
        this.checkNotReadOnly();
        this.mutationMap.put(entityProto.getKey(), this.serializeMutation(Mutation.newBuilder().setUpsert(entityProto).build()));
    }

    void deferDelete(Key key) {
        this.checkWritable();
        this.checkNotReadOnly();
        com.google.appengine.repackaged.com.google.datastore.v1.Key keyV1 = DataTypeTranslator.toV1Key(key).build();
        this.mutationMap.put(keyV1, this.serializeMutation(Mutation.newBuilder().setDelete(keyV1).build()));
    }

    @Override
    public Future<Void> doCommitAsync() {
        this.isWritable = false;
        VoidFutureWrapper result = new VoidFutureWrapper(this.sendCommit(this.mutationMap.values()));
        this.mutationMap.clear();
        return result;
    }

    @Override
    public Future<Void> doRollbackAsync() {
        this.isWritable = false;
        this.mutationMap.clear();
        return new VoidFutureWrapper<RollbackResponse>(this.dsApiProxy.rollback(RollbackRequest.newBuilder().setTransaction(this.getTransactionBytes()).build()));
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    private void checkWritable() {
        if (!this.isWritable) {
            throw new IllegalStateException("Transaction is not writable.");
        }
    }

    private void checkNotReadOnly() {
        if (this.isReadOnly) {
            throw new IllegalArgumentException("Attempting to write to a read-only transaction.");
        }
    }

    static InternalTransactionCloudDatastoreV1 get(Transaction txn) {
        String txnId = txn.getId();
        InternalTransactionCloudDatastoreV1 txnImpl = internalTransactionRegister.get(txnId);
        if (txnImpl == null) {
            String string = String.valueOf(txnId);
            throw new IllegalArgumentException(string.length() != 0 ? "Transaction not found with ID: ".concat(string) : new String("Transaction not found with ID: "));
        }
        return txnImpl;
    }

    static boolean isV1Transaction(Transaction txn) {
        return internalTransactionRegister.containsKey(txn.getId());
    }

    private static class VoidFutureWrapper<T>
    extends FutureWrapper<T, Void> {
        public VoidFutureWrapper(Future<T> parent) {
            super(parent);
        }

        @Override
        protected Void wrap(T ignore) throws Exception {
            return null;
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            return cause;
        }
    }
}

