/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.jetty9;

import com.google.appengine.api.log.dev.DevLogHandler;
import com.google.appengine.api.log.dev.LocalLogService;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.FluentIterable;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.repackaged.com.google.common.time.Instants;
import com.google.appengine.repackaged.com.google.common.time.TimeSource;
import com.google.appengine.tools.development.AbstractContainerService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerModulesFilter;
import com.google.appengine.tools.development.IsolatedAppClassLoader;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.LocalHttpRequestEnvironment;
import com.google.appengine.tools.development.jetty9.AppEngineAnnotationConfiguration;
import com.google.appengine.tools.development.jetty9.DevAppEngineWebAppContext;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.jetty94.SessionManagerHandler;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebModule;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.NetworkTrafficSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyContainerService
extends AbstractContainerService {
    private static final Logger log = Logger.getLogger(JettyContainerService.class.getName());
    private static final String JETTY_TAG_LIB_JAR_PREFIX = "org.apache.taglibs.taglibs-";
    private static final Pattern JSP_REGEX = Pattern.compile(".*\\.jspx?");
    private static final String FILES_API_DEPRECATION_WARNING = "The Files API is deprecated and will soon be removed. Further information is available  here: https://cloud.google.com/appengine/docs/deprecations/files_api";
    public static final String WEB_DEFAULTS_XML = "com/google/appengine/tools/development/jetty9/webdefault.xml";
    private static final int MAX_SIMULTANEOUS_API_CALLS = 100;
    private static final Long SOFT_DEADLINE_DELAY_MS = 60000L;
    private static final String[] CONFIG_CLASSES = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), AppEngineAnnotationConfiguration.class.getCanonicalName()};
    private static final String WEB_XML_ATTR = "com.google.appengine.tools.development.webXml";
    private static final String APPENGINE_WEB_XML_ATTR = "com.google.appengine.tools.development.appEngineWebXml";
    private boolean disableFilesApiWarning = false;
    private static final int SCAN_INTERVAL_SECONDS = 5;
    private WebAppContext context;
    private AppContext appContext;
    private Server server;
    private Scanner scanner;
    private final Set<LocalEnvironment> environments = ConcurrentHashMap.newKeySet();

    @Override
    protected File initContext() throws IOException {
        this.context = new DevAppEngineWebAppContext(this.appDir, this.externalResourceDir, this.devAppServerVersion, this.apiProxyDelegate, this.devAppServer);
        this.context.addEventListener((EventListener)new ContextHandler.ContextScopeListener(){

            public void enterScope(ContextHandler.Context context, Request request, Object reason) {
                LocalEnvironment env;
                LocalEnvironment localEnvironment = env = request == null ? (LocalEnvironment)JettyContainerService.this.environments.stream().findAny().orElse(null) : (LocalEnvironment)request.getAttribute(LocalEnvironment.class.getName());
                if (env != null) {
                    ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)env);
                    DevAppServerModulesFilter.injectBackendServiceCurrentApiInfo(JettyContainerService.this.backendName, JettyContainerService.this.backendInstance, JettyContainerService.this.portMappingProvider.getPortMapping());
                }
            }

            public void exitScope(ContextHandler.Context context, Request request) {
                ApiProxy.clearEnvironmentForCurrentThread();
            }
        });
        this.appContext = new JettyAppContext();
        this.context.setDescriptor(this.webXmlLocation == null ? null : this.webXmlLocation.getAbsolutePath());
        String webDefaultXml = this.devAppServer.getServiceProperties().getOrDefault("appengine.webdefault.xml", WEB_DEFAULTS_XML);
        this.context.setDefaultsDescriptor(webDefaultXml);
        this.context.setConfigurationClasses(CONFIG_CLASSES);
        File appRoot = this.determineAppRoot();
        this.installLocalInitializationEnvironment();
        if (JettyContainerService.applicationContainsJSP(this.appDir, JSP_REGEX)) {
            for (File file : AppengineSdk.getSdk().getUserJspLibFiles()) {
                if (!file.getName().startsWith(JETTY_TAG_LIB_JAR_PREFIX)) continue;
                String string = String.valueOf(this.appDir);
                String string2 = file.getName();
                File jettyProvidedDestination = new File(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/WEB-INF/lib/").append(string2).toString());
                if (jettyProvidedDestination.exists()) continue;
                string2 = String.valueOf(this.appDir);
                String string3 = file.getName().substring(JETTY_TAG_LIB_JAR_PREFIX.length());
                File mavenProvidedDestination = new File(new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("/WEB-INF/lib/").append(string3).toString());
                if (mavenProvidedDestination.exists()) continue;
                string2 = file.getName();
                log.logp(Level.WARNING, "com.google.appengine.tools.development.jetty9.JettyContainerService", "initContext", new StringBuilder(114 + String.valueOf(string2).length()).append("Adding jar ").append(string2).append(" to WEB-INF/lib. You might want to add a dependency in your project build system to avoid this warning.").toString());
                try {
                    Files.copy(file, jettyProvidedDestination);
                }
                catch (IOException e) {
                    log.logp(Level.WARNING, "com.google.appengine.tools.development.jetty9.JettyContainerService", "initContext", "Cannot copy org.apache.taglibs.taglibs jar file to WEB-INF/lib.", e);
                }
            }
        }
        URL[] classPath = this.getClassPathForApp(appRoot);
        this.context.setClassLoader((ClassLoader)new IsolatedAppClassLoader(appRoot, this.externalResourceDir, classPath, JettyContainerService.class.getClassLoader()));
        if (Boolean.parseBoolean(System.getProperty("appengine.allowRemoteShutdown"))) {
            this.context.addServlet(new ServletHolder((Servlet)new ServerShutdownServlet()), "/_ah/admin/quit");
        }
        if (Boolean.parseBoolean(System.getProperty("appengine.disableFilesApiWarning"))) {
            this.disableFilesApiWarning = true;
        }
        return appRoot;
    }

    private static boolean applicationContainsJSP(File dir, Pattern jspPattern) {
        for (File file : FluentIterable.from(Files.fileTraverser().depthFirstPreOrder(dir)).filter(Predicates.not(Files.isDirectory()))) {
            if (!jspPattern.matcher(file.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectContainer() throws Exception {
        this.moduleConfigurationHandle.checkEnvironmentVariables();
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCcl = currentThread.getContextClassLoader();
        this.server = new Server();
        try {
            NetworkTrafficSelectChannelConnector connector = new NetworkTrafficSelectChannelConnector(this.server, null, null, null, 0, Runtime.getRuntime().availableProcessors(), new ConnectionFactory[]{new HttpConnectionFactory()});
            connector.addBean((Object)new CompletionListener());
            connector.setHost(this.address);
            connector.setPort(this.port);
            connector.setSoLingerTime(0);
            connector.open();
            this.server.addConnector((Connector)connector);
            this.port = connector.getLocalPort();
        }
        finally {
            currentThread.setContextClassLoader(previousCcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startContainer() throws Exception {
        this.context.setAttribute(WEB_XML_ATTR, (Object)this.webXml);
        this.context.setAttribute(APPENGINE_WEB_XML_ATTR, (Object)this.appEngineWebXml);
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCcl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            ApiProxyHandler apiHandler = new ApiProxyHandler(this.appEngineWebXml);
            apiHandler.setHandler((Handler)this.context);
            this.server.setHandler((Handler)apiHandler);
            SessionManagerHandler.create(SessionManagerHandler.Config.builder().setEnableSession(this.isSessionsEnabled()).setServletContextHandler((ServletContextHandler)this.context).build());
            this.server.start();
        }
        finally {
            currentThread.setContextClassLoader(previousCcl);
        }
    }

    @Override
    protected void stopContainer() throws Exception {
        this.server.stop();
    }

    @Override
    protected void startHotDeployScanner() throws Exception {
        String fullScanInterval = System.getProperty("appengine.fullscan.seconds");
        if (fullScanInterval != null) {
            try {
                int interval = Integer.parseInt(fullScanInterval);
                if (interval < 1) {
                    log.logp(Level.INFO, "com.google.appengine.tools.development.jetty9.JettyContainerService", "startHotDeployScanner", "Full scan of the web app for changes is disabled.");
                    return;
                }
                log.logp(Level.INFO, "com.google.appengine.tools.development.jetty9.JettyContainerService", "startHotDeployScanner", new StringBuilder(53).append("Full scan of the web app in place every ").append(interval).append("s.").toString());
                this.fullWebAppScanner(interval);
                return;
            }
            catch (NumberFormatException ex) {
                log.logp(Level.WARNING, "com.google.appengine.tools.development.jetty9.JettyContainerService", "startHotDeployScanner", "appengine.fullscan.seconds property is not an integer:", ex);
                log.logp(Level.WARNING, "com.google.appengine.tools.development.jetty9.JettyContainerService", "startHotDeployScanner", "Using the default scanning method.");
            }
        }
        this.scanner = new Scanner();
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setScanInterval(5);
        this.scanner.setScanDirs(ImmutableList.of(this.getScanTarget()));
        this.scanner.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                try {
                    return name.equals(JettyContainerService.this.getScanTarget().getName());
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        this.scanner.addListener((Scanner.Listener)new ScannerListener());
        this.scanner.doStart();
    }

    @Override
    protected void stopHotDeployScanner() throws Exception {
        if (this.scanner != null) {
            this.scanner.stop();
        }
        this.scanner = null;
    }

    private File getScanTarget() throws Exception {
        if (this.appDir.isFile() || this.context.getWebInf() == null) {
            return this.appDir;
        }
        String string = this.context.getWebInf().getFile().getPath();
        String string2 = File.separator;
        return new File(new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("appengine-web.xml").toString());
    }

    private void fullWebAppScanner(int interval) throws IOException {
        String webInf = this.context.getWebInf().getFile().getPath();
        ArrayList scanList = new ArrayList();
        Collections.addAll(scanList, new File(webInf, "classes"), new File(webInf, "lib"), new File(webInf, "web.xml"), new File(webInf, "appengine-web.xml"));
        this.scanner = new Scanner();
        this.scanner.setScanInterval(interval);
        this.scanner.setScanDirs(scanList);
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setRecursive(true);
        this.scanner.addListener((Scanner.Listener)new Scanner.BulkListener(){

            public void filesChanged(List<String> changedFiles) throws Exception {
                log.logp(Level.INFO, "com.google.appengine.tools.development.jetty9.JettyContainerService$3", "filesChanged", "A file has changed, reloading the web application.");
                JettyContainerService.this.reloadWebApp();
            }
        });
        this.scanner.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reloadWebApp() throws Exception {
        Resource.setDefaultUseCaches((boolean)false);
        this.server.getHandler().stop();
        this.server.stop();
        this.moduleConfigurationHandle.restoreSystemProperties();
        this.moduleConfigurationHandle.readConfiguration();
        this.moduleConfigurationHandle.checkEnvironmentVariables();
        this.extractFieldsFromWebModule(this.moduleConfigurationHandle.getModule());
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCcl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            this.initContext();
            this.installLocalInitializationEnvironment();
            this.context.setAttribute(WEB_XML_ATTR, (Object)this.webXml);
            this.context.setAttribute(APPENGINE_WEB_XML_ATTR, (Object)this.appEngineWebXml);
            ApiProxyHandler apiHandler = new ApiProxyHandler(this.appEngineWebXml);
            apiHandler.setHandler((Handler)this.context);
            this.server.setHandler((Handler)apiHandler);
            SessionManagerHandler.create(SessionManagerHandler.Config.builder().setEnableSession(this.isSessionsEnabled()).setServletContextHandler((ServletContextHandler)this.context).build());
            this.server.start();
        }
        finally {
            currentThread.setContextClassLoader(previousCcl);
        }
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }

    @Override
    public void forwardToServer(HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        String string = this.appEngineWebXml.getModule();
        int n = this.instance;
        log.logp(Level.FINEST, "com.google.appengine.tools.development.jetty9.JettyContainerService", "forwardToServer", new StringBuilder(42 + String.valueOf(string).length()).append("forwarding request to module: ").append(string).append(".").append(n).toString());
        RequestDispatcher requestDispatcher = this.context.getServletContext().getRequestDispatcher(hrequest.getRequestURI());
        requestDispatcher.forward((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    private File determineAppRoot() throws IOException {
        Resource webInf = this.context.getWebInf();
        if (webInf == null) {
            if (this.userCodeClasspathManager.requiresWebInf()) {
                throw new AppEngineConfigException("Supplied application has to contain WEB-INF directory.");
            }
            return this.appDir;
        }
        return webInf.getFile().getParentFile();
    }

    static {
        System.setProperty("org.eclipse.jetty.util.log.class", " com.google.appengine.development.jetty9.JettyLogger");
    }

    private class CompletionListener
    implements HttpChannel.Listener {
        private CompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(Request request) {
            try {
                if (request.getRequestURI().startsWith("/_ah/reloadwebapp")) {
                    try {
                        JettyContainerService.this.reloadWebApp();
                        String string = String.valueOf(request.getParameter("info"));
                        log.logp(Level.INFO, "com.google.appengine.tools.development.jetty9.JettyContainerService$CompletionListener", "onComplete", string.length() != 0 ? "Reloaded the webapp context: ".concat(string) : new String("Reloaded the webapp context: "));
                    }
                    catch (Exception ex) {
                        log.logp(Level.WARNING, "com.google.appengine.tools.development.jetty9.JettyContainerService$CompletionListener", "onComplete", "Failed to reload the current webapp context.", ex);
                    }
                }
            }
            finally {
                LocalEnvironment env = (LocalEnvironment)request.getAttribute(LocalEnvironment.class.getName());
                if (env != null) {
                    JettyContainerService.this.environments.remove(env);
                    Semaphore semaphore = (Semaphore)env.getAttributes().get("com.google.appengine.tools.development.api_call_semaphore");
                    try {
                        semaphore.acquire(100);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        log.logp(Level.WARNING, "com.google.appengine.tools.development.jetty9.JettyContainerService$CompletionListener", "onComplete", "Interrupted while waiting for API calls to complete:", ex);
                    }
                    try {
                        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)env);
                        env.callRequestEndListeners();
                        if (JettyContainerService.this.apiProxyDelegate instanceof ApiProxyLocal) {
                            ApiProxyLocal apiProxyLocal = (ApiProxyLocal)JettyContainerService.this.apiProxyDelegate;
                            String appId = env.getAppId();
                            String versionId = env.getVersionId();
                            String requestId = DevLogHandler.getRequestId();
                            LocalLogService logService = (LocalLogService)apiProxyLocal.getService("logservice");
                            if (!JettyContainerService.this.disableFilesApiWarning && ((Boolean)env.getAttributes().get("com.google.appengine.api.files.filesapi_was_used")).booleanValue()) {
                                log.logp(Level.WARNING, "com.google.appengine.tools.development.jetty9.JettyContainerService$CompletionListener", "onComplete", JettyContainerService.FILES_API_DEPRECATION_WARNING);
                            }
                            logService.addRequestInfo(appId, versionId, requestId, request.getRemoteAddr(), request.getRemoteUser(), request.getTimeStamp() * 1000L, Instants.toEpochMicros(TimeSource.system().now()), request.getMethod(), request.getRequestURI(), request.getProtocol(), request.getHeader("User-Agent"), true, Integer.valueOf(request.getResponse().getStatus()), request.getHeader("Referrer"));
                            logService.clearResponseSize();
                        }
                    }
                    finally {
                        ApiProxy.clearEnvironmentForCurrentThread();
                    }
                }
            }
        }
    }

    private class ApiProxyHandler
    extends HandlerWrapper {
        private final AppEngineWebXml appEngineWebXml;

        public ApiProxyHandler(AppEngineWebXml appEngineWebXml) {
            this.appEngineWebXml = appEngineWebXml;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (baseRequest.getDispatcherType() == DispatcherType.REQUEST) {
                Semaphore semaphore = new Semaphore(100);
                LocalHttpRequestEnvironment env = new LocalHttpRequestEnvironment(this.appEngineWebXml.getAppId(), WebModule.getModuleName(this.appEngineWebXml), this.appEngineWebXml.getMajorVersionId(), JettyContainerService.this.instance, JettyContainerService.this.getPort(), request, SOFT_DEADLINE_DELAY_MS, JettyContainerService.this.modulesFilterHelper);
                env.getAttributes().put("com.google.appengine.tools.development.api_call_semaphore", semaphore);
                int n = JettyContainerService.this.devAppServer.getPort();
                env.getAttributes().put("com.google.appengine.runtime.default_version_hostname", new StringBuilder(21).append("localhost:").append(n).toString());
                env.getAttributes().put("com.google.appengine.api.files.filesapi_was_used", false);
                request.setAttribute(LocalEnvironment.class.getName(), (Object)env);
                JettyContainerService.this.environments.add(env);
            }
            super.handle(target, baseRequest, request, response);
        }
    }

    private class ScannerListener
    implements Scanner.DiscreteListener {
        private ScannerListener() {
        }

        public void fileAdded(String filename) throws Exception {
            this.fileChanged(filename);
        }

        public void fileChanged(String filename) throws Exception {
            log.logp(Level.INFO, "com.google.appengine.tools.development.jetty9.JettyContainerService$ScannerListener", "fileChanged", String.valueOf(filename).concat(" updated, reloading the webapp!"));
            JettyContainerService.this.reloadWebApp();
        }

        public void fileRemoved(String filename) throws Exception {
        }
    }

    static class ServerShutdownServlet
    extends HttpServlet {
        ServerShutdownServlet() {
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().println("Shutting down local server.");
            resp.flushBuffer();
            DevAppServer server = (DevAppServer)this.getServletContext().getAttribute("com.google.appengine.devappserver.Server");
            server.gracefulShutdown();
        }
    }

    private class JettyAppContext
    implements AppContext {
        private JettyAppContext() {
        }

        @Override
        public ClassLoader getClassLoader() {
            return JettyContainerService.this.context.getClassLoader();
        }

        @Override
        public Permissions getUserPermissions() {
            return JettyContainerService.this.getUserPermissions();
        }

        @Override
        public Permissions getApplicationPermissions() {
            throw new RuntimeException("No permissions needed for this runtime.");
        }

        @Override
        public Object getContainerContext() {
            return JettyContainerService.this.context;
        }
    }
}

